/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.AddActionItem;
import org.openide.util.NbBundle;

public abstract class AddActionPresenter
extends Presenter {
    public static final String ADD_ACTION = NbBundle.getMessage(AddActionPresenter.class, (String)"NAME_AddActionPresenter");
    protected static final Comparator<Action> ACTIONS_COMPARATOR = new Comparator<Action>(){

        @Override
        public int compare(Action s1, Action s2) {
            String name1 = s1.getValue("Name").toString();
            String name2 = s2.getValue("Name").toString();
            return name1.compareTo(name2);
        }
    };

    public static final Presenter create(Integer order, TypeID ... types) {
        return AddActionPresenter.create(null, order, types);
    }

    public static final Presenter create(final String name, final int order, final TypeID ... types) {
        return new AddActionPresenter(){

            @Override
            public Integer getOrder() {
                return order;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public AddActionItem[] getAddActionItems() {
                ArrayList<AddActionItem> actions = new ArrayList<AddActionItem>();
                DesignDocument document = this.getComponent().getDocument();
                for (TypeID type : types) {
                    for (ComponentDescriptor descriptor : document.getDescriptorRegistry().getComponentDescriptors()) {
                        if (!this.getComponent().getDocument().getDescriptorRegistry().isInHierarchy(type, descriptor.getTypeDescriptor().getThisType())) continue;
                        for (ComponentProducer producer : document.getDescriptorRegistry().getComponentProducers()) {
                            Boolean isValid;
                            if (!producer.getMainComponentTypeID().equals(descriptor.getTypeDescriptor().getThisType()) || !AcceptSupport.isAcceptable(this.getComponent(), producer, null) || (isValid = producer.checkValidity(document, true)) == null || !isValid.booleanValue()) continue;
                            actions.add(AddActionItem.getInstance(this.getComponent(), producer));
                        }
                    }
                }
                Collections.sort(actions, ACTIONS_COMPARATOR);
                return actions.toArray(new AddActionItem[actions.size()]);
            }
        };
    }

    public abstract Integer getOrder();

    public abstract String getName();

    public abstract AddActionItem[] getAddActionItems();
}

