/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.web.client.tools.api.Log;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class FirefoxBrowserUtils {
    public static final String PROFILE_PREF = "firefox-defaultProfile";
    private static final String APPDATA_CMD = "cmd /c echo %AppData%";
    private static final String[] WIN32_PROFILES_LOCATIONS = new String[]{"\\Mozilla\\Firefox\\"};
    private static final String[] LINUX_PROFILES_LOCATIONS = new String[]{"/.mozilla/firefox/"};
    private static final String[] MACOSX_PROFILES_LOCATIONS = new String[]{"/Library/Application Support/Firefox/", "/Library/Mozilla/Firefox/"};

    public static File getProfileFromPreferences() {
        Preferences prefs = NbPreferences.forModule(FirefoxBrowserUtils.class);
        String location = prefs.get(PROFILE_PREF, "");
        if (location.length() > 0) {
            File f = new File(location);
            return f.isDirectory() ? f : null;
        }
        return null;
    }

    public static File getDefaultProfile() {
        String[] firefoxDirs = FirefoxBrowserUtils.getLocationsForOS();
        if (firefoxDirs != null) {
            for (String firefoxUserDir : firefoxDirs) {
                File dir = new File(firefoxUserDir);
                if (!dir.isDirectory() || !dir.exists()) continue;
                List<FirefoxProfile> profiles = FirefoxBrowserUtils.getAllProfiles(dir);
                if (profiles == null || profiles.size() == 0) {
                    File profilesDir = new File(dir, "Profiles");
                    if (!profilesDir.isDirectory()) continue;
                    File[] childrenFiles = profilesDir.listFiles();
                    for (int i = 0; childrenFiles != null && i < childrenFiles.length; ++i) {
                        File childFile = childrenFiles[i];
                        if (!childFile.isDirectory() || !childFile.getAbsolutePath().endsWith(".default")) continue;
                        return childFile;
                    }
                    continue;
                }
                for (FirefoxProfile profile : profiles) {
                    if (!profile.isDefaultProfile()) continue;
                    File profileDir = null;
                    profileDir = profile.isRelative() ? new File(dir, profile.getPath()) : new File(profile.getPath());
                    if (!profileDir.isDirectory()) continue;
                    return profileDir;
                }
                for (FirefoxProfile profile : profiles) {
                    File profileDir = null;
                    profileDir = profile.isRelative() ? new File(dir, profile.getPath()) : new File(profile.getPath());
                    if (!profileDir.isDirectory()) continue;
                    return profileDir;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFirefox2(HtmlBrowser.Factory browser, File defaultProfile, StringBuffer actualVersion) {
        String browserExecutable = FirefoxBrowserUtils.getBrowserExecutable(browser);
        if (browserExecutable == null) {
            return FirefoxBrowserUtils.isCompatibleFirefox(defaultProfile);
        }
        File firefox_js = new File(new File(browserExecutable).getParentFile(), "defaults/pref/firefox.js");
        if (!firefox_js.exists()) {
            return FirefoxBrowserUtils.isCompatibleFirefox(defaultProfile);
        }
        Pattern lineMatch = Pattern.compile("\\s*pref\\s*\\(\\s*\"general\\.useragent\\.extra\\.firefox\"");
        Pattern versionMatch = Pattern.compile("\"Firefox/[^\"]+\"");
        int majorVersion = -1;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(firefox_js));
            while (br.ready()) {
                Matcher matcher;
                String nextLine = br.readLine();
                if (!lineMatch.matcher(nextLine).find() || !(matcher = versionMatch.matcher(nextLine)).find()) continue;
                String version = matcher.group();
                majorVersion = Integer.valueOf(version.substring(9, 10));
                if (actualVersion == null) break;
                actualVersion.append(version);
                break;
            }
            boolean nextLine = majorVersion == 2;
            return nextLine;
        }
        catch (IOException ex) {
            Log.getLogger().log(Level.INFO, "Error reading Firefox version.", ex);
            boolean bl = FirefoxBrowserUtils.isCompatibleFirefox(defaultProfile);
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    Log.getLogger().log(Level.SEVERE, "Could not read Firefox version file", ex);
                }
            }
        }
    }

    private static String[] getLocationsForOS() {
        if (Utilities.isWindows()) {
            return FirefoxBrowserUtils.getUserPaths(WIN32_PROFILES_LOCATIONS);
        }
        if (Utilities.isMac()) {
            return FirefoxBrowserUtils.getUserPaths(MACOSX_PROFILES_LOCATIONS);
        }
        return FirefoxBrowserUtils.getUserPaths(LINUX_PROFILES_LOCATIONS);
    }

    private static String[] getUserPaths(String[] paths) {
        String[] result = new String[paths.length];
        String appRoot = FirefoxBrowserUtils.getUserHome();
        if (appRoot == null) {
            return null;
        }
        for (int i = 0; i < paths.length; ++i) {
            result[i] = appRoot + paths[i];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUserHome() {
        String userHome = System.getProperty("user.home");
        if (!Utilities.isWindows()) {
            return userHome;
        }
        String appData = userHome + File.separator + NbBundle.getMessage(FirefoxBrowserUtils.class, (String)"WIN32_APPDATA_FOLDER");
        BufferedReader br = null;
        try {
            Process process = Runtime.getRuntime().exec(APPDATA_CMD);
            process.waitFor();
            InputStream input = process.getInputStream();
            br = new BufferedReader(new InputStreamReader(input));
            while (true) {
                if (br.ready()) {
                    String nextLine = br.readLine();
                    if (nextLine.trim().length() == 0) continue;
                    File f = new File(nextLine.trim());
                    if (!f.exists() || !f.isDirectory()) continue;
                    String string = f.getAbsolutePath();
                    return string;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            Log.getLogger().info("Unable to run process: cmd /c echo %AppData%");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return appData;
    }

    protected static String getBrowserExecutable(HtmlBrowser.Factory browser) {
        if (browser != null) {
            try {
                Method method = browser.getClass().getMethod("getBrowserExecutable", new Class[0]);
                NbProcessDescriptor processDescriptor = (NbProcessDescriptor)method.invoke((Object)browser, new Object[0]);
                return processDescriptor.getProcessName();
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isCompatibleFirefox(File defaultProfile) {
        if (defaultProfile == null && (defaultProfile = FirefoxBrowserUtils.getDefaultProfile()) == null) {
            Log.getLogger().warning("Could not find Firefox profile data");
            return false;
        }
        File compatibilityDotIni = new File(defaultProfile, "compatibility.ini");
        if (compatibilityDotIni.exists() && compatibilityDotIni.isFile() && compatibilityDotIni.canRead()) {
            try {
                String aLine;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(compatibilityDotIni));
                while ((aLine = bufferedReader.readLine()) != null) {
                    if (!aLine.startsWith("LastVersion=")) continue;
                    aLine = aLine.substring(12);
                    return aLine.startsWith("2.0.0");
                }
            }
            catch (FileNotFoundException ex) {
                Log.getLogger().log(Level.INFO, "File not found: " + compatibilityDotIni.getAbsolutePath());
            }
            catch (IOException ex) {
                Log.getLogger().log(Level.INFO, "Error reading " + compatibilityDotIni.getAbsolutePath());
            }
        }
        return false;
    }

    private static List<FirefoxProfile> getAllProfiles(File dir) {
        File profileCfg = new File(dir, "profiles.ini");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(profileCfg));
            ArrayList profileData = new ArrayList();
            ArrayList<String> currentProfile = null;
            while (reader.ready()) {
                String line = reader.readLine().trim();
                if (line.startsWith("[") && line.endsWith("]")) {
                    if (currentProfile != null) {
                        profileData.add(currentProfile);
                    }
                    currentProfile = new ArrayList<String>();
                    currentProfile.add(line);
                    continue;
                }
                if (line.indexOf(61) <= 0) continue;
                currentProfile.add(line);
            }
            if (currentProfile != null && !profileData.contains(currentProfile)) {
                profileData.add(currentProfile);
            }
            ArrayList<FirefoxProfile> allProfiles = new ArrayList<FirefoxProfile>();
            for (List list : profileData) {
                if (list.size() == 0 || !((String)list.get(0)).startsWith("[")) continue;
                FirefoxProfile profile = new FirefoxProfile();
                boolean isValidProfile = false;
                for (String line : list) {
                    int index = line.indexOf(61);
                    if (index <= 0 || index >= line.length() - 1) continue;
                    String var = line.substring(0, index);
                    String val = line.substring(index + 1, line.length());
                    if (var.equals("Name")) {
                        isValidProfile = true;
                        continue;
                    }
                    if (var.equals("IsRelative")) {
                        if (!val.equals("1")) continue;
                        profile.setRelative(true);
                        continue;
                    }
                    if (var.equals("Path")) {
                        profile.setPath(val);
                        continue;
                    }
                    if (!var.equals("Default") || !val.equals("1")) continue;
                    profile.setDefaultProfile(true);
                }
                if (!isValidProfile) continue;
                allProfiles.add(profile);
            }
            return allProfiles;
        }
        catch (IOException ex) {
            Log.getLogger().log(Level.WARNING, "Could not read Firefox profiles", ex);
            return null;
        }
    }

    private static final class FirefoxProfile {
        private boolean relative = false;
        private boolean defaultProfile = false;
        private String path = "";

        public boolean isDefaultProfile() {
            return this.defaultProfile;
        }

        public void setDefaultProfile(boolean defaultProfile) {
            this.defaultProfile = defaultProfile;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void setRelative(boolean relative) {
            this.relative = relative;
        }
    }
}

