/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.utils;

import java.util.NoSuchElementException;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;

public class FieldTokenizer {
    private String[] retval = new String[2];
    private MyStringTokenizer tok;
    private int anon_count;

    public FieldTokenizer(String fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        this.tok = new MyStringTokenizer(fields);
        this.anon_count = 0;
        this.retval[0] = null;
    }

    private void findNextField() {
        while (this.tok.hasMoreTokens()) {
            String token = this.tok.nextToken().trim();
            if (token.endsWith(")") || token.endsWith(") const")) continue;
            this.parseNextField(token);
            return;
        }
        if (this.anon_count > 0) {
            this.retval[0] = Integer.toString(this.anon_count);
            this.retval[1] = "<anon-count>";
            this.anon_count = 0;
        } else {
            this.retval[0] = null;
        }
    }

    private void parseNextField(String field) {
        boolean modified = true;
        field = field.replace("\\n", "").trim();
        while (modified) {
            modified = false;
            if (field.startsWith("static ")) {
                field = field.substring(7).trim();
                modified = true;
                continue;
            }
            if (field.startsWith("public: ")) {
                field = field.substring(8).trim();
                modified = true;
                continue;
            }
            if (field.startsWith("private: ")) {
                field = field.substring(9).trim();
                modified = true;
                continue;
            }
            if (field.startsWith("protected: ")) {
                field = field.substring(11).trim();
                modified = true;
                continue;
            }
            if (field.startsWith("virtual ")) {
                field = field.substring(8).trim();
                modified = true;
                continue;
            }
            if (field.startsWith("const ")) {
                field = field.substring(6).trim();
                modified = true;
                continue;
            }
            if (field.endsWith(" const")) {
                field = field.substring(0, field.length() - 6).trim();
                modified = true;
                continue;
            }
            if (!field.startsWith("\\n ")) continue;
            field = field.substring(2).trim();
            modified = true;
        }
        if (field.endsWith("}")) {
            this.retval[0] = field;
            this.retval[1] = "<anonymous" + ++this.anon_count + ">";
        } else {
            int pos = field.lastIndexOf(32);
            if (pos != -1) {
                int pos2 = field.indexOf(42, pos);
                if (pos2 != -1) {
                    while (field.charAt(pos2 + 1) == '*') {
                        ++pos2;
                    }
                    this.retval[0] = field.substring(0, pos2 + 1).trim();
                    this.retval[1] = field.substring(pos2 + 1).trim();
                } else {
                    this.retval[0] = field.substring(0, pos).trim();
                    this.retval[1] = field.substring(pos).trim();
                }
            } else {
                this.retval[0] = "int";
                this.retval[1] = field;
            }
        }
    }

    public boolean hasMoreFields() {
        this.findNextField();
        return this.retval[0] != null || this.anon_count != 0;
    }

    public String[] nextField() {
        if (this.retval[0] == null) {
            throw new NoSuchElementException();
        }
        return this.retval;
    }

    private static final class MyStringTokenizer {
        private String info;
        private int start;
        private int end;

        public MyStringTokenizer(String info) {
            this.info = info;
            this.start = 0;
        }

        public boolean hasMoreTokens() {
            return this.start < this.info.length();
        }

        public String nextToken() {
            String t;
            if (this.start >= this.info.length()) {
                throw new NoSuchElementException();
            }
            this.end = GdbUtils.findNextSemi(this.info, this.start);
            if (this.end == -1) {
                t = this.info.substring(this.start);
                this.start = this.info.length();
            } else {
                t = this.info.substring(this.start, this.end);
                this.start = this.end + 1;
            }
            return t;
        }
    }
}

