/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.font.TextLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutView;

public final class TextLayoutCache {
    private static final Logger LOG = Logger.getLogger(TextLayoutCache.class.getName());
    private static final int MAX_SIZE = 100;
    private final Map<ParagraphView, Entry> paragraph2entry = new HashMap<ParagraphView, Entry>();
    private Entry head;
    private Entry tail;

    synchronized void clear() {
        this.paragraph2entry.clear();
        this.tail = null;
        this.head = null;
    }

    synchronized TextLayout get(ParagraphView paragraphView, TextLayoutView childView) {
        TextLayout textLayout;
        assert (paragraphView != null && childView != null);
        Entry entry = this.paragraph2entry.get(paragraphView);
        if (entry == null) {
            entry = new Entry(paragraphView);
            this.paragraph2entry.put(paragraphView, entry);
            if (this.paragraph2entry.size() >= 100) {
                Entry lru = this.paragraph2entry.remove(this.tail.paragraphView);
                assert (lru == this.tail);
                this.removeChainEntry(lru);
            }
            this.addChainEntryFirst(entry);
        }
        if (this.head != entry) {
            this.removeChainEntry(entry);
            this.addChainEntryFirst(entry);
        }
        if ((textLayout = entry.view2layout.get(childView)) == null) {
            textLayout = childView.createTextLayout();
            if (textLayout != null) {
                entry.view2layout.put(childView, textLayout);
            } else {
                entry.view2layout.remove(childView);
            }
        }
        return textLayout;
    }

    synchronized void put(ParagraphView paragraphView, TextLayoutView childView, TextLayout textLayout) {
        Entry entry = this.paragraph2entry.get(paragraphView);
        if (entry == null) {
            return;
        }
        if (textLayout != null) {
            entry.view2layout.put(childView, textLayout);
        } else {
            entry.view2layout.remove(childView);
        }
    }

    synchronized void removeParagraph(ParagraphView paragraphView) {
        Entry entry = this.paragraph2entry.remove(paragraphView);
        if (entry != null) {
            this.removeChainEntry(entry);
        }
    }

    synchronized void remove(ParagraphView paragraphView, int childIndex, int childCount) {
        Entry entry = this.paragraph2entry.get(paragraphView);
        if (entry != null) {
            for (int i = 0; i < childCount; ++i) {
                Object childView = paragraphView.getEditorView(childIndex + i);
                if (!(childView instanceof TextLayoutView)) continue;
                entry.view2layout.remove((TextLayoutView)childView);
            }
        }
    }

    private void addChainEntryFirst(Entry entry) {
        assert (entry.previous == null && entry.next == null);
        if (this.head == null) {
            assert (this.tail == null);
            this.head = this.tail = entry;
        } else {
            entry.next = this.head;
            this.head.previous = entry;
            this.head = entry;
        }
    }

    private void removeChainEntry(Entry entry) {
        if (entry.previous != null) {
            entry.previous.next = entry.next;
        } else {
            assert (this.head == entry);
            this.head = entry.next;
        }
        if (entry.next != null) {
            entry.next.previous = entry.previous;
        } else {
            assert (this.tail == entry);
            this.tail = entry.previous;
        }
        entry.next = null;
        entry.previous = null;
    }

    private static final class Entry {
        final ParagraphView paragraphView;
        final Map<TextLayoutView, TextLayout> view2layout;
        Entry previous;
        Entry next;

        Entry(ParagraphView paragraphView) {
            this.paragraphView = paragraphView;
            int viewCount = paragraphView.getViewCount();
            assert (viewCount > 0);
            this.view2layout = new HashMap<TextLayoutView, TextLayout>((int)((double)viewCount / 0.6 + 1.0), 0.6f);
        }
    }
}

