/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.api.RecentProjects;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.netbeans.modules.welcome.content.ActionButton;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class RecentProjectsPanel
extends JPanel
implements Constants {
    private static final int MAX_PROJECTS = 10;
    private PropertyChangeListener changeListener;

    public RecentProjectsPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.removeAll();
        this.add((Component)this.rebuildContent(), "Center");
        RecentProjects.getDefault().addPropertyChangeListener(this.getPropertyChangeListener());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        RecentProjects.getDefault().removePropertyChangeListener(this.getPropertyChangeListener());
    }

    private PropertyChangeListener getPropertyChangeListener() {
        if (null == this.changeListener) {
            this.changeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if ("RecentProjectInformation".equals(e.getPropertyName())) {
                        RecentProjectsPanel.this.removeAll();
                        RecentProjectsPanel.this.add((Component)RecentProjectsPanel.this.rebuildContent(), "Center");
                        RecentProjectsPanel.this.invalidate();
                        RecentProjectsPanel.this.revalidate();
                        RecentProjectsPanel.this.repaint();
                    }
                }
            };
        }
        return this.changeListener;
    }

    private JPanel rebuildContent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int row = 0;
        List projects = RecentProjects.getDefault().getRecentProjectInformation();
        for (UnloadedProjectInformation p : projects) {
            this.addProject(panel, row++, p);
            if (row < 10) continue;
            break;
        }
        if (0 == row) {
            panel.add((Component)new JLabel(BundleSupport.getLabel("NoRecentProject")), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        } else {
            panel.add((Component)new JLabel(), new GridBagConstraints(0, row, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    private void addProject(JPanel panel, int row, UnloadedProjectInformation project) {
        OpenProjectAction action = new OpenProjectAction(project);
        ActionButton b = new ActionButton(action, project.getURL().toString(), false, "RecentProject");
        b.setFont(BUTTON_FONT);
        b.getAccessibleContext().setAccessibleName(b.getText());
        b.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("RecentProject", b.getText()));
        b.setIcon(project.getIcon());
        panel.add((Component)b, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private class OpenProjectAction
    extends AbstractAction {
        private UnloadedProjectInformation project;

        public OpenProjectAction(UnloadedProjectInformation project) {
            super(project.getDisplayName(), project.getIcon());
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URL url = this.project.getURL();
            Project prj = null;
            FileObject dir = URLMapper.findFileObject((URL)url);
            if (dir != null && dir.isFolder()) {
                try {
                    prj = ProjectManager.getDefault().findProject(dir);
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
            }
            if (prj != null) {
                OpenProjects.getDefault().open(new Project[]{prj}, false, true);
            } else {
                String msg = BundleSupport.getMessage("ERR_InvalidProject", this.project.getDisplayName());
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                RecentProjectsPanel.this.rebuildContent();
            }
        }
    }
}

