/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;

final class VisualizersSupport
implements SessionStateListener,
DLightSessionListener {
    private DLightSession.SessionState currentSessionState = null;
    private final SessionStateListener sessionStateListener;

    VisualizersSupport(SessionStateListener sessionStateListener) {
        this.sessionStateListener = sessionStateListener;
        DLightManager mgr = DLightManager.getDefault();
        DLightSession activeSession = mgr.getActiveSession();
        mgr.addDLightSessionListener((DLightSessionListener)this);
        activeSession.addSessionStateListener((SessionStateListener)this);
        this.currentSessionState = activeSession.getState();
    }

    protected boolean isSessionRunning() {
        return this.currentSessionState == DLightSession.SessionState.RUNNING;
    }

    protected boolean isSessionPaused() {
        return this.currentSessionState == DLightSession.SessionState.PAUSED;
    }

    protected boolean isSessionAnalyzed() {
        return this.currentSessionState == DLightSession.SessionState.ANALYZE;
    }

    public void sessionStateChanged(DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        this.currentSessionState = newState;
        if (newState == DLightSession.SessionState.PAUSED || newState == DLightSession.SessionState.ANALYZE) {
            this.sessionStateListener.sessionStateChanged(session, oldState, newState);
            return;
        }
        if (newState == DLightSession.SessionState.STARTING || newState == DLightSession.SessionState.RUNNING) {
            this.sessionStateListener.sessionStateChanged(session, oldState, newState);
            return;
        }
    }

    public void activeSessionChanged(DLightSession oldSession, DLightSession newSession) {
        if (oldSession != null) {
            oldSession.removeSessionStateListener((SessionStateListener)this);
            this.sessionStateChanged(oldSession, oldSession.getState(), oldSession.getState());
        }
        if (newSession != null) {
            newSession.addSessionStateListener((SessionStateListener)this);
            this.sessionStateChanged(newSession, DLightSession.SessionState.CONFIGURATION, newSession.getState());
        }
    }

    public void sessionAdded(DLightSession newSession) {
    }

    public void sessionRemoved(DLightSession removedSession) {
        if (removedSession != null) {
            removedSession.removeSessionStateListener((SessionStateListener)this);
            this.sessionStateListener.sessionStateChanged(removedSession, removedSession.getState(), DLightSession.SessionState.CLOSED);
        }
    }
}

