/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.types.TimeDuration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.spi.support.TimerBasedVisualizerSupport;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapData;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapSummaryData;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataProvider;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataQuery;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapSummaryDataQuery;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.ThreadMapTopComponent;
import org.netbeans.modules.dlight.visualizers.api.ThreadMapVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.MonitoredData;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadDumpFilter;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStackVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsDataManager;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;
import org.openide.util.NbBundle;

public class ThreadMapVisualizer
extends JPanel
implements Visualizer<ThreadMapVisualizerConfiguration>,
ActionListener,
SessionStateListener,
DataFilterListener {
    private boolean isEmptyContent;
    private Future<Boolean> task;
    private final Object queryLock = new QueryLock();
    private final ThreadMapDataProvider provider;
    private final ThreadMapVisualizerConfiguration configuration;
    private final Object uiLock = new UiLock();
    private final JPanel threadsTimelinePanelContainer;
    private final ThreadsPanel threadsPanel;
    private final ThreadsDataManager dataManager;
    private long startTimeStamp;
    private TimerBasedVisualizerSupport timerSupport;
    private DLightSession session;
    private Collection<TimeIntervalDataFilter> lastTimeFilters;
    private String toolID;
    private volatile boolean sessionClosed;

    public ThreadMapVisualizer(ThreadMapDataProvider provider, ThreadMapVisualizerConfiguration configuration) {
        this.provider = provider;
        this.configuration = configuration;
        this.dataManager = new ThreadsDataManager();
        this.threadsPanel = new ThreadsPanel(this.dataManager, new ThreadsPanel.ThreadsDetailsCallback(){

            @Override
            public void showStack(long startTime, final ThreadDumpQuery query) {
                DLightExecutorService.submit((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ThreadMapVisualizer.this.sessionClosed) {
                            return;
                        }
                        final ThreadDump threadDump = ThreadMapVisualizer.this.provider.getThreadDump(query);
                        UIThread.invoke((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ThreadStackVisualizerConfiguration.StackNameProvider stackNameProvider = new ThreadStackVisualizerConfiguration.StackNameProvider(){

                                    @Override
                                    public String getStackName(ThreadSnapshot snapshot) {
                                        String name = "";
                                        ThreadState.MSAState msa = snapshot.getState();
                                        ThreadStateResources res = ThreadStateResources.forState(msa);
                                        if (res != null) {
                                            name = res.name;
                                        }
                                        long time = ThreadStateColumnImpl.timeInervalToMilliSeconds(snapshot.getTimestamp());
                                        String at = TimeLineUtils.getMillisValue(time);
                                        return NbBundle.getMessage(ThreadMapVisualizer.class, (String)"ThreadStackVisualizerStackAt1", (Object)name, (Object)ThreadMapVisualizer.this.dataManager.findThreadName(snapshot.getThreadInfo().getThreadId()), (Object)at);
                                    }
                                };
                                DLightManager.getDefault().openVisualizer(ThreadMapVisualizer.this.session, ThreadMapVisualizer.this.toolID, (VisualizerConfiguration)new ThreadStackVisualizerConfiguration(query.getStartTime(), threadDump, stackNameProvider, query.getThreadID(), ThreadMapVisualizer.this.threadsPanel));
                            }
                        });
                        ThreadMapVisualizer.this.session.cleanAllDataFilter(ThreadDumpFilter.class);
                        ThreadMapVisualizer.this.session.addDataFilter((DataFilter)new ThreadDumpFilter(query.getStartTime(), threadDump), false);
                    }
                }, (String)"Thread Dump  request from Thread Map Visualizer");
            }
        });
        this.threadsTimelinePanelContainer = new JPanel(){

            @Override
            public void requestFocus() {
                ThreadMapVisualizer.this.threadsPanel.requestFocus();
            }
        };
        this.threadsTimelinePanelContainer.setLayout(new BorderLayout());
        this.threadsTimelinePanelContainer.add((Component)this.threadsPanel, "Center");
        this.threadsTimelinePanelContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.threadsTimelinePanelContainer, "Center");
    }

    public final void setToolID(String toolID) {
        this.toolID = toolID;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.threadsTimelinePanelContainer.requestFocus();
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        if (this.session != null) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThreadMapVisualizer.this.syncUpdate();
                }
            }, (String)"ThreadMapVisualizer. Request Data when filters are changed");
        }
    }

    private final void syncUpdate() {
        Collection timeFilters;
        if (this.sessionClosed) {
            return;
        }
        this.lastTimeFilters = timeFilters = this.session.getDataFilter(TimeIntervalDataFilter.class);
        this.setTimeIntervalSelection(timeFilters);
        final ThreadMapSummaryData summaryData = this.provider.queryData(new ThreadMapSummaryDataQuery(timeFilters, true));
        UIThread.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                ThreadMapVisualizer.this.updateList(null, summaryData, 0L);
            }
        });
    }

    private final void setTimeIntervalSelection(Collection<TimeIntervalDataFilter> timeFilters) {
        this.threadsPanel.setTimeIntervalSelection(timeFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.timerSupport = new TimerBasedVisualizerSupport((Visualizer)this, new TimeDuration(TimeUnit.SECONDS, 1L));
        Object object = this.uiLock;
        synchronized (object) {
            this.dataManager.reset();
            this.startTimeStamp = 0L;
        }
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        if (this.session != null) {
            switch (this.session.getState()) {
                case RUNNING: 
                case STARTING: {
                    Object object = this.uiLock;
                    synchronized (object) {
                        this.dataManager.reset();
                        this.dataManager.startup(this.session.getState());
                        this.startTimeStamp = 0L;
                    }
                    this.timerSupport.start();
                    break;
                }
                default: {
                    this.timerSupport.stop();
                    Object object = this.uiLock;
                    synchronized (object) {
                        this.dataManager.startup(this.session.getState());
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.timerSupport.stop();
        Object object = this.uiLock;
        synchronized (object) {
            this.dataManager.shutdown(DLightSession.SessionState.CLOSED);
            this.dataManager.reset();
            this.startTimeStamp = 0L;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.refresh();
    }

    public ThreadMapVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    public VisualizerContainer getDefaultContainer() {
        return ThreadMapTopComponent.findInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncFillModel(boolean cancelIfNotDone) {
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null && !this.task.isDone()) {
                if (cancelIfNotDone) {
                    this.task.cancel(true);
                } else {
                    return;
                }
            }
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    ThreadMapVisualizer.this.syncFillModel();
                    return Boolean.TRUE;
                }
            }, (String)"ThreadMapVisualizer request for the ThreadMapData");
        }
    }

    private void syncFillModel() {
        if (this.sessionClosed) {
            return;
        }
        final long requestFrom = this.startTimeStamp;
        final ThreadMapData mapData = this.provider.queryData(new ThreadMapDataQuery(requestFrom, true, false));
        final ThreadMapSummaryData summaryData = this.provider.queryData(new ThreadMapSummaryDataQuery(this.lastTimeFilters, true));
        final boolean isEmptyConent = mapData == null || mapData.getThreadsData().isEmpty();
        UIThread.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                ThreadMapVisualizer.this.setContent(isEmptyConent);
                if (isEmptyConent) {
                    return;
                }
                ThreadMapVisualizer.this.updateList(mapData, summaryData, requestFrom);
            }
        });
    }

    public void refresh() {
        if (EventQueue.isDispatchThread()) {
            this.asyncFillModel(false);
        } else {
            this.syncFillModel();
        }
    }

    private void setContent(boolean isEmpty) {
        if (this.isEmptyContent && isEmpty) {
            return;
        }
        if (this.isEmptyContent && !isEmpty) {
            this.setNonEmptyContent();
            return;
        }
        if (!this.isEmptyContent && isEmpty) {
            this.setEmptyContent();
            return;
        }
    }

    private void setEmptyContent() {
        this.isEmptyContent = true;
    }

    private void setNonEmptyContent() {
        this.isEmptyContent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList(ThreadMapData mapData, ThreadMapSummaryData summaryData, long requestFrom) {
        if (this.sessionClosed) {
            return;
        }
        Object object = this.uiLock;
        synchronized (object) {
            if (mapData != null) {
                this.threadsPanel.threadsMonitoringEnabled();
                this.dataManager.processData(MonitoredData.getMonitoredData(mapData), this.session, this.provider, requestFrom);
                if (requestFrom <= this.startTimeStamp) {
                    this.startTimeStamp = this.dataManager.getEndTimeStump();
                }
            }
            this.dataManager.processData(summaryData);
            this.setNonEmptyContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStateChanged(DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        this.session = session;
        if (session != null && newState != DLightSession.SessionState.CLOSED) {
            session.addDataFilterListener((DataFilterListener)this);
        }
        switch (newState) {
            case CLOSED: 
            case PAUSED: 
            case ANALYZE: {
                this.timerSupport.stop();
                Object object = this.uiLock;
                synchronized (object) {
                    this.dataManager.shutdown(newState);
                    this.startTimeStamp = 0L;
                }
                this.sessionClosed = newState == DLightSession.SessionState.CLOSED;
                this.refresh();
                break;
            }
            case RUNNING: 
            case STARTING: {
                this.timerSupport.start();
            }
        }
    }

    public void updateVisualizerConfiguration(ThreadMapVisualizerConfiguration configuration) {
    }

    private static final class UiLock {
        private UiLock() {
        }
    }

    private static final class QueryLock {
        private QueryLock() {
        }
    }
}

