/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.netbeans.modules.dlight.visualizers.threadmap.EnhancedTableCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;

public class ThreadNameCellRenderer
extends EnhancedTableCellRenderer {
    private JLabel label;
    private ThreadsPanel viewManager;

    public ThreadNameCellRenderer(ThreadsPanel viewManager) {
        this.setHorizontalAlignment(10);
        this.label = new JLabel("", 10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.viewManager = viewManager;
    }

    @Override
    protected void setRowForeground(Color c) {
        super.setRowForeground(c);
        this.label.setForeground(c);
    }

    @Override
    public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return new ThreadNameCellRenderer(this.viewManager).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    protected void setValue(JTable table, Object value, int row, int column) {
        if (table != null) {
            this.setFont(table.getFont());
        }
        if (value == null) {
            this.label.setText("");
        } else {
            int index = (Integer)value;
            this.label.setText(this.viewManager.getThreadName(index));
        }
    }
}

