/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;

public class MidpAcceptProducerKindPresenter
extends AcceptPresenter {
    private Map<TypeID, String> typesMap;
    private TypeID currentType;

    public MidpAcceptProducerKindPresenter() {
        super(AcceptPresenter.Kind.COMPONENT_PRODUCER);
    }

    public MidpAcceptProducerKindPresenter addType(TypeID type, String propertyName) {
        if (type == null || propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Illegal argument type or properytName");
        }
        if (this.typesMap != null && this.typesMap.keySet().contains(type)) {
            Debug.warning((Object[])new Object[]{"TypeID: " + type.toString() + " alredy exists in presenter: " + MidpAcceptProducerKindPresenter.class + " - component: " + this.getComponent()});
        }
        if (this.typesMap == null) {
            this.typesMap = new HashMap<TypeID, String>();
        }
        this.typesMap.put(type, propertyName);
        return this;
    }

    public boolean isAcceptable(ComponentProducer producer, AcceptSuggestion suggestion) {
        DescriptorRegistry registry = this.getComponent().getDocument().getDescriptorRegistry();
        for (TypeID type : this.typesMap.keySet()) {
            if (!registry.isInHierarchy(type, producer.getMainComponentTypeID())) continue;
            this.currentType = type;
            return true;
        }
        return false;
    }

    public final ComponentProducer.Result accept(ComponentProducer producer, AcceptSuggestion suggestion) {
        DesignDocument document = this.getComponent().getDocument();
        DesignComponent resource = producer.createComponent(document).getMainComponent();
        MidpDocumentSupport.getCategoryComponent(document, ResourcesCategoryCD.TYPEID).addComponent(resource);
        this.getComponent().writeProperty(this.typesMap.get(this.currentType), PropertyValue.createComponentReference((DesignComponent)resource));
        return new ComponentProducer.Result(new DesignComponent[]{resource});
    }
}

