/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.ImageEditorElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorImage
extends PropertyEditorUserCode
implements PropertyEditorElement,
PropertyEditorResourceElementListener {
    private JRadioButton radioButton;
    private ImageEditorElement element;
    private String resourcePath = "";
    private WeakReference<DesignComponent> component;

    private PropertyEditorImage() {
        super(NbBundle.getMessage(PropertyEditorImage.class, (String)"LBL_IMAGE_UCLABEL"));
    }

    public static PropertyEditorImage createInstance() {
        return new PropertyEditorImage();
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.element != null) {
            this.element.clean(component);
            this.element = null;
        }
        this.radioButton = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorImage.class, (String)"LBL_IMAGE_STR"));
        this.element = new ImageEditorElement();
        this.element.addPropertyEditorResourceElementListener(this);
    }

    @Override
    public Component getCustomEditor() {
        DesignComponent component_ = null;
        if (this.component != null && this.component.get() != null) {
            component_ = (DesignComponent)this.component.get();
        }
        if (this.element == null) {
            this.initComponents();
            if (component_ != null) {
                this.element.init(component_.getDocument());
            }
            this.initElements(Collections.singleton(this));
        }
        this.element.setDesignComponentWrapper(new PropertyEditorResourceElement.DesignComponentWrapper(component_));
        return super.getCustomEditor();
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.resourcePath);
        }
    }

    @Override
    public void updateState(PropertyValue value) {
        if (value == null) {
            this.element.setDesignComponentWrapper(null);
        } else if (this.component != null && this.component.get() != null) {
            this.element.setDesignComponentWrapper(new PropertyEditorResourceElement.DesignComponentWrapper((DesignComponent)this.component.get()));
        }
        this.element.setAllEnabled(true);
    }

    @Override
    public void setAsText(String text) {
        this.saveValue(text);
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return MidpTypes.getString(value);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.element;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return true;
    }

    @Override
    public void elementChanged(PropertyEditorResourceElementEvent event) {
        PropertyValue propertyValue = event.getPropertyValue();
        this.resourcePath = MidpTypes.getString(propertyValue);
        if (this.resourcePath == null) {
            this.resourcePath = "";
        }
        this.radioButton.setSelected(true);
    }

    public void setValue(Object value) {
        super.setValue(value);
    }

    private void saveValue(String text) {
        super.setValue((Object)MidpTypes.createStringValue(text));
    }

    @Override
    public void init(DesignComponent component) {
        this.component = new WeakReference<DesignComponent>(component);
        super.init(component);
    }
}

