/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.points.MethodPointCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorInstanceName
extends DesignPropertyEditor {
    private static final String METHOD_NAME_TEXT = NbBundle.getMessage(PropertyEditorInstanceName.class, (String)"LBL_METHOD_NAME");
    private static final String INSTANCE_NAME_TEXT = NbBundle.getMessage(PropertyEditorInstanceName.class, (String)"LBL_INSTANCE_NAME");
    private TypeID typeID;
    private CustomEditor customEditor;
    private WeakReference<DesignComponent> component;

    private PropertyEditorInstanceName(TypeID typeID) {
        this.typeID = typeID;
    }

    public static final DesignPropertyEditor createInstance(TypeID typeID) {
        return new PropertyEditorInstanceName(typeID);
    }

    public Component getCustomEditor() {
        PropertyValue value;
        if (this.customEditor == null) {
            this.customEditor = new CustomEditor();
        }
        if ((value = (PropertyValue)super.getValue()) != null) {
            this.customEditor.setText(MidpTypes.getString(value));
        }
        return this.customEditor;
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.typeID = null;
    }

    public String getAsText() {
        PropertyValue value = (PropertyValue)super.getValue();
        return value == null ? PropertyEditorUserCode.NULL_TEXT : MidpTypes.getString(value);
    }

    public void setAsText(String text) {
        PropertyValue value = (PropertyValue)super.getValue();
        if (value == null) {
            return;
        }
        Object pv = value.getPrimitiveValue();
        if (pv != null && pv.equals(text)) {
            return;
        }
        this.saveValue(text);
    }

    private void saveValue(final String text) {
        if (this.component != null && this.component.get() != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue newInstanceName = InstanceNameResolver.createFromSuggested(_component, text);
                    PropertyEditorInstanceName.super.setValue(newInstanceName);
                }
            });
        }
    }

    public void customEditorOKButtonPressed() {
        String text = this.customEditor.getText();
        if (text.length() > 0) {
            this.saveValue(text);
        }
    }

    public void init(DesignComponent component) {
        this.component = new WeakReference<DesignComponent>(component);
    }

    public boolean supportsDefaultValue() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public Boolean canEditAsText() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private String getLabelName() {
        return MethodPointCD.TYPEID.equals((Object)this.typeID) ? METHOD_NAME_TEXT : INSTANCE_NAME_TEXT;
    }

    private final class CustomEditor
    extends JPanel {
        private JTextField textField;

        public CustomEditor() {
            this.initComponents();
        }

        void cleanUp() {
            this.textField = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label, (String)PropertyEditorInstanceName.this.getLabelName());
            constraints.insets = new Insets(12, 12, 3, 12);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            this.add((Component)label, constraints);
            this.textField = new JTextField();
            label.setLabelFor(this.textField);
            constraints.insets = new Insets(0, 12, 12, 12);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            this.add((Component)this.textField, constraints);
            this.textField.getAccessibleContext().setAccessibleName(label.getText());
            this.textField.getAccessibleContext().setAccessibleDescription(label.getText());
            JPanel spacer = new JPanel();
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            this.add((Component)spacer, constraints);
            this.setPreferredSize(new Dimension(300, 64));
        }

        public void setText(String text) {
            this.textField.setText(text);
        }

        public String getText() {
            return this.textField.getText();
        }
    }
}

