/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.target.iterator.api.BrowseFolders;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.wizards.AttrDialog;
import org.netbeans.modules.web.wizards.AttrTableModel;
import org.netbeans.modules.web.wizards.TagInfoPanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.xml.sax.SAXException;

public class TagHandlerPanelGUI
extends JPanel
implements ListSelectionListener {
    private TagInfoPanel panel;
    private TemplateWizard wiz;
    private Project proj;
    private SourceGroup[] folders;
    private FileObject tldFo;
    private Set tagValues;
    private JLabel attrLabel;
    private JTable attrTable;
    private JLabel bodyContentLb;
    private JButton browseButton;
    private ButtonGroup buttonGroup1;
    private JTextField classTextField;
    private JButton deleteButton;
    private JLabel descriptionLabel;
    private JButton editButton;
    private JRadioButton emptyButton;
    private JCheckBox jCheckBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextField nameTextField;
    private JButton newButton;
    private JRadioButton scriptlessButton;
    private JLabel tagClassLabel;
    private JLabel tagNameLabel;
    private JRadioButton tegdependentButton;
    private JLabel tldFileLabel;
    private JTextField tldTextField;

    public TagHandlerPanelGUI(TemplateWizard templateWizard, final TagInfoPanel tagInfoPanel, Project project, SourceGroup[] sourceGroupArray) {
        this.initComponents();
        this.wiz = templateWizard;
        this.panel = tagInfoPanel;
        this.proj = project;
        this.folders = sourceGroupArray;
        this.attrTable.setModel(new AttrTableModel(new String[]{"attrName", "attrType", "attrRequired", "attrRtexprvalue"}));
        this.attrTable.setSelectionMode(0);
        this.attrTable.setIntercellSpacing(new Dimension(6, 6));
        this.attrTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.setName(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_configure_TLD"));
        this.attrTable.getSelectionModel().addListSelectionListener(this);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                tagInfoPanel.fireChangeEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                tagInfoPanel.fireChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                tagInfoPanel.fireChangeEvent();
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.tldTextField = new JTextField();
        this.browseButton = new JButton();
        this.tldFileLabel = new JLabel();
        this.tagNameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.tagClassLabel = new JLabel();
        this.classTextField = new JTextField();
        this.jPanel1 = new JPanel();
        this.emptyButton = new JRadioButton();
        this.scriptlessButton = new JRadioButton();
        this.tegdependentButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.attrLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.bodyContentLb = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.descriptionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.attrTable = new JTable();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagHandlerPanel2"));
        this.tldTextField.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tldTextField, gridBagConstraints);
        this.tldTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TLDFile"));
        this.browseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_Browse_Mnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TagHandlerPanelGUI.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 12, 6);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_Browse"));
        this.tldFileLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TLDName_mnem").charAt(0));
        this.tldFileLabel.setLabelFor(this.tldTextField);
        this.tldFileLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_tldFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tldFileLabel, gridBagConstraints);
        this.tagNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagName_mnem").charAt(0));
        this.tagNameLabel.setLabelFor(this.nameTextField);
        this.tagNameLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_tagName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.tagNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagName"));
        this.tagClassLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_ClassName_mnem").charAt(0));
        this.tagClassLabel.setLabelFor(this.classTextField);
        this.tagClassLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_tagHandlerClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.tagClassLabel, gridBagConstraints);
        this.classTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.classTextField, gridBagConstraints);
        this.classTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagClass"));
        this.buttonGroup1.add(this.emptyButton);
        this.emptyButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagEmpty_mnem").charAt(0));
        this.emptyButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_emptyBodyContent"));
        this.jPanel1.add(this.emptyButton);
        this.emptyButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagEmpty"));
        this.buttonGroup1.add(this.scriptlessButton);
        this.scriptlessButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagScriptless_mnem").charAt(0));
        this.scriptlessButton.setSelected(true);
        this.scriptlessButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_scriptlessBodyContent"));
        this.jPanel1.add(this.scriptlessButton);
        this.scriptlessButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagScriptless"));
        this.buttonGroup1.add(this.tegdependentButton);
        this.tegdependentButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagTagdependent_mnem").charAt(0));
        this.tegdependentButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_tagdependentBodyContent"));
        this.jPanel1.add(this.tegdependentButton);
        this.tegdependentButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagTagdependent"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.attrLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_Attribs_mnem").charAt(0));
        this.attrLabel.setLabelFor(this.attrTable);
        this.attrLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"TITLE_attributes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 6, 0);
        this.add((Component)this.attrLabel, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.newButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_new_mnemonic").charAt(0));
        this.newButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_newButton"));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TagHandlerPanelGUI.this.newButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.newButton, gridBagConstraints);
        this.newButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_newButton"));
        this.editButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_edit_mnemonic").charAt(0));
        this.editButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_editButton"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TagHandlerPanelGUI.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.editButton, gridBagConstraints);
        this.editButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_editButton"));
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_delete_mnemonic").charAt(0));
        this.deleteButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_deleteButton"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TagHandlerPanelGUI.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.deleteButton, gridBagConstraints);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_deleteButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.bodyContentLb.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_bodyContent"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.bodyContentLb, gridBagConstraints);
        this.jCheckBox1.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_AddToTLD_mnem").charAt(0));
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_addToTLD"));
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TagHandlerPanelGUI.this.jCheckBox1ItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jCheckBox1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("OPT_addToTLD"));
        this.descriptionLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"HINT_tldFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.attrTable);
        this.attrTable.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_AttrTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.attrTable.getSelectedRow();
        if (n >= 0) {
            ((AttrTableModel)this.attrTable.getModel()).removeRow(n);
            ((AttrTableModel)this.attrTable.getModel()).fireTableRowsDeleted(n, n);
        }
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"TITLE_attr_add");
        final AttrDialog attrDialog = new AttrDialog();
        final AttrTableModel attrTableModel = (AttrTableModel)this.attrTable.getModel();
        EditDialog editDialog = new EditDialog(attrDialog, string, true){

            protected String validate() {
                String string = attrDialog.getAttrName();
                if (string.length() == 0) {
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_attr_no_name");
                }
                if (!TagHandlerPanelGUI.this.isJavaIdentifier(string)) {
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_wrong_attr_name", (Object)string);
                }
                Object[][] objectArray = attrTableModel.getAttributes();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!string.equals(objectArray[i][0])) continue;
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_attr_exists");
                }
                return null;
            }
        };
        editDialog.setValid(false);
        EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
        attrDialog.getAttrNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
        dialog.getAccessibleContext().setAccessibleDescription(editDialog.getDialogPanel().getAccessibleContext().getAccessibleDescription());
        dialog.setVisible(true);
        attrDialog.getAttrNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
        if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
            int n = attrTableModel.getRowCount();
            attrTableModel.addRow(attrDialog.getAttrName(), attrDialog.getAttrType(), attrDialog.isRequired(), attrDialog.isRtexpr());
            attrTableModel.fireTableRowsInserted(n, n);
        }
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            Sources sources;
            FileObject fileObject = null;
            if (this.folders != null) {
                fileObject = BrowseFolders.showDialog((SourceGroup[])this.folders, TLDDataObject.class, (String)"");
            } else {
                sources = ProjectUtils.getSources((Project)this.proj);
                fileObject = BrowseFolders.showDialog((SourceGroup[])sources.getSourceGroups("generic"), DataFolder.class, (String)"");
            }
            if (fileObject != null) {
                this.tldFo = fileObject;
                sources = Templates.getTargetFolder((WizardDescriptor)this.wiz);
                WebModule webModule = WebModule.getWebModule((FileObject)sources);
                this.tldTextField.setText(FileUtil.getRelativePath((FileObject)(webModule == null ? this.proj.getProjectDirectory() : webModule.getDocumentBase()), (FileObject)fileObject));
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            InputStream inputStream = TagHandlerPanelGUI.this.tldFo.getInputStream();
                            try {
                                TagHandlerPanelGUI.this.tagValues = Util.getTagValues(inputStream, new String[]{"tag", "tag-file"}, "name");
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                            catch (SAXException sAXException) {
                                Exceptions.printStackTrace((Throwable)sAXException);
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        TagHandlerPanelGUI.this.panel.fireChangeEvent();
                    }
                });
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.attrTable.getSelectionModel().isSelectionEmpty()) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private void jCheckBox1ItemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.jCheckBox1.isSelected();
        this.browseButton.setEnabled(bl);
        this.nameTextField.setEnabled(bl);
        this.panel.fireChangeEvent();
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"TITLE_attr_edit");
        final AttrTableModel attrTableModel = (AttrTableModel)this.attrTable.getModel();
        final int n = this.attrTable.getSelectedRow();
        String string2 = (String)attrTableModel.getValueAt(n, 0);
        String string3 = (String)attrTableModel.getValueAt(n, 1);
        boolean bl = (Boolean)attrTableModel.getValueAt(n, 2);
        boolean bl2 = (Boolean)attrTableModel.getValueAt(n, 3);
        final AttrDialog attrDialog = new AttrDialog(string2, string3, bl, bl2);
        EditDialog editDialog = new EditDialog(attrDialog, string, false){

            protected String validate() {
                String string = attrDialog.getAttrName();
                if (string.length() == 0) {
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_attr_no_name");
                }
                if (!TagHandlerPanelGUI.this.isJavaIdentifier(string)) {
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_wrong_attr_name", (Object)string);
                }
                Object[][] objectArray = attrTableModel.getAttributes();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i == n || !string.equals(objectArray[i][0])) continue;
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_attr_exists");
                }
                return null;
            }
        };
        EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
        attrDialog.getAttrNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
        dialog.getAccessibleContext().setAccessibleDescription(editDialog.getDialogPanel().getAccessibleContext().getAccessibleDescription());
        dialog.setVisible(true);
        attrDialog.getAttrNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
        if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
            attrTableModel.setData(attrDialog.getAttrName(), attrDialog.getAttrType(), attrDialog.isRequired(), attrDialog.isRtexpr(), n);
            attrTableModel.fireTableRowsUpdated(n, n);
        }
    }

    String getTagName() {
        return this.nameTextField.getText();
    }

    void setTagName(String string) {
        this.nameTextField.setText(string);
    }

    void setClassName(String string) {
        this.classTextField.setText(string);
    }

    FileObject getTLDFile() {
        return this.tldFo;
    }

    Set getTagValues() {
        return this.tagValues;
    }

    boolean isEmpty() {
        return this.emptyButton.isSelected();
    }

    boolean isScriptless() {
        return this.scriptlessButton.isSelected();
    }

    boolean isTegdependent() {
        return this.tegdependentButton.isSelected();
    }

    boolean writeToTLD() {
        return this.jCheckBox1.isSelected();
    }

    Object[][] getAttributes() {
        return ((AttrTableModel)this.attrTable.getModel()).getAttributes();
    }

    void setBodySupport(boolean bl) {
        if (bl) {
            this.scriptlessButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_jspBodyContent"));
        } else {
            this.scriptlessButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_scriptlessBodyContent"));
        }
    }

    private boolean isJavaIdentifier(String string) {
        return Utilities.isJavaIdentifier((String)string);
    }
}

