/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.formatting.api.support;

public final class IndentCommand {
    private Type type;
    private int fixedIndentSize;
    private int lineOffset;
    private int indentation;
    private boolean wasContinue;

    public IndentCommand(Type type, int lineOffset) {
        this.type = type;
        this.lineOffset = lineOffset;
        this.fixedIndentSize = -1;
    }

    public int getFixedIndentSize() {
        return this.fixedIndentSize;
    }

    public void setFixedIndentSize(int fixedIndentSize) {
        this.fixedIndentSize = fixedIndentSize;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public Type getType() {
        return this.type;
    }

    void setCalculatedIndentation(int indentation) {
        this.indentation = indentation;
    }

    int getCalculatedIndentation() {
        return this.indentation;
    }

    IndentCommand cloneMe() {
        IndentCommand ic = new IndentCommand(this.type, this.lineOffset);
        ic.fixedIndentSize = this.fixedIndentSize;
        ic.indentation = this.indentation;
        ic.wasContinue = this.wasContinue;
        return ic;
    }

    boolean wasContinue() {
        return this.wasContinue;
    }

    void setWasContinue() {
        this.wasContinue = true;
    }

    public String toString() {
        return "IndentCommand[type=" + (Object)((Object)this.type) + (this.fixedIndentSize != -1 ? " fixedIndent=" + this.fixedIndentSize : "") + " lineOffset=" + this.lineOffset + "]";
    }

    void updateOffset(int diff) {
        this.lineOffset += diff;
    }

    public static enum Type {
        INDENT,
        RETURN,
        NO_CHANGE,
        CONTINUE,
        DO_NOT_INDENT_THIS_LINE,
        PRESERVE_INDENTATION,
        BLOCK_START,
        BLOCK_END;

    }
}

