/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.Assert;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.expr.JavaExpression;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EvaluatorVisitor
extends TreePathScanner<Mirror, EvaluationContext> {
    private static final Logger loggerMethod = Logger.getLogger("org.netbeans.modules.debugger.jpda.invokeMethod");
    private static final Logger loggerValue = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    private Type newArrayType;
    private JavaExpression expression;
    private Map<Tree, Type> subExpressionTypes = new IdentityHashMap<Tree, Type>();
    private static final String BRACKETS = "[][][][][][][][][][][][][][][][][][][][]";
    private static final Set<String> PRIMITIVE_CLASS_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName())));

    public EvaluatorVisitor(JavaExpression javaExpression) {
        this.expression = javaExpression;
    }

    private Type getSubExpressionType(Tree tree) {
        Type type = this.subExpressionTypes.get(tree);
        if (type != null) {
            return type;
        }
        if (tree.getKind() == Tree.Kind.PARENTHESIZED) {
            return this.getSubExpressionType(((ParenthesizedTree)tree).getExpression());
        }
        return null;
    }

    @Override
    public Mirror scan(Tree tree, EvaluationContext evaluationContext) {
        Mirror mirror = (Mirror)super.scan(tree, evaluationContext);
        if (mirror instanceof ArtificialMirror) {
            return ((ArtificialMirror)mirror).getVMMirror();
        }
        return mirror;
    }

    @Override
    public Mirror scan(TreePath treePath, EvaluationContext evaluationContext) {
        Mirror mirror = (Mirror)super.scan(treePath, evaluationContext);
        if (mirror instanceof ArtificialMirror) {
            return ((ArtificialMirror)mirror).getVMMirror();
        }
        return mirror;
    }

    @Override
    public Mirror scan(Iterable<? extends Tree> iterable, EvaluationContext evaluationContext) {
        Mirror mirror = (Mirror)super.scan(iterable, evaluationContext);
        if (mirror instanceof ArtificialMirror) {
            return ((ArtificialMirror)mirror).getVMMirror();
        }
        return mirror;
    }

    @Override
    public Mirror visitAnnotation(AnnotationTree annotationTree, EvaluationContext evaluationContext) {
        return null;
    }

    @Override
    public Mirror visitMethodInvocation(MethodInvocationTree methodInvocationTree, EvaluationContext evaluationContext) {
        Mirror mirror;
        Object object;
        Object object2;
        Object object3;
        ArrayList<Type> arrayList;
        Object object4;
        Object object5;
        Element element;
        Object object6;
        String string;
        Iterable<TypeMirror> iterable;
        if (!evaluationContext.canInvokeMethods()) {
            Assert.error(methodInvocationTree, "canNotInvokeMethods");
        }
        if (loggerMethod.isLoggable(Level.FINE)) {
            loggerMethod.fine("STARTED : " + methodInvocationTree + " in thread " + evaluationContext.getFrame().thread());
        }
        Mirror mirror2 = null;
        Boolean bl = null;
        ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
        Type type = null;
        TreePath treePath = this.getCurrentPath();
        if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
            iterable = (MemberSelectTree)expressionTree;
            mirror2 = iterable.getExpression().accept(this, evaluationContext);
            string = iterable.getIdentifier().toString();
            if (mirror2 == null) {
                Assert.error((Tree)methodInvocationTree, "methodCallOnNull", string);
            }
            if (iterable.getExpression().toString().equals("super")) {
                type = this.getSubExpressionType(iterable.getExpression());
            }
            if (treePath != null) {
                object6 = TreePath.getPath(treePath, (Tree)((Object)iterable));
                if (object6 == null) {
                    object6 = treePath;
                }
                element = evaluationContext.getTrees().getElement((TreePath)object6);
            } else {
                element = null;
            }
        } else if (treePath != null) {
            iterable = TreePath.getPath(treePath, (Tree)methodInvocationTree);
            if (iterable == null) {
                iterable = treePath;
            }
            element = evaluationContext.getTrees().getElement((TreePath)iterable);
            string = element.getSimpleName().toString();
        } else {
            element = null;
            string = expressionTree.toString();
        }
        iterable = null;
        object6 = null;
        if (element != null) {
            object5 = element.asType();
            object4 = object5.getKind();
            if (object4 == TypeKind.ERROR) {
                element = null;
            } else {
                if (object4 != TypeKind.EXECUTABLE) {
                    Assert.error(methodInvocationTree, "noSuchMethod", element.getSimpleName().toString(), element.getEnclosingElement().getSimpleName().toString());
                }
                arrayList = (ExecutableElement)element;
                object3 = (ExecutableType)object5;
                iterable = object3.getParameterTypes();
                bl = arrayList.getModifiers().contains((Object)Modifier.STATIC);
                object2 = arrayList.getEnclosingElement();
                if (object2.getKind() == ElementKind.CLASS) {
                    object = (TypeElement)object2;
                    object6 = ElementUtilities.getBinaryName((TypeElement)object);
                }
            }
        }
        object5 = methodInvocationTree.getArguments();
        object4 = new ArrayList(object5.size());
        arrayList = object5.iterator();
        while (arrayList.hasNext()) {
            object3 = (ExpressionTree)arrayList.next();
            object2 = object3.accept(this, evaluationContext);
            if (object2 != null && !(object2 instanceof Value)) {
                Assert.error((Tree)object3, "Not a value");
            }
            if (object2 instanceof ArtificialMirror) {
                object2 = ((ArtificialMirror)object2).getVMMirror();
            }
            object4.add((Value)object2);
        }
        arrayList = null;
        if (element == null) {
            arrayList = new ArrayList<Type>(object4.size());
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (Value)object3.next();
                if (object2 == null) {
                    object = evaluationContext.getDebugger().getVirtualMachine();
                    if (object == null) {
                        return null;
                    }
                    arrayList.add(object.classesByName("java.lang.Object").get(0));
                    continue;
                }
                arrayList.add(object2.type());
            }
        }
        if (bl == null) {
            if (mirror2 instanceof ClassType || mirror2 instanceof ArrayType) {
                object2 = (ReferenceType)mirror2;
                object3 = null;
                bl = Boolean.TRUE;
            } else if (mirror2 instanceof ObjectReference) {
                object3 = (ObjectReference)mirror2;
                object2 = (ReferenceType)type;
                if (object2 == null) {
                    object2 = (ReferenceType)object3.type();
                }
            } else {
                object3 = evaluationContext.getContextObject();
                if (object3 != null) {
                    object2 = object3.referenceType();
                } else {
                    Assert.error((Tree)methodInvocationTree, "invokeInstanceMethodAsStatic", string);
                    object2 = evaluationContext.getFrame().location().declaringType();
                }
            }
        } else if (bl.booleanValue()) {
            object3 = null;
            if (mirror2 instanceof ClassType || mirror2 instanceof ArrayType) {
                object2 = (ReferenceType)mirror2;
            } else if (mirror2 instanceof ObjectReference) {
                object2 = (ReferenceType)((ObjectReference)mirror2).type();
            } else {
                object2 = evaluationContext.getFrame().location().declaringType();
                if (object6 != null && (object = this.findEnclosingType((ReferenceType)object2, (String)object6)) != null) {
                    object2 = object;
                }
            }
        } else {
            if (mirror2 != null) {
                if (mirror2 instanceof ClassType) {
                    Assert.error((Tree)methodInvocationTree, "invokeInstanceMethodAsStatic", string);
                    object3 = null;
                    object2 = null;
                } else {
                    object3 = (ObjectReference)mirror2;
                    object2 = (ReferenceType)type;
                    if (object2 == null) {
                        object2 = object3.referenceType();
                    }
                }
            } else {
                object3 = evaluationContext.getContextObject();
                if (object3 != null) {
                    object2 = object3.referenceType();
                    if (object6 != null && (object = this.findEnclosingType((ReferenceType)object2, (String)object6)) != null) {
                        mirror = this.findEnclosingObject(methodInvocationTree, (ObjectReference)object3, (ReferenceType)object, null, string);
                        if (mirror != null) {
                            object2 = mirror.referenceType();
                        } else {
                            Assert.error(methodInvocationTree, "noSuchMethod", string, object2.name());
                        }
                    }
                } else {
                    object2 = null;
                }
            }
            if (object3 == null) {
                Assert.error((Tree)methodInvocationTree, "methodCallOnNull", string);
            }
        }
        if (object2 instanceof ArrayType) {
            Assert.error(methodInvocationTree, "methOnArray");
            return null;
        }
        object = (ClassType)object2;
        mirror = EvaluatorVisitor.getConcreteMethodAndReportProblems(methodInvocationTree, (ReferenceType)object2, string, null, iterable, arrayList);
        return this.invokeMethod(methodInvocationTree, (Method)mirror, bl, (ClassType)object, (ObjectReference)object3, (List<Value>)object4, evaluationContext, type != null);
    }

    private static Method getConcreteMethodAndReportProblems(Tree tree, ReferenceType referenceType, String string, String string2, List<? extends TypeMirror> list, List<? extends Type> list2) {
        Method method;
        try {
            method = list != null ? EvaluatorVisitor.getConcreteMethod(referenceType, string, string2, list) : EvaluatorVisitor.getConcreteMethod2(referenceType, string, list2);
        }
        catch (UnsuitableArgumentsException unsuitableArgumentsException) {
            StringBuilder stringBuilder = new StringBuilder("(");
            if (list != null) {
                for (TypeMirror typeMirror : list) {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((Object)typeMirror).toString());
                }
            } else {
                for (Type type : list2) {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(type.name());
                }
            }
            stringBuilder.append(")");
            if ("<init>".equals(string)) {
                Assert.error(tree, "noSuchConstructorWithArgs", referenceType.name(), stringBuilder.toString());
            }
            if (stringBuilder.length() == 2) {
                Assert.error(tree, "noSuchMethod", string + stringBuilder, referenceType.name());
            } else {
                Assert.error(tree, "noSuchMethodWithArgs", string, referenceType.name(), stringBuilder.toString());
            }
            method = null;
        }
        if (method == null) {
            Assert.error(tree, "noSuchMethod", string, referenceType.name());
        }
        return method;
    }

    private static Method getConcreteMethod(ReferenceType referenceType, String string, List<? extends TypeMirror> list) throws UnsuitableArgumentsException {
        return EvaluatorVisitor.getConcreteMethod(referenceType, string, null, list);
    }

    private static Method getConcreteMethod(ReferenceType referenceType, String string, String string2, List<? extends TypeMirror> list) throws UnsuitableArgumentsException {
        List<Method> list2 = referenceType.methodsByName(string);
        String string3 = EvaluatorVisitor.createSignature(string2, list);
        boolean bl = "<init>".equals(string);
        for (Method method : list2) {
            if (method.isAbstract() || bl && !((Object)referenceType).equals(method.declaringType()) || !EvaluatorVisitor.equalMethodSignatures(method.signature(), string3)) continue;
            return method;
        }
        if (list2.size() > 0) {
            throw new UnsuitableArgumentsException();
        }
        return null;
    }

    private static Method getConcreteMethod2(ReferenceType referenceType, String string, List<? extends Type> list) throws UnsuitableArgumentsException {
        List<Method> list2 = referenceType.methodsByName(string);
        ArrayList<Method> arrayList = new ArrayList<Method>();
        ArrayList<Method> arrayList2 = null;
        boolean bl = "<init>".equals(string);
        for (Method method : list2) {
            if (method.isAbstract() || bl && !((Object)referenceType).equals(method.declaringType())) continue;
            try {
                if (EvaluatorVisitor.equalTypes(method.argumentTypes(), list)) {
                    return method;
                }
                if (!EvaluatorVisitor.acceptTypes(method.argumentTypes(), list)) continue;
                arrayList.add(method);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                if (method.argumentTypeNames().size() != list.size()) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Method>();
                }
                arrayList2.add(method);
            }
        }
        if (arrayList.size() == 0) {
            if (list2.size() > 0) {
                if (arrayList2 != null) {
                    return (Method)arrayList2.get(0);
                }
                throw new UnsuitableArgumentsException();
            }
            return null;
        }
        return (Method)arrayList.get(0);
    }

    private static boolean equalTypes(List<? extends Type> list, List<? extends Type> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i).equals(list2.get(i)) || EvaluatorVisitor.unboxType(list.get(i)).equals(EvaluatorVisitor.unboxType(list2.get(i)))) continue;
            return false;
        }
        return true;
    }

    private static boolean acceptTypes(List<? extends Type> list, List<? extends Type> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Type type;
            Type type2 = EvaluatorVisitor.unboxType(list.get(i));
            if (type2.equals(type = EvaluatorVisitor.unboxType(list2.get(i))) || EvaluatorVisitor.extendsType(type, type2)) continue;
            return false;
        }
        return true;
    }

    private static boolean extendsType(Type type, Type type2) {
        if (type2 instanceof ReferenceType && type instanceof ReferenceType) {
            return EvaluatorVisitor.extendsType((ReferenceType)type, (ReferenceType)type2);
        }
        if (type2 instanceof PrimitiveType && type instanceof PrimitiveType) {
            return EvaluatorVisitor.extendsType((PrimitiveType)type, (PrimitiveType)type2);
        }
        return false;
    }

    private static boolean extendsType(ReferenceType referenceType, ReferenceType referenceType2) {
        if (referenceType2 instanceof InterfaceType) {
            List<InterfaceType> list;
            if (referenceType instanceof ClassType) {
                list = ((ClassType)referenceType).allInterfaces();
            } else if (referenceType instanceof InterfaceType) {
                list = ((InterfaceType)referenceType).superinterfaces();
            } else {
                return false;
            }
            return list.contains(referenceType2);
        }
        if (referenceType2 instanceof ClassType) {
            if (referenceType instanceof ClassType) {
                ClassType classType = ((ClassType)referenceType).superclass();
                if (classType != null) {
                    if (classType.equals(referenceType2)) {
                        return true;
                    }
                    return EvaluatorVisitor.extendsType(classType, referenceType2);
                }
                return false;
            }
            return false;
        }
        if (referenceType2 instanceof ArrayType) {
            if (referenceType instanceof ArrayType) {
                try {
                    Type type = ((ArrayType)referenceType).componentType();
                    Type type2 = ((ArrayType)referenceType2).componentType();
                    return EvaluatorVisitor.extendsType(type, type2);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    return false;
                }
            }
            return false;
        }
        throw new IllegalStateException("Unknown ReferenceType: " + referenceType2);
    }

    private static boolean extendsType(PrimitiveType primitiveType, PrimitiveType primitiveType2) {
        if (primitiveType2 instanceof ShortType) {
            return primitiveType2 instanceof ByteType || primitiveType2 instanceof ShortType;
        }
        if (primitiveType2 instanceof IntegerType) {
            return primitiveType2 instanceof ByteType || primitiveType2 instanceof ShortType || primitiveType2 instanceof IntegerType;
        }
        if (primitiveType2 instanceof LongType) {
            return primitiveType2 instanceof ByteType || primitiveType2 instanceof ShortType || primitiveType2 instanceof IntegerType || primitiveType2 instanceof LongType;
        }
        if (primitiveType2 instanceof FloatType) {
            return !(primitiveType2 instanceof BooleanType) && !(primitiveType2 instanceof CharType) && !(primitiveType2 instanceof DoubleType);
        }
        if (primitiveType2 instanceof DoubleType) {
            return !(primitiveType2 instanceof BooleanType) && !(primitiveType2 instanceof CharType);
        }
        return false;
    }

    private static Type unboxType(Type type) {
        if (type instanceof ClassType) {
            String string = ((ClassType)type).name();
            if (string.equals("java.lang.Boolean")) {
                type = type.virtualMachine().mirrorOf(true).type();
            } else if (string.equals("java.lang.Byte")) {
                type = type.virtualMachine().mirrorOf((byte)10).type();
            } else if (string.equals("java.lang.Character")) {
                type = type.virtualMachine().mirrorOf('a').type();
            } else if (string.equals("java.lang.Integer")) {
                type = type.virtualMachine().mirrorOf(10).type();
            } else if (string.equals("java.lang.Long")) {
                type = type.virtualMachine().mirrorOf(10L).type();
            } else if (string.equals("java.lang.Short")) {
                type = type.virtualMachine().mirrorOf((short)10).type();
            } else if (string.equals("java.lang.Float")) {
                type = type.virtualMachine().mirrorOf(10.0f).type();
            } else if (string.equals("java.lang.Double")) {
                type = type.virtualMachine().mirrorOf(10.0).type();
            }
        }
        return type;
    }

    private static boolean equalMethodSignatures(String string, String string2) {
        int n = string.lastIndexOf(")");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((n = string2.lastIndexOf(")")) > 0) {
            string2 = string2.substring(0, n);
        }
        return string.equals(string2);
    }

    private static String createSignature(String string, List<? extends TypeMirror> list) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (string != null) {
            stringBuilder.append(string);
        }
        for (TypeMirror typeMirror : list) {
            String string2 = EvaluatorVisitor.getTypeName(typeMirror);
            stringBuilder.append(EvaluatorVisitor.getSignature(string2));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static String getTypeName(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            return EvaluatorVisitor.getTypeName(((javax.lang.model.type.ArrayType)typeMirror).getComponentType()) + "[]";
        }
        if (typeMirror.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)typeMirror;
            return EvaluatorVisitor.getTypeName(typeVariable.getUpperBound());
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            return ElementUtilities.getBinaryName((TypeElement)((TypeElement)((DeclaredType)typeMirror).asElement()));
        }
        return ((Object)typeMirror).toString();
    }

    private static String getSignature(String string) {
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.endsWith("[]")) {
            return "[" + EvaluatorVisitor.getSignature(string.substring(0, string.length() - 2));
        }
        return "L" + string.replace('.', '/') + ";";
    }

    private static ReferenceType getClassType(Tree tree, TypeMirror typeMirror, EvaluationContext evaluationContext) {
        String string = ElementUtilities.getBinaryName((TypeElement)((TypeElement)((DeclaredType)typeMirror).asElement()));
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        ReferenceType referenceType = EvaluatorVisitor.getOrLoadClass(virtualMachine, string, evaluationContext);
        if (referenceType == null) {
            Assert.error(tree, "unknownType", string);
        }
        return referenceType;
    }

    public static boolean instanceOf(Type type, Type type2) {
        if (type == null) {
            return false;
        }
        if (type.equals(type2)) {
            return true;
        }
        if (type2 instanceof ArrayType) {
            Type type3;
            Type type4;
            if (!(type instanceof ArrayType)) {
                return false;
            }
            ArrayType arrayType = (ArrayType)type;
            ArrayType arrayType2 = (ArrayType)type2;
            try {
                type4 = arrayType.componentType();
                type3 = arrayType2.componentType();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                return false;
            }
            return EvaluatorVisitor.instanceOf(type4, type3);
        }
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            if (type2 instanceof InterfaceType) {
                List<InterfaceType> list;
                try {
                    list = classType.allInterfaces();
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    return false;
                }
                for (InterfaceType interfaceType : list) {
                    if (!interfaceType.equals(type2)) continue;
                    return true;
                }
                return false;
            }
            do {
                if ((classType = classType.superclass()) != null) continue;
                return false;
            } while (!classType.equals(type2));
            return true;
        }
        if (type instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            if (type2 instanceof InterfaceType) {
                List<InterfaceType> list;
                try {
                    list = interfaceType.superinterfaces();
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    return false;
                }
                for (InterfaceType interfaceType2 : list) {
                    if (!interfaceType2.equals(type2)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public Mirror visitAssert(AssertTree assertTree, EvaluationContext evaluationContext) {
        Assert.error(assertTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitAssignment(AssignmentTree assignmentTree, EvaluationContext evaluationContext) {
        Mirror mirror = assignmentTree.getVariable().accept(this, evaluationContext);
        Mirror mirror2 = assignmentTree.getExpression().accept(this, evaluationContext);
        Value value = (Value)mirror2;
        return this.setToMirror(assignmentTree.getVariable(), value, evaluationContext);
    }

    @Override
    public Mirror visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, EvaluationContext evaluationContext) {
        Object object;
        Element element;
        Object object2;
        Mirror mirror = compoundAssignmentTree.getVariable().accept(this, evaluationContext);
        Mirror mirror2 = compoundAssignmentTree.getExpression().accept(this, evaluationContext);
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        Tree.Kind kind = compoundAssignmentTree.getKind();
        if (mirror instanceof ObjectReference) {
            mirror = EvaluatorVisitor.unboxIfCan(compoundAssignmentTree, (ObjectReference)mirror, evaluationContext);
        }
        if (mirror == null) {
            object2 = this.getCurrentPath();
            element = null;
            if (object2 != null) {
                object = TreePath.getPath((TreePath)object2, (Tree)compoundAssignmentTree.getVariable());
                if (object == null) {
                    object = this.getCurrentPath();
                }
                if ((element = evaluationContext.getTrees().getElement((TreePath)object)) instanceof TypeElement && ((TypeElement)element).asType() instanceof ErrorType) {
                    element = null;
                }
            }
            if (element == null) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            object = element.asType();
            switch (object.getKind()) {
                case BOOLEAN: {
                    mirror = virtualMachine.mirrorOf(false);
                    break;
                }
                case BYTE: {
                    mirror = virtualMachine.mirrorOf((byte)0);
                    break;
                }
                case CHAR: {
                    mirror = virtualMachine.mirrorOf('\u0000');
                    break;
                }
                case DOUBLE: {
                    mirror = virtualMachine.mirrorOf(0.0);
                    break;
                }
                case FLOAT: {
                    mirror = virtualMachine.mirrorOf(0.0f);
                    break;
                }
                case INT: {
                    mirror = virtualMachine.mirrorOf(0);
                    break;
                }
                case LONG: {
                    mirror = virtualMachine.mirrorOf(0L);
                    break;
                }
                case SHORT: {
                    mirror = virtualMachine.mirrorOf((short)0);
                    break;
                }
                default: {
                    if (object.toString().equals("java.lang.String")) {
                        try {
                            mirror = virtualMachine.mirrorOf("null");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            Assert.error(compoundAssignmentTree, "unsupportedStringCreation");
                        }
                        break;
                    }
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
        }
        if (mirror instanceof BooleanValue) {
            boolean bl = ((BooleanValue)mirror).value();
            if (!(mirror2 instanceof BooleanValue)) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            boolean bl2 = ((BooleanValue)mirror2).value();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    bl &= bl2;
                    break;
                }
                case OR_ASSIGNMENT: {
                    bl |= bl2;
                    break;
                }
                case XOR_ASSIGNMENT: {
                    bl ^= bl2;
                    break;
                }
                default: {
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
            object = this.mirrorOf(virtualMachine, bl);
            return this.setToMirror(compoundAssignmentTree.getVariable(), (Value)object, evaluationContext);
        }
        if (mirror instanceof DoubleValue) {
            double d = ((DoubleValue)mirror).value();
            if (!(mirror2 instanceof PrimitiveValue)) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            double d2 = ((PrimitiveValue)mirror2).doubleValue();
            switch (kind) {
                case DIVIDE_ASSIGNMENT: {
                    d /= d2;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    d -= d2;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    d *= d2;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    d += d2;
                    break;
                }
                default: {
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
            Value value = this.mirrorOf(virtualMachine, d);
            return this.setToMirror(compoundAssignmentTree.getVariable(), value, evaluationContext);
        }
        if (mirror instanceof FloatValue) {
            float f = ((FloatValue)mirror).value();
            if (!(mirror2 instanceof PrimitiveValue)) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            float f2 = ((PrimitiveValue)mirror2).floatValue();
            switch (kind) {
                case DIVIDE_ASSIGNMENT: {
                    f /= f2;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    f -= f2;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    f *= f2;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    f += f2;
                    break;
                }
                default: {
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
            object = this.mirrorOf(virtualMachine, Float.valueOf(f));
            return this.setToMirror(compoundAssignmentTree.getVariable(), (Value)object, evaluationContext);
        }
        if (mirror instanceof LongValue) {
            long l = ((LongValue)mirror).value();
            if (!(mirror2 instanceof PrimitiveValue)) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            long l2 = ((PrimitiveValue)mirror2).longValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    l &= l2;
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    l /= l2;
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    l <<= (int)l2;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    l -= l2;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    l *= l2;
                    break;
                }
                case OR_ASSIGNMENT: {
                    l |= l2;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    l += l2;
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    l %= l2;
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    l >>= (int)l2;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    l >>>= (int)l2;
                    break;
                }
                case XOR_ASSIGNMENT: {
                    l ^= l2;
                    break;
                }
                default: {
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
            Value value = this.mirrorOf(virtualMachine, l);
            return this.setToMirror(compoundAssignmentTree.getVariable(), value, evaluationContext);
        }
        if (mirror instanceof IntegerValue) {
            int n = ((IntegerValue)mirror).value();
            if (!(mirror2 instanceof PrimitiveValue)) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            int n2 = ((PrimitiveValue)mirror2).intValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    n &= n2;
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    n /= n2;
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    n <<= n2;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    n -= n2;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    n *= n2;
                    break;
                }
                case OR_ASSIGNMENT: {
                    n |= n2;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    n += n2;
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    n %= n2;
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    n >>= n2;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    n >>>= n2;
                    break;
                }
                case XOR_ASSIGNMENT: {
                    n ^= n2;
                    break;
                }
                default: {
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
            object = this.mirrorOf(virtualMachine, n);
            return this.setToMirror(compoundAssignmentTree.getVariable(), (Value)object, evaluationContext);
        }
        if (mirror instanceof ShortValue) {
            short s = ((ShortValue)mirror).value();
            if (!(mirror2 instanceof PrimitiveValue)) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            int n = ((PrimitiveValue)mirror2).intValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    s = (short)(s & n);
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    s = (short)(s / n);
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    s = (short)(s << n);
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    s = (short)(s - n);
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    s = (short)(s * n);
                    break;
                }
                case OR_ASSIGNMENT: {
                    s = (short)(s | n);
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    s = (short)(s + n);
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    s = (short)(s % n);
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    s = (short)(s >> n);
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    s = (short)(s >>> n);
                    break;
                }
                case XOR_ASSIGNMENT: {
                    s = (short)(s ^ n);
                    break;
                }
                default: {
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
            object = this.mirrorOf(virtualMachine, s);
            return this.setToMirror(compoundAssignmentTree.getVariable(), (Value)object, evaluationContext);
        }
        if (mirror instanceof CharValue) {
            char c = ((CharValue)mirror).value();
            if (!(mirror2 instanceof PrimitiveValue)) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            int n = ((PrimitiveValue)mirror2).intValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    c = (char)(c & n);
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    c = (char)(c / n);
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    c = (char)(c << n);
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    c = (char)(c - n);
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    c = (char)(c * n);
                    break;
                }
                case OR_ASSIGNMENT: {
                    c = (char)(c | n);
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    c = (char)(c + n);
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    c = (char)(c % n);
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    c = (char)(c >> n);
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    c = (char)(c >>> n);
                    break;
                }
                case XOR_ASSIGNMENT: {
                    c = (char)(c ^ n);
                    break;
                }
                default: {
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
            object = this.mirrorOf(virtualMachine, Character.valueOf(c));
            return this.setToMirror(compoundAssignmentTree.getVariable(), (Value)object, evaluationContext);
        }
        if (mirror instanceof ByteValue) {
            byte by = ((ByteValue)mirror).value();
            if (!(mirror2 instanceof PrimitiveValue)) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            int n = ((PrimitiveValue)mirror2).intValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    by = (byte)(by & n);
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    by = (byte)(by / n);
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    by = (byte)(by << n);
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    by = (byte)(by - n);
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    by = (byte)(by * n);
                    break;
                }
                case OR_ASSIGNMENT: {
                    by = (byte)(by | n);
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    by = (byte)(by + n);
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    by = (byte)(by % n);
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    by = (byte)(by >> n);
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    by = (byte)(by >>> n);
                    break;
                }
                case XOR_ASSIGNMENT: {
                    by = (byte)(by ^ n);
                    break;
                }
                default: {
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
            object = this.mirrorOf(virtualMachine, by);
            return this.setToMirror(compoundAssignmentTree.getVariable(), (Value)object, evaluationContext);
        }
        if (mirror instanceof StringReference) {
            object2 = ((StringReference)mirror).value();
            if (mirror2 != null && !(mirror2 instanceof StringReference)) {
                Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
            }
            element = mirror2 != null ? ((StringReference)mirror2).value() : null;
            switch (kind) {
                case PLUS_ASSIGNMENT: {
                    object2 = (String)object2 + (String)((Object)element);
                    break;
                }
                default: {
                    Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
                }
            }
            object = EvaluatorVisitor.createStringMirrorWithDisabledCollection((String)object2, virtualMachine, evaluationContext);
            return this.setToMirror(compoundAssignmentTree.getVariable(), (Value)object, evaluationContext);
        }
        Assert.error(compoundAssignmentTree, "evaluateError", compoundAssignmentTree.getVariable(), EvaluatorVisitor.operatorToString(kind), compoundAssignmentTree.getExpression());
        throw new IllegalStateException("Unknown assignment var type: " + mirror);
    }

    @Override
    public Mirror visitBinary(BinaryTree binaryTree, EvaluationContext evaluationContext) {
        boolean bl;
        boolean bl2;
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        Tree.Kind kind = binaryTree.getKind();
        Mirror mirror = binaryTree.getLeftOperand().accept(this, evaluationContext);
        Mirror mirror2 = null;
        if (mirror instanceof ObjectReference && (kind == Tree.Kind.EQUAL_TO || kind == Tree.Kind.NOT_EQUAL_TO) && (mirror2 = binaryTree.getRightOperand().accept(this, evaluationContext)) instanceof ObjectReference) {
            if (kind == Tree.Kind.EQUAL_TO) {
                return this.mirrorOf(virtualMachine, mirror.equals(mirror2));
            }
            return this.mirrorOf(virtualMachine, !mirror.equals(mirror2));
        }
        if (mirror instanceof ObjectReference) {
            mirror = EvaluatorVisitor.unboxIfCan(binaryTree, (ObjectReference)mirror, evaluationContext);
        }
        if (mirror instanceof BooleanValue) {
            bl2 = ((BooleanValue)mirror).booleanValue();
            if (kind == Tree.Kind.CONDITIONAL_AND && !bl2) {
                return this.mirrorOf(virtualMachine, false);
            }
            if (kind == Tree.Kind.CONDITIONAL_OR && bl2) {
                return this.mirrorOf(virtualMachine, true);
            }
        }
        if (mirror2 == null) {
            mirror2 = binaryTree.getRightOperand().accept(this, evaluationContext);
        }
        if (mirror2 instanceof ObjectReference) {
            mirror2 = EvaluatorVisitor.unboxIfCan(binaryTree, (ObjectReference)mirror2, evaluationContext);
        }
        if (mirror instanceof BooleanValue && mirror2 instanceof BooleanValue) {
            boolean bl3;
            bl2 = ((BooleanValue)mirror).booleanValue();
            boolean bl4 = ((BooleanValue)mirror2).booleanValue();
            switch (kind) {
                case AND: {
                    bl3 = bl2 & bl4;
                    break;
                }
                case CONDITIONAL_AND: {
                    bl3 = bl2 && bl4;
                    break;
                }
                case CONDITIONAL_OR: {
                    bl3 = bl2 || bl4;
                    break;
                }
                case EQUAL_TO: {
                    bl3 = bl2 == bl4;
                    break;
                }
                case NOT_EQUAL_TO: {
                    bl3 = bl2 != bl4;
                    break;
                }
                case OR: {
                    bl3 = bl2 | bl4;
                    break;
                }
                case XOR: {
                    bl3 = bl2 ^ bl4;
                    break;
                }
                default: {
                    this.reportCannotApplyOperator(binaryTree);
                    return null;
                }
            }
            return this.mirrorOf(virtualMachine, bl3);
        }
        bl2 = mirror instanceof PrimitiveValue && !(mirror instanceof BooleanValue);
        boolean bl5 = bl = mirror2 instanceof PrimitiveValue && !(mirror2 instanceof BooleanValue);
        if (bl2 && bl) {
            if (mirror instanceof DoubleValue || mirror2 instanceof DoubleValue) {
                double d = ((PrimitiveValue)mirror).doubleValue();
                double d2 = ((PrimitiveValue)mirror2).doubleValue();
                double d3 = 0.0;
                boolean bl6 = false;
                boolean bl7 = true;
                switch (kind) {
                    case DIVIDE: {
                        d3 = d / d2;
                        bl7 = false;
                        break;
                    }
                    case MINUS: {
                        d3 = d - d2;
                        bl7 = false;
                        break;
                    }
                    case MULTIPLY: {
                        d3 = d * d2;
                        bl7 = false;
                        break;
                    }
                    case PLUS: {
                        d3 = d + d2;
                        bl7 = false;
                        break;
                    }
                    case EQUAL_TO: {
                        bl6 = d == d2;
                        break;
                    }
                    case GREATER_THAN: {
                        bl6 = d > d2;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        bl6 = d >= d2;
                        break;
                    }
                    case LESS_THAN: {
                        bl6 = d < d2;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        bl6 = d <= d2;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        bl6 = d != d2;
                        break;
                    }
                    default: {
                        this.reportCannotApplyOperator(binaryTree);
                        return null;
                    }
                }
                if (bl7) {
                    return this.mirrorOf(virtualMachine, bl6);
                }
                return this.mirrorOf(virtualMachine, d3);
            }
            if (mirror instanceof FloatValue || mirror2 instanceof FloatValue) {
                float f = ((PrimitiveValue)mirror).floatValue();
                float f2 = ((PrimitiveValue)mirror2).floatValue();
                float f3 = 0.0f;
                boolean bl8 = false;
                boolean bl9 = true;
                switch (kind) {
                    case DIVIDE: {
                        f3 = f / f2;
                        bl9 = false;
                        break;
                    }
                    case MINUS: {
                        f3 = f - f2;
                        bl9 = false;
                        break;
                    }
                    case MULTIPLY: {
                        f3 = f * f2;
                        bl9 = false;
                        break;
                    }
                    case PLUS: {
                        f3 = f + f2;
                        bl9 = false;
                        break;
                    }
                    case EQUAL_TO: {
                        bl8 = f == f2;
                        break;
                    }
                    case GREATER_THAN: {
                        bl8 = f > f2;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        bl8 = f >= f2;
                        break;
                    }
                    case LESS_THAN: {
                        bl8 = f < f2;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        bl8 = f <= f2;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        bl8 = f != f2;
                        break;
                    }
                    default: {
                        this.reportCannotApplyOperator(binaryTree);
                        return null;
                    }
                }
                if (bl9) {
                    return this.mirrorOf(virtualMachine, bl8);
                }
                return this.mirrorOf(virtualMachine, Float.valueOf(f3));
            }
            if (mirror instanceof LongValue || mirror2 instanceof LongValue) {
                long l = ((PrimitiveValue)mirror).longValue();
                long l2 = ((PrimitiveValue)mirror2).longValue();
                long l3 = 0L;
                boolean bl10 = false;
                boolean bl11 = false;
                switch (kind) {
                    case DIVIDE: {
                        l3 = l / l2;
                        break;
                    }
                    case MINUS: {
                        l3 = l - l2;
                        break;
                    }
                    case MULTIPLY: {
                        l3 = l * l2;
                        break;
                    }
                    case PLUS: {
                        l3 = l + l2;
                        break;
                    }
                    case REMAINDER: {
                        l3 = l % l2;
                        break;
                    }
                    case LEFT_SHIFT: {
                        l3 = l << (int)l2;
                        break;
                    }
                    case RIGHT_SHIFT: {
                        l3 = l >> (int)l2;
                        break;
                    }
                    case UNSIGNED_RIGHT_SHIFT: {
                        l3 = l >>> (int)l2;
                        break;
                    }
                    case AND: {
                        l3 = l & l2;
                        break;
                    }
                    case OR: {
                        l3 = l | l2;
                        break;
                    }
                    case XOR: {
                        l3 = l ^ l2;
                        break;
                    }
                    case EQUAL_TO: {
                        bl10 = l == l2;
                        bl11 = true;
                        break;
                    }
                    case GREATER_THAN: {
                        bl10 = l > l2;
                        bl11 = true;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        bl10 = l >= l2;
                        bl11 = true;
                        break;
                    }
                    case LESS_THAN: {
                        bl10 = l < l2;
                        bl11 = true;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        bl10 = l <= l2;
                        bl11 = true;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        bl10 = l != l2;
                        bl11 = true;
                        break;
                    }
                    default: {
                        this.reportCannotApplyOperator(binaryTree);
                        return null;
                    }
                }
                if (bl11) {
                    return this.mirrorOf(virtualMachine, bl10);
                }
                return this.mirrorOf(virtualMachine, l3);
            }
            int n = ((PrimitiveValue)mirror).intValue();
            int n2 = ((PrimitiveValue)mirror2).intValue();
            int n3 = 0;
            boolean bl12 = false;
            boolean bl13 = false;
            switch (kind) {
                case DIVIDE: {
                    n3 = n / n2;
                    break;
                }
                case MINUS: {
                    n3 = n - n2;
                    break;
                }
                case MULTIPLY: {
                    n3 = n * n2;
                    break;
                }
                case PLUS: {
                    n3 = n + n2;
                    break;
                }
                case REMAINDER: {
                    n3 = n % n2;
                    break;
                }
                case LEFT_SHIFT: {
                    n3 = n << n2;
                    break;
                }
                case RIGHT_SHIFT: {
                    n3 = n >> n2;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    n3 = n >>> n2;
                    break;
                }
                case AND: {
                    n3 = n & n2;
                    break;
                }
                case OR: {
                    n3 = n | n2;
                    break;
                }
                case XOR: {
                    n3 = n ^ n2;
                    break;
                }
                case EQUAL_TO: {
                    bl12 = n == n2;
                    bl13 = true;
                    break;
                }
                case GREATER_THAN: {
                    bl12 = n > n2;
                    bl13 = true;
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    bl12 = n >= n2;
                    bl13 = true;
                    break;
                }
                case LESS_THAN: {
                    bl12 = n < n2;
                    bl13 = true;
                    break;
                }
                case LESS_THAN_EQUAL: {
                    bl12 = n <= n2;
                    bl13 = true;
                    break;
                }
                case NOT_EQUAL_TO: {
                    bl12 = n != n2;
                    bl13 = true;
                    break;
                }
                default: {
                    this.reportCannotApplyOperator(binaryTree);
                    return null;
                }
            }
            if (bl13) {
                return this.mirrorOf(virtualMachine, bl12);
            }
            return this.mirrorOf(virtualMachine, n3);
        }
        if ((mirror == null || mirror instanceof StringReference) && (mirror2 == null || mirror2 instanceof StringReference) && kind == Tree.Kind.PLUS) {
            String string = mirror == null ? null : ((StringReference)mirror).value();
            String string2 = mirror2 == null ? null : ((StringReference)mirror2).value();
            switch (kind) {
                case PLUS: {
                    return EvaluatorVisitor.createStringMirrorWithDisabledCollection(string + string2, virtualMachine, evaluationContext);
                }
            }
            this.reportCannotApplyOperator(binaryTree);
            return null;
        }
        if ((mirror instanceof StringReference || mirror2 instanceof StringReference) && kind == Tree.Kind.PLUS) {
            String string = mirror instanceof StringReference ? ((StringReference)mirror).value() : this.toString(binaryTree, mirror, evaluationContext);
            String string3 = mirror2 instanceof StringReference ? ((StringReference)mirror2).value() : this.toString(binaryTree, mirror2, evaluationContext);
            return EvaluatorVisitor.createStringMirrorWithDisabledCollection(string + string3, virtualMachine, evaluationContext);
        }
        switch (kind) {
            case EQUAL_TO: {
                return this.mirrorOf(virtualMachine, mirror == mirror2 || mirror != null && mirror.equals(mirror2));
            }
            case NOT_EQUAL_TO: {
                return this.mirrorOf(virtualMachine, mirror == null && mirror2 != null || mirror != null && !mirror.equals(mirror2));
            }
        }
        this.reportCannotApplyOperator(binaryTree);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitBlock(BlockTree blockTree, EvaluationContext evaluationContext) {
        Mirror mirror = null;
        try {
            evaluationContext.pushBlock();
            for (StatementTree statementTree : blockTree.getStatements()) {
                Mirror mirror2 = statementTree.accept(this, evaluationContext);
                if (mirror2 != null) {
                    mirror = mirror2;
                }
                if (!(mirror2 instanceof CommandMirror)) continue;
                break;
            }
        }
        finally {
            evaluationContext.popBlock();
        }
        return mirror;
    }

    @Override
    public Mirror visitBreak(BreakTree breakTree, EvaluationContext evaluationContext) {
        Name name = breakTree.getLabel();
        if (name != null) {
            Assert.error(breakTree, "unsupported");
            return null;
        }
        return new Break();
    }

    @Override
    public Mirror visitCase(CaseTree caseTree, EvaluationContext evaluationContext) {
        Assert.error(caseTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitCatch(CatchTree catchTree, EvaluationContext evaluationContext) {
        Assert.error(catchTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitClass(ClassTree classTree, EvaluationContext evaluationContext) {
        Assert.error(classTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, EvaluationContext evaluationContext) {
        Mirror mirror = conditionalExpressionTree.getCondition().accept(this, evaluationContext);
        if (!(mirror instanceof BooleanValue)) {
            throw new IllegalStateException("Condition must be boolean: " + conditionalExpressionTree.getCondition());
        }
        boolean bl = ((BooleanValue)mirror).value();
        if (bl) {
            return conditionalExpressionTree.getTrueExpression().accept(this, evaluationContext);
        }
        return conditionalExpressionTree.getFalseExpression().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitContinue(ContinueTree continueTree, EvaluationContext evaluationContext) {
        Name name = continueTree.getLabel();
        if (name != null) {
            Assert.error(continueTree, "unsupported");
            return null;
        }
        return new Continue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, EvaluationContext evaluationContext) {
        ExpressionTree expressionTree = doWhileLoopTree.getCondition();
        StatementTree statementTree = doWhileLoopTree.getStatement();
        Mirror mirror = null;
        do {
            try {
                evaluationContext.pushBlock();
                Mirror mirror2 = statementTree.accept(this, evaluationContext);
                if (mirror2 instanceof Break) break;
                if (mirror2 instanceof Continue || mirror2 == null) continue;
                mirror = mirror2;
            }
            finally {
                evaluationContext.popBlock();
            }
        } while (((BooleanValue)expressionTree.accept(this, evaluationContext)).value());
        return mirror;
    }

    @Override
    public Mirror visitErroneous(ErroneousTree erroneousTree, EvaluationContext evaluationContext) {
        Assert.error(erroneousTree, "errorneous");
        return null;
    }

    @Override
    public Mirror visitExpressionStatement(ExpressionStatementTree expressionStatementTree, EvaluationContext evaluationContext) {
        return expressionStatementTree.getExpression().accept(this, evaluationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Mirror visitEnhancedForLoop(EnhancedForLoopTree var1_1, EvaluationContext var2_2) {
        block24: {
            var3_3 = var1_1.getExpression();
            var4_4 = var3_3.accept(this, var2_2);
            var5_5 = null;
            var6_6 = null;
            var7_7 = null;
            if (!(var4_4 instanceof ObjectReference)) {
                Assert.error(var1_1, "forEachNotApplicable");
            }
            var8_8 = true;
            var9_9 = 0;
            if (!(var4_4 instanceof ArrayReference)) {
                var8_8 = false;
                if (!var2_2.canInvokeMethods()) {
                    Assert.error(var1_1, "canNotInvokeMethods");
                }
                var10_10 /* !! */  = (ObjectReference)var4_4;
                var11_11 = var10_10 /* !! */ .referenceType();
                var12_12 = var2_2.getDebugger().getVirtualMachine();
                if (var12_12 == null) {
                    return null;
                }
                var13_13 = EvaluatorVisitor.getOrLoadClass((VirtualMachine)var12_12, "java.util.Collection", var2_2);
                if (!EvaluatorVisitor.instanceOf(var10_10 /* !! */ .type(), (Type)var13_13)) {
                    Assert.error(var1_1, "forEachNotApplicable");
                }
                var14_14 = null;
                try {
                    var14_14 = EvaluatorVisitor.getConcreteMethod((ReferenceType)var11_11, "iterator", Collections.EMPTY_LIST);
                }
                catch (UnsuitableArgumentsException var15_16) {
                    // empty catch block
                }
                var7_7 = (ObjectReference)this.invokeMethod(var1_1, var14_14, Boolean.FALSE, (ClassType)var10_10 /* !! */ .type(), var10_10 /* !! */ , Collections.EMPTY_LIST, var2_2, false);
                try {
                    var15_17 /* !! */  = var7_7.referenceType();
                    var5_5 = EvaluatorVisitor.getConcreteMethod((ReferenceType)var15_17 /* !! */ , "next", Collections.EMPTY_LIST);
                    var6_6 = EvaluatorVisitor.getConcreteMethod((ReferenceType)var15_17 /* !! */ , "hasNext", Collections.EMPTY_LIST);
                }
                catch (UnsuitableArgumentsException var15_18) {}
            } else {
                var9_9 = ((ArrayReference)var4_4).length();
            }
            var10_10 /* !! */  = null;
            var2_2.pushBlock();
            var11_11 = var1_1.getVariable();
            var11_11.accept(this, var2_2);
            var12_12 = var2_2.getScriptVariableByName(var11_11.getName().toString());
            var13_13 = var1_1.getStatement();
            var14_15 = 0;
            while (true) lbl-1000:
            // 4 sources

            {
                if (var8_8) {
                    if (var14_15 >= var9_9) {
                        break block24;
                    }
                    var15_17 /* !! */  = ((ArrayReference)var4_4).getValue(var14_15);
                    ++var14_15;
                } else {
                    var15_17 /* !! */  = this.invokeMethod(var1_1, var6_6, Boolean.FALSE, (ClassType)var7_7.type(), (ObjectReference)var7_7, Collections.EMPTY_LIST, var2_2, false);
                    if (!((BooleanValue)var15_17 /* !! */ ).value()) {
                        break block24;
                    }
                    var15_17 /* !! */  = this.invokeMethod(var1_1, var5_5, Boolean.FALSE, (ClassType)var7_7.type(), (ObjectReference)var7_7, Collections.EMPTY_LIST, var2_2, false);
                }
                var12_12.setValue(var15_17 /* !! */ );
                try {
                    var2_2.pushBlock();
                    var16_19 = var13_13.accept(this, var2_2);
                    if (!(var16_19 instanceof Break)) {
                        if (var16_19 instanceof Continue || var16_19 == null) ** GOTO lbl-1000
                        var10_10 /* !! */  = var16_19;
                    }
                    break block24;
                }
                finally {
                    var2_2.popBlock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                var2_2.popBlock();
            }
        }
        return var10_10 /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitForLoop(ForLoopTree forLoopTree, EvaluationContext evaluationContext) {
        try {
            Object object;
            evaluationContext.pushBlock();
            for (StatementTree tree2 : forLoopTree.getInitializer()) {
                tree2.accept(this, evaluationContext);
            }
            Object object2 = null;
            ExpressionTree expressionTree = forLoopTree.getCondition();
            List<? extends ExpressionStatementTree> list = forLoopTree.getUpdate();
            StatementTree statementTree = forLoopTree.getStatement();
            while (expressionTree == null || ((BooleanValue)expressionTree.accept(this, evaluationContext)).value()) {
                object = null;
                try {
                    evaluationContext.pushBlock();
                    object = statementTree.accept(this, evaluationContext);
                    if (object instanceof Break) break;
                    if (object instanceof Continue || object == null) continue;
                    object2 = object;
                }
                finally {
                    evaluationContext.popBlock();
                    if (!(object instanceof Continue) && object instanceof CommandMirror) continue;
                    for (ExpressionStatementTree expressionStatementTree : list) {
                        expressionStatementTree.accept(this, evaluationContext);
                    }
                }
            }
            object = object2;
            return object;
        }
        finally {
            evaluationContext.popBlock();
        }
    }

    private Mirror getIdentifierByName(IdentifierTree identifierTree, EvaluationContext evaluationContext) {
        Comparable<ReferenceType> comparable;
        ObjectReference objectReference;
        Comparable<com.sun.jdi.LocalVariable> comparable2;
        Object object;
        String string = identifierTree.getName().toString();
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        List<ReferenceType> list = virtualMachine.classesByName(string);
        if (list.size() > 0) {
            try {
                ReferenceType referenceType = JPDAUtils.getPreferredReferenceType(list, null);
                if (referenceType != null) {
                    return referenceType;
                }
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                throw vMDisconnectedExceptionWrapper.getCause();
            }
            return list.get(0);
        }
        if (string.equals("this")) {
            return evaluationContext.getContextObject();
        }
        if (string.equals("super") && (object = evaluationContext.getFrame().location().declaringType()) instanceof ClassType) {
            ClassType classType = ((ClassType)object).superclass();
            ObjectReference objectReference2 = evaluationContext.getContextObject();
            if (objectReference2 == null) {
                return classType;
            }
            this.subExpressionTypes.put(identifierTree, classType);
            return objectReference2;
        }
        object = evaluationContext.getScriptVariableByName(string);
        if (object != null) {
            evaluationContext.putScriptVariable(identifierTree, (EvaluationContext.ScriptVariable)object);
            return ((EvaluationContext.ScriptVariable)object).getValue();
        }
        try {
            comparable2 = evaluationContext.getFrame().visibleVariableByName(string);
            if (comparable2 != null) {
                evaluationContext.putLocalVariable(identifierTree, (com.sun.jdi.LocalVariable)comparable2);
                return evaluationContext.getFrame().getValue((com.sun.jdi.LocalVariable)comparable2);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        comparable2 = evaluationContext.getContextObject() != null ? evaluationContext.getContextObject().referenceType().fieldByName(string) : evaluationContext.getFrame().location().declaringType().fieldByName(string);
        if (comparable2 != null) {
            if (comparable2.isStatic()) {
                evaluationContext.putField(identifierTree, (Field)comparable2, null);
                Value value = comparable2.declaringType().getValue((Field)comparable2);
                if (value instanceof ObjectReference) {
                    evaluationContext.disableCollectionOf((ObjectReference)value);
                }
                return value;
            }
            objectReference = evaluationContext.getContextObject();
            if (objectReference != null) {
                evaluationContext.putField(identifierTree, (Field)comparable2, objectReference);
                Value value = objectReference.getValue((Field)comparable2);
                if (value instanceof ObjectReference) {
                    evaluationContext.disableCollectionOf((ObjectReference)value);
                }
                return value;
            }
        }
        if ((objectReference = evaluationContext.getContextObject()) != null && (comparable = objectReference.referenceType().fieldByName("val$" + string)) != null) {
            Value value = objectReference.getValue((Field)comparable);
            evaluationContext.putField(identifierTree, (Field)comparable, objectReference);
            return value;
        }
        comparable = EvaluatorVisitor.getOrLoadClass(virtualMachine, string, evaluationContext);
        if (comparable != null) {
            return comparable;
        }
        Assert.error((Tree)identifierTree, "unknownVariable", string);
        return null;
    }

    @Override
    public Mirror visitIdentifier(IdentifierTree identifierTree, EvaluationContext evaluationContext) {
        Object object;
        String string = identifierTree.getName().toString();
        if (this.expression.classReplaced().equals(string)) {
            ReferenceType referenceType = evaluationContext.getFrame().location().declaringType();
            JPDAClassType jPDAClassType = evaluationContext.getDebugger().getClassType(referenceType);
            return ((JDIVariable)jPDAClassType.classObject()).getJDIValue();
        }
        if (this.expression.returnReplaced().equals(string)) {
            ThreadReference threadReference = evaluationContext.getFrame().thread();
            JPDAThreadImpl jPDAThreadImpl = evaluationContext.getDebugger().getThread(threadReference);
            ReturnVariableImpl returnVariableImpl = jPDAThreadImpl.getReturnVariable();
            if (returnVariableImpl != null) {
                return returnVariableImpl.getJDIValue();
            }
            return null;
        }
        ObjectVariable objectVariable = evaluationContext.getDebugger().getLabeledVariable(string);
        if (objectVariable != null) {
            return ((JDIVariable)objectVariable).getJDIValue();
        }
        TreePath treePath = this.getCurrentPath();
        Element element = null;
        if (treePath != null) {
            object = TreePath.getPath(treePath, (Tree)identifierTree);
            if (object == null) {
                object = this.getCurrentPath();
            }
            if ((element = evaluationContext.getTrees().getElement((TreePath)object)) instanceof TypeElement && ((TypeElement)element).asType() instanceof ErrorType) {
                treePath = null;
            }
        }
        if (treePath == null || element == null) {
            return this.getIdentifierByName(identifierTree, evaluationContext);
        }
        switch (element.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                object = (TypeElement)element;
                String string2 = ElementUtilities.getBinaryName((TypeElement)object);
                VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
                if (virtualMachine == null) {
                    return null;
                }
                ReferenceType referenceType = EvaluatorVisitor.getOrLoadClass(virtualMachine, string2, evaluationContext);
                if (referenceType != null) {
                    return referenceType;
                }
                Assert.error((Tree)identifierTree, "unknownType", string2);
            }
            case TYPE_PARAMETER: {
                ReferenceType referenceType;
                VirtualMachine virtualMachine;
                TypeParameterElement typeParameterElement = (TypeParameterElement)element;
                List<? extends TypeMirror> list = typeParameterElement.getBounds();
                for (TypeMirror typeMirror : list) {
                    String string3 = EvaluatorVisitor.getTypeName(typeMirror);
                    virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
                    if (virtualMachine == null) {
                        return null;
                    }
                    referenceType = EvaluatorVisitor.getOrLoadClass(virtualMachine, string3, evaluationContext);
                    if (referenceType == null) continue;
                    return referenceType;
                }
                Assert.error((Tree)identifierTree, "unknownType", typeParameterElement.getSimpleName().toString());
            }
            case ENUM_CONSTANT: {
                return this.getEnumConstant(identifierTree, (VariableElement)element, evaluationContext);
            }
            case FIELD: {
                Value value;
                Comparable<Field> comparable;
                Comparable<Field> comparable2;
                Object object2;
                VariableElement variableElement = (VariableElement)element;
                String string4 = variableElement.getSimpleName().toString();
                if (string4.equals("this")) {
                    return evaluationContext.getContextObject();
                }
                if (string4.equals("super") && (object2 = evaluationContext.getFrame().location().declaringType()) instanceof ClassType) {
                    ClassType classType = ((ClassType)object2).superclass();
                    ObjectReference objectReference = evaluationContext.getContextObject();
                    if (objectReference == null) {
                        return classType;
                    }
                    this.subExpressionTypes.put(identifierTree, classType);
                    return objectReference;
                }
                object2 = variableElement.getEnclosingElement();
                String string5 = null;
                if (object2.getKind() == ElementKind.CLASS) {
                    comparable2 = (TypeElement)object2;
                    string5 = ElementUtilities.getBinaryName((TypeElement)((Object)comparable2));
                }
                comparable2 = evaluationContext.getFrame().location().declaringType();
                if (string5 != null && (comparable = this.findEnclosingType((ReferenceType)comparable2, string5)) != null) {
                    comparable2 = comparable;
                }
                if ((comparable = comparable2.fieldByName(string4)) == null) {
                    Assert.error((Tree)identifierTree, "unknownVariable", string4);
                }
                if (comparable.isStatic()) {
                    evaluationContext.putField(identifierTree, (Field)comparable, null);
                    Value value2 = comparable2.getValue((Field)comparable);
                    if (value2 instanceof ObjectReference) {
                        evaluationContext.disableCollectionOf((ObjectReference)value2);
                    }
                    return value2;
                }
                ObjectReference objectReference = evaluationContext.getContextObject();
                if (objectReference != null) {
                    if (comparable.isPrivate()) {
                        objectReference = value = this.findEnclosingObject(identifierTree, objectReference, (ReferenceType)comparable2, comparable.name(), null);
                    } else if (!EvaluatorVisitor.instanceOf(objectReference.referenceType(), comparable2)) {
                        objectReference = value = this.findEnclosingObject(identifierTree, objectReference, (ReferenceType)comparable2, comparable.name(), null);
                    }
                }
                if (objectReference != null) {
                    evaluationContext.putField(identifierTree, (Field)comparable, objectReference);
                    try {
                        value = objectReference.getValue((Field)comparable);
                        if (value instanceof ObjectReference) {
                            evaluationContext.disableCollectionOf((ObjectReference)value);
                        }
                        return value;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.getLogger(this.getClass().getName()).severe("field = " + comparable + ", thisObject = " + objectReference);
                        throw illegalArgumentException;
                    }
                }
                Assert.error((Tree)identifierTree, "accessInstanceVariableFromStaticContext", string4);
                throw new IllegalStateException("No current instance available.");
            }
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: {
                VariableElement variableElement = (VariableElement)element;
                String string6 = variableElement.getSimpleName().toString();
                EvaluationContext.ScriptVariable scriptVariable = evaluationContext.getScriptVariableByName(string6);
                if (scriptVariable != null) {
                    evaluationContext.putScriptVariable(identifierTree, scriptVariable);
                    return scriptVariable.getValue();
                }
                try {
                    com.sun.jdi.LocalVariable localVariable = evaluationContext.getFrame().visibleVariableByName(string6);
                    if (localVariable == null) {
                        Field field;
                        ObjectReference objectReference;
                        try {
                            objectReference = evaluationContext.getFrame().thisObject();
                        }
                        catch (InternalException internalException) {
                            if (internalException.errorCode() == 35) {
                                objectReference = null;
                            }
                            throw internalException;
                        }
                        if (objectReference != null && (field = objectReference.referenceType().fieldByName("val$" + string6)) != null) {
                            Value value = objectReference.getValue(field);
                            evaluationContext.putField(identifierTree, field, objectReference);
                            return value;
                        }
                        Assert.error((Tree)identifierTree, "unknownVariable", string6);
                    }
                    evaluationContext.putLocalVariable(identifierTree, localVariable);
                    return evaluationContext.getFrame().getValue(localVariable);
                }
                catch (AbsentInformationException absentInformationException) {
                    return (Value)Assert.error((Tree)identifierTree, "unknownVariable", string6);
                }
            }
            case PARAMETER: {
                VariableElement variableElement = (VariableElement)element;
                String string7 = variableElement.getSimpleName().toString();
                StackFrame stackFrame = evaluationContext.getFrame();
                try {
                    com.sun.jdi.LocalVariable localVariable = stackFrame.visibleVariableByName(string7);
                    if (localVariable == null) {
                        Field field;
                        ObjectReference objectReference;
                        try {
                            objectReference = stackFrame.thisObject();
                        }
                        catch (InternalException internalException) {
                            if (internalException.errorCode() == 35) {
                                objectReference = null;
                            }
                            throw internalException;
                        }
                        if (objectReference != null && (field = objectReference.referenceType().fieldByName("val$" + string7)) != null) {
                            Value value = objectReference.getValue(field);
                            evaluationContext.putField(identifierTree, field, objectReference);
                            return value;
                        }
                        Assert.error((Tree)identifierTree, "unknownVariable", string7);
                    }
                    evaluationContext.putLocalVariable(identifierTree, localVariable);
                    return stackFrame.getValue(localVariable);
                }
                catch (AbsentInformationException absentInformationException) {
                    LocalVariable[] localVariableArray = new CallStackFrameImpl(evaluationContext.getDebugger().getThread(stackFrame.thread()), stackFrame, 0, evaluationContext.getDebugger()).getMethodArguments();
                    if (localVariableArray != null) {
                        for (LocalVariable localVariable : localVariableArray) {
                            if (!string7.equals(localVariable.getName())) continue;
                            return ((JDIVariable)localVariable).getJDIValue();
                        }
                    }
                    return (Value)Assert.error((Tree)identifierTree, "unknownVariable", string7);
                }
            }
            case PACKAGE: {
                return (Value)Assert.error(identifierTree, "notExpression");
            }
        }
        throw new UnsupportedOperationException("Not supported element kind:" + (Object)((Object)element.getKind()) + " Tree = '" + identifierTree + "'");
    }

    private ReferenceType findEnclosingType(ReferenceType referenceType, String string) {
        if (referenceType.name().equals(string)) {
            return referenceType;
        }
        List<ReferenceType> list = referenceType.virtualMachine().classesByName(string);
        if (list.size() == 1) {
            return list.get(0);
        }
        for (ReferenceType referenceType2 : list) {
            if (!this.isNestedOf(referenceType2, referenceType)) continue;
            return referenceType2;
        }
        return null;
    }

    private boolean isNestedOf(ReferenceType referenceType, ReferenceType referenceType2) {
        if (((Object)referenceType).equals(referenceType2)) {
            return true;
        }
        for (ReferenceType referenceType3 : referenceType.nestedTypes()) {
            if (!this.isNestedOf(referenceType3, referenceType2)) continue;
            return true;
        }
        return false;
    }

    private ObjectReference findEnclosingObject(Tree tree, ObjectReference objectReference, ReferenceType referenceType, String string, String string2) {
        if (EvaluatorVisitor.instanceOf(objectReference.referenceType(), referenceType)) {
            return objectReference;
        }
        if (((ReferenceType)objectReference.type()).isStatic()) {
            if (string != null) {
                Assert.error(tree, "accessInstanceVariableFromStaticContext", string);
            }
            if (string2 != null) {
                Assert.error(tree, "invokeInstanceMethodAsStatic", string2);
            }
            return null;
        }
        Field field = null;
        for (int i = 0; i < 9 && (field = objectReference.referenceType().fieldByName("this$" + i)) == null; ++i) {
        }
        if (field == null) {
            return null;
        }
        if ((objectReference = (ObjectReference)objectReference.getValue(field)) == null) {
            return null;
        }
        return this.findEnclosingObject(tree, objectReference, referenceType, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitIf(IfTree ifTree, EvaluationContext evaluationContext) {
        StatementTree statementTree;
        Object object;
        Mirror mirror = ifTree.getCondition().accept(this, evaluationContext);
        if (mirror instanceof ObjectReference) {
            mirror = EvaluatorVisitor.unboxIfCan(ifTree, (ObjectReference)mirror, evaluationContext);
        }
        if (!(mirror instanceof BooleanValue)) {
            object = "N/A";
            if (mirror instanceof Value) {
                object = ((Value)mirror).type().name();
            }
            Assert.error(ifTree, "notABoolean", ifTree.getCondition().toString(), mirror, object);
        }
        if ((statementTree = ((BooleanValue)mirror).value() ? ifTree.getThenStatement() : ifTree.getElseStatement()) != null) {
            try {
                evaluationContext.pushBlock();
                object = statementTree.accept(this, evaluationContext);
                return object;
            }
            finally {
                evaluationContext.popBlock();
            }
        }
        return null;
    }

    @Override
    public Mirror visitImport(ImportTree importTree, EvaluationContext evaluationContext) {
        Assert.error(importTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitArrayAccess(ArrayAccessTree arrayAccessTree, EvaluationContext evaluationContext) {
        int n;
        Mirror mirror = arrayAccessTree.getExpression().accept(this, evaluationContext);
        if (mirror == null) {
            Assert.error((Tree)arrayAccessTree, "arrayIsNull", arrayAccessTree.getExpression());
        }
        Mirror mirror2 = arrayAccessTree.getIndex().accept(this, evaluationContext);
        if (!(mirror instanceof ArrayReference)) {
            Assert.error((Tree)arrayAccessTree, "notArrayType", arrayAccessTree.getExpression());
        }
        if (!(mirror2 instanceof PrimitiveValue)) {
            Assert.error((Tree)arrayAccessTree, "arraySizeBadType", mirror2);
        }
        if ((n = ((PrimitiveValue)mirror2).intValue()) < 0 || n >= ((ArrayReference)mirror).length()) {
            Assert.error(arrayAccessTree, "arrayIndexOutOfBounds", mirror, n);
        }
        evaluationContext.putArrayAccess(arrayAccessTree, (ArrayReference)mirror, n);
        return ((ArrayReference)mirror).getValue(n);
    }

    @Override
    public Mirror visitLabeledStatement(LabeledStatementTree labeledStatementTree, EvaluationContext evaluationContext) {
        Assert.error(labeledStatementTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitLiteral(LiteralTree literalTree, EvaluationContext evaluationContext) {
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        Object object = literalTree.getValue();
        if (object instanceof Boolean) {
            return this.mirrorOf(virtualMachine, object);
        }
        if (object instanceof Byte) {
            return this.mirrorOf(virtualMachine, object);
        }
        if (object instanceof Character) {
            return this.mirrorOf(virtualMachine, object);
        }
        if (object instanceof Double) {
            return this.mirrorOf(virtualMachine, object);
        }
        if (object instanceof Float) {
            return this.mirrorOf(virtualMachine, object);
        }
        if (object instanceof Integer) {
            return this.mirrorOf(virtualMachine, object);
        }
        if (object instanceof Long) {
            return this.mirrorOf(virtualMachine, object);
        }
        if (object instanceof Short) {
            return this.mirrorOf(virtualMachine, object);
        }
        if (object instanceof String) {
            StringReference stringReference = EvaluatorVisitor.createStringMirrorWithDisabledCollection((String)object, virtualMachine, evaluationContext);
            ClassType classType = (ClassType)virtualMachine.classesByName("java.lang.String").get(0);
            try {
                List<Value> list = Collections.emptyList();
                return this.invokeMethod(literalTree, classType.methodsByName("intern").get(0), false, classType, stringReference, list, evaluationContext, false);
            }
            catch (Exception exception) {
                return stringReference;
            }
        }
        if (object == null) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported value: " + object);
    }

    @Override
    public Mirror visitMethod(MethodTree methodTree, EvaluationContext evaluationContext) {
        Assert.error(methodTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitModifiers(ModifiersTree modifiersTree, EvaluationContext evaluationContext) {
        Assert.error(modifiersTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitNewArray(NewArrayTree newArrayTree, EvaluationContext evaluationContext) {
        Type type;
        Tree tree = newArrayTree.getType();
        if (tree == null) {
            if (this.newArrayType == null) {
                throw new IllegalStateException("No type info for " + newArrayTree);
            }
            type = this.newArrayType;
        } else {
            type = (Type)newArrayTree.getType().accept(this, evaluationContext);
        }
        List<? extends ExpressionTree> list = newArrayTree.getDimensions();
        int n = list.size();
        if (n > 0) {
            int[] nArray = new int[n];
            ArrayType[] arrayTypeArray = new ArrayType[n];
            String string = type.name() + "[]";
            for (int i = 0; i < n; ++i) {
                nArray[i] = ((PrimitiveValue)list.get(n - 1 - i).accept(this, evaluationContext)).intValue();
                ReferenceType referenceType = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), string, evaluationContext);
                if (referenceType == null) {
                    Assert.error((Tree)newArrayTree, "unknownType", string);
                }
                arrayTypeArray[i] = (ArrayType)referenceType;
                string = string + "[]";
            }
            return this.constructNewArray(arrayTypeArray, nArray, n - 1, evaluationContext);
        }
        List<? extends ExpressionTree> list2 = newArrayTree.getInitializers();
        return this.constructNewArray(newArrayTree, type, list2, evaluationContext);
    }

    private ArrayReference constructNewArray(ArrayType[] arrayTypeArray, int[] nArray, int n, EvaluationContext evaluationContext) {
        ArrayReference arrayReference = EvaluatorVisitor.createArrayMirrorWithDisabledCollection(arrayTypeArray[n], nArray[n], evaluationContext);
        if (n > 0) {
            ArrayList<ArrayReference> arrayList = new ArrayList<ArrayReference>(nArray[n]);
            for (int i = 0; i < nArray[n]; ++i) {
                ArrayReference arrayReference2 = this.constructNewArray(arrayTypeArray, nArray, n - 1, evaluationContext);
                arrayList.add(arrayReference2);
            }
            try {
                arrayReference.setValues(arrayList);
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new IllegalStateException("ArrayType " + arrayTypeArray[n] + " can not have " + arrayList + " elements.");
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                throw new IllegalStateException(classNotLoadedException);
            }
        }
        return arrayReference;
    }

    private ArrayReference constructNewArray(NewArrayTree newArrayTree, Type type, List<? extends ExpressionTree> list, EvaluationContext evaluationContext) {
        Object object;
        int n;
        int n2 = list.size();
        ArrayList<Value> arrayList = new ArrayList<Value>(n2);
        for (n = 0; n < n2; ++n) {
            object = list.get(n);
            this.newArrayType = this.getSubArrayType(newArrayTree, type, evaluationContext);
            Value value = (Value)object.accept(this, evaluationContext);
            if (value instanceof ArtificialMirror) {
                value = (Value)((ArtificialMirror)((Object)value)).getVMMirror();
            }
            arrayList.add(value);
        }
        n = 1;
        object = EvaluatorVisitor.createArrayMirrorWithDisabledCollection(this.getArrayType(newArrayTree, type, n, evaluationContext), n2, evaluationContext);
        this.autoboxElements(newArrayTree, type, arrayList, evaluationContext);
        try {
            object.setValues(arrayList);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new IllegalStateException("ArrayType " + this.getArrayType(newArrayTree, type, n, evaluationContext) + " can not have " + arrayList + " elements.");
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new IllegalStateException(classNotLoadedException);
        }
        return object;
    }

    private ArrayType getArrayType(NewArrayTree newArrayTree, Type type, int n, EvaluationContext evaluationContext) {
        String string;
        if (n < BRACKETS.length() / 2) {
            string = type.name() + BRACKETS.substring(0, 2 * n);
        } else {
            string = type.name() + BRACKETS;
            for (int i = BRACKETS.length() / 2; i < n; ++i) {
                string = string + "[]";
            }
        }
        ReferenceType referenceType = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), string, evaluationContext);
        if (referenceType == null) {
            Assert.error((Tree)newArrayTree, "unknownType", string);
        }
        return (ArrayType)referenceType;
    }

    private Type getSubArrayType(Tree tree, Type type, EvaluationContext evaluationContext) {
        String string = type.name();
        if (string.endsWith("[]")) {
            Type type2;
            if (!(string = string.substring(0, string.length() - 2)).endsWith("[]") && (type2 = this.getPrimitiveType(string, type.virtualMachine())) != null) {
                return type2;
            }
            if ((type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), string, evaluationContext)) == null) {
                Assert.error(tree, "unknownType", string);
            }
        }
        return type;
    }

    private Type getPrimitiveType(String string, VirtualMachine virtualMachine) {
        if (string.equals(Boolean.TYPE.getName())) {
            return virtualMachine.mirrorOf(true).type();
        }
        if (string.equals(Byte.TYPE.getName())) {
            return virtualMachine.mirrorOf((byte)0).type();
        }
        if (string.equals(Character.TYPE.getName())) {
            return virtualMachine.mirrorOf('a').type();
        }
        if (string.equals(Double.TYPE.getName())) {
            return virtualMachine.mirrorOf(0.0).type();
        }
        if (string.equals(Float.TYPE.getName())) {
            return virtualMachine.mirrorOf(0.0f).type();
        }
        if (string.equals(Integer.TYPE.getName())) {
            return virtualMachine.mirrorOf(0).type();
        }
        if (string.equals(Long.TYPE.getName())) {
            return virtualMachine.mirrorOf(0L).type();
        }
        if (string.equals(Short.TYPE.getName())) {
            return virtualMachine.mirrorOf((short)0).type();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Mirror visitNewClass(NewClassTree newClassTree, EvaluationContext evaluationContext) {
        ReferenceType referenceType;
        Object object;
        Object object22;
        Object incompatibleThreadStateException;
        Object object3;
        Object object6;
        TypeMirror typeMirror;
        Object object7;
        Object object8;
        TreePath treePath;
        ClassTree classTree = newClassTree.getClassBody();
        if (classTree != null) {
            Assert.error(newClassTree, "noNewClassWithBody");
        }
        if ((treePath = this.getCurrentPath()) != null) {
            object8 = TreePath.getPath(treePath, (Tree)newClassTree);
            if (object8 == null) {
                object8 = treePath;
            }
            if ((object7 = evaluationContext.getTrees().getElement((TreePath)object8)) != null) {
                if (object7.asType().getKind() == TypeKind.ERROR) {
                    typeMirror = null;
                } else {
                    if (object7.getKind() != ElementKind.CONSTRUCTOR) {
                        throw new IllegalStateException("Element " + object7 + " is of " + (Object)((Object)object7.getKind()) + " kind. Tree = " + newClassTree);
                    }
                    object6 = (ExecutableElement)object7;
                    typeMirror = object6.asType();
                }
            } else {
                typeMirror = null;
            }
        } else {
            typeMirror = null;
        }
        object8 = newClassTree.getIdentifier();
        object7 = object8.accept(this, evaluationContext);
        object6 = (ClassType)object7;
        List<? extends ExpressionTree> list = newClassTree.getArguments();
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (ExpressionTree object52 : list) {
            object3 = object52.accept(this, evaluationContext);
            if (object3 != null && !(object3 instanceof Value)) {
                Assert.error(object52, "Not a value");
            }
            if (object3 instanceof ArtificialMirror) {
                object3 = ((ArtificialMirror)object3).getVMMirror();
            }
            arrayList.add((Value)object3);
        }
        Object object9 = null;
        Object var12_13 = null;
        object3 = null;
        if (typeMirror != null) {
            object9 = ((ExecutableType)typeMirror).getParameterTypes();
            try {
                incompatibleThreadStateException = evaluationContext.getFrame().thisObject();
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 35) {
                    incompatibleThreadStateException = null;
                }
                throw internalException;
            }
            if (incompatibleThreadStateException != null) {
                object22 = ((ReferenceType)incompatibleThreadStateException.type()).nestedTypes();
                object = object22.iterator();
                while (object.hasNext()) {
                    referenceType = (ReferenceType)object.next();
                    if (referenceType.isStatic() || !((Object)referenceType).equals(object6)) continue;
                    arrayList.add(0, incompatibleThreadStateException);
                    String string = incompatibleThreadStateException.type().signature();
                }
            }
        } else {
            object3 = new ArrayList(arrayList.size());
            for (Object object22 : arrayList) {
                if (object22 == null) {
                    object = evaluationContext.getDebugger().getVirtualMachine();
                    if (object == null) {
                        return null;
                    }
                    object3.add(object.classesByName("java.lang.Object").get(0));
                    continue;
                }
                object3.add(object22.type());
            }
            try {
                incompatibleThreadStateException = evaluationContext.getFrame().thisObject();
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 35) {
                    incompatibleThreadStateException = null;
                }
                throw internalException;
            }
            if (incompatibleThreadStateException != null) {
                object22 = ((ReferenceType)incompatibleThreadStateException.type()).nestedTypes();
                object = object22.iterator();
                while (object.hasNext()) {
                    referenceType = object.next();
                    if (referenceType.isStatic() || !((Object)referenceType).equals(object6)) continue;
                    arrayList.add(0, incompatibleThreadStateException);
                    object3.add(0, incompatibleThreadStateException.type());
                }
            }
        }
        try {
            void var12_14;
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("STARTED : " + object6 + "." + "<init>" + " (" + arrayList + ") in thread " + evaluationContext.getFrame().thread());
            }
            evaluationContext.methodToBeInvoked();
            incompatibleThreadStateException = EvaluatorVisitor.getConcreteMethodAndReportProblems(newClassTree, (ReferenceType)object6, "<init>", (String)var12_14, (List<? extends TypeMirror>)object9, (List<? extends Type>)object3);
            object = object22 = object6.newInstance(evaluationContext.getFrame().thread(), (Method)incompatibleThreadStateException, arrayList, 1);
            return object;
        }
        catch (InvalidTypeException invocationException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)invocationException));
        }
        catch (ClassNotLoadedException unsupportedOperationException) {
            throw new IllegalStateException(unsupportedOperationException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException2) {
            object22 = new InvalidExpressionException((Throwable)incompatibleThreadStateException2);
            object22.initCause((Throwable)incompatibleThreadStateException2);
            throw new IllegalStateException((Throwable)object22);
        }
        catch (InvocationException invocationException) {
            object22 = new InvocationExceptionTranslated(invocationException, evaluationContext.getDebugger());
            object = new InvalidExpressionException(object22);
            object.initCause(object22);
            throw new IllegalStateException((Throwable)object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object22 = new InvalidExpressionException((Throwable)unsupportedOperationException);
            object22.initCause((Throwable)unsupportedOperationException);
            throw new IllegalStateException((Throwable)object22);
        }
        finally {
            try {
                evaluationContext.methodInvokeDone();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException3) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException3);
                invalidExpressionException.initCause((Throwable)incompatibleThreadStateException3);
                throw new IllegalStateException(invalidExpressionException);
            }
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + object6 + "." + "<init>" + " (" + arrayList + ") in thread " + evaluationContext.getFrame().thread());
            }
        }
    }

    @Override
    public Mirror visitParenthesized(ParenthesizedTree parenthesizedTree, EvaluationContext evaluationContext) {
        return parenthesizedTree.getExpression().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitReturn(ReturnTree returnTree, EvaluationContext evaluationContext) {
        Mirror mirror;
        ExpressionTree expressionTree = returnTree.getExpression();
        if (expressionTree == null) {
            VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
            if (virtualMachine == null) {
                return null;
            }
            mirror = null;
        } else {
            mirror = expressionTree.accept(this, evaluationContext);
        }
        return new Return(mirror);
    }

    private Value getEnumConstant(Tree tree, VariableElement variableElement, EvaluationContext evaluationContext) {
        String string = variableElement.getSimpleName().toString();
        ReferenceType referenceType = EvaluatorVisitor.getClassType(tree, variableElement.asType(), evaluationContext);
        Method method = referenceType.methodsByName("valueOf").get(0);
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        StringReference stringReference = EvaluatorVisitor.createStringMirrorWithDisabledCollection(string, virtualMachine, evaluationContext);
        Value value = this.invokeMethod(tree, method, true, (ClassType)referenceType, null, Collections.singletonList(stringReference), evaluationContext, false);
        return value;
    }

    @Override
    public Mirror visitMemberSelect(MemberSelectTree memberSelectTree, EvaluationContext evaluationContext) {
        Object object;
        TreePath treePath = this.getCurrentPath();
        Element element = null;
        if (treePath != null) {
            object = TreePath.getPath(treePath, (Tree)memberSelectTree);
            if (object == null) {
                object = treePath;
            }
            if ((element = evaluationContext.getTrees().getElement((TreePath)object)) instanceof TypeElement && ((TypeElement)element).asType() instanceof ErrorType) {
                treePath = null;
            }
        }
        if (treePath == null || element == null) {
            Mirror mirror;
            Mirror mirror2;
            object = memberSelectTree.getIdentifier().toString();
            if (((String)object).equals("class")) {
                String string = memberSelectTree.getExpression().toString();
                VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
                if (virtualMachine == null) {
                    return null;
                }
                ReferenceType referenceType = EvaluatorVisitor.getOrLoadClass(virtualMachine, string, evaluationContext);
                if (referenceType == null) {
                    Assert.error((Tree)memberSelectTree, "unknownType", string);
                }
                return referenceType.classObject();
            }
            Mirror mirror3 = memberSelectTree.getExpression().accept(this, evaluationContext);
            if (mirror3 instanceof ClassType) {
                Mirror mirror4;
                mirror2 = (ClassType)mirror3;
                if (((String)object).equals("this")) {
                    mirror = evaluationContext.getContextObject();
                    while (mirror != null && !((Object)((ReferenceType)mirror.type())).equals(mirror2)) {
                        mirror4 = (ReferenceType)mirror.type();
                        Field field = mirror4.fieldByName("this$0");
                        if (field != null) {
                            mirror = (ObjectReference)mirror.getValue(field);
                            continue;
                        }
                        mirror = null;
                    }
                    if (mirror == null) {
                        Assert.error((Tree)memberSelectTree, "unknownOuterClass", mirror2.name());
                    } else {
                        return mirror;
                    }
                }
                if (((String)object).equals("class")) {
                    return mirror2.classObject();
                }
                mirror = mirror2.fieldByName((String)object);
                if (mirror != null) {
                    evaluationContext.putField(memberSelectTree, (Field)mirror, null);
                    mirror4 = mirror2.getValue((Field)mirror);
                    if (mirror4 instanceof ObjectReference) {
                        evaluationContext.disableCollectionOf((ObjectReference)mirror4);
                    }
                    return mirror4;
                }
            } else if (mirror3 instanceof InterfaceType) {
                if (((String)object).equals("class")) {
                    return ((InterfaceType)mirror3).classObject();
                }
            } else if (mirror3 instanceof ArrayType) {
                if (((String)object).equals("class")) {
                    return ((ArrayType)mirror3).classObject();
                }
            } else if (mirror3 instanceof ObjectReference) {
                if (mirror3 instanceof ArrayReference && "length".equals(object)) {
                    return mirror3.virtualMachine().mirrorOf(((ArrayReference)mirror3).length());
                }
                mirror2 = (ReferenceType)this.getSubExpressionType(memberSelectTree.getExpression());
                if (mirror2 == null) {
                    mirror2 = ((ObjectReference)mirror3).referenceType();
                }
                if ((mirror = mirror2.fieldByName((String)object)) != null) {
                    evaluationContext.putField(memberSelectTree, (Field)mirror, (ObjectReference)mirror3);
                    Value value = ((ObjectReference)mirror3).getValue((Field)mirror);
                    if (value instanceof ObjectReference) {
                        evaluationContext.disableCollectionOf((ObjectReference)value);
                    }
                    return value;
                }
            }
            if (mirror3 == null) {
                Assert.error((Tree)memberSelectTree, "fieldOnNull", object);
            }
            if ((mirror2 = evaluationContext.getDebugger().getVirtualMachine()) == null) {
                return null;
            }
            mirror = EvaluatorVisitor.getOrLoadClass((VirtualMachine)mirror2, (String)object, evaluationContext);
            if (mirror == null) {
                Assert.error((Tree)memberSelectTree, "unknownType", object);
            }
            return mirror;
        }
        switch (element.getKind()) {
            case ENUM_CONSTANT: {
                return this.getEnumConstant(memberSelectTree, (VariableElement)element, evaluationContext);
            }
            case FIELD: {
                Object object2;
                object = (VariableElement)element;
                String string = object.getSimpleName().toString();
                Mirror mirror = memberSelectTree.getExpression().accept(this, evaluationContext);
                if (mirror instanceof ClassType) {
                    Mirror mirror5;
                    Mirror mirror6;
                    ClassType classType = (ClassType)mirror;
                    if (string.equals("this")) {
                        mirror6 = evaluationContext.getContextObject();
                        while (mirror6 != null && !((Object)((ReferenceType)mirror6.type())).equals(classType)) {
                            mirror5 = (ReferenceType)mirror6.type();
                            Field field = mirror5.fieldByName("this$0");
                            if (field != null) {
                                mirror6 = (ObjectReference)mirror6.getValue(field);
                                continue;
                            }
                            mirror6 = null;
                        }
                        if (mirror6 == null) {
                            Assert.error((Tree)memberSelectTree, "unknownOuterClass", classType.name());
                        } else {
                            return mirror6;
                        }
                    }
                    if (string.equals("class")) {
                        return classType.classObject();
                    }
                    mirror6 = classType.fieldByName(string);
                    if (mirror6 != null) {
                        if (!mirror6.isStatic()) {
                            Assert.error((Tree)memberSelectTree, "accessInstanceVariableFromStaticContext", string);
                            return null;
                        }
                        evaluationContext.putField(memberSelectTree, (Field)mirror6, null);
                        mirror5 = classType.getValue((Field)mirror6);
                        if (mirror5 instanceof ObjectReference) {
                            evaluationContext.disableCollectionOf((ObjectReference)mirror5);
                        }
                        return mirror5;
                    }
                    Assert.error((Tree)memberSelectTree, "unknownField", string);
                    return null;
                }
                if (mirror instanceof InterfaceType) {
                    InterfaceType interfaceType = (InterfaceType)mirror;
                    if (string.equals("class")) {
                        return interfaceType.classObject();
                    }
                    Field field = interfaceType.fieldByName(string);
                    if (field != null) {
                        Value value = interfaceType.getValue(field);
                        if (value instanceof ObjectReference) {
                            evaluationContext.disableCollectionOf((ObjectReference)value);
                        }
                        return value;
                    }
                    Assert.error((Tree)memberSelectTree, "unknownField", string);
                    return null;
                }
                if (mirror instanceof ArrayType) {
                    object2 = (ArrayType)mirror;
                    if (string.equals("class")) {
                        return object2.classObject();
                    }
                }
                if (mirror instanceof ObjectReference) {
                    Field field;
                    if (mirror instanceof ArrayReference && "length".equals(string)) {
                        return mirror.virtualMachine().mirrorOf(((ArrayReference)mirror).length());
                    }
                    object2 = (ReferenceType)this.getSubExpressionType(memberSelectTree.getExpression());
                    if (object2 == null) {
                        object2 = ((ObjectReference)mirror).referenceType();
                    }
                    if ((field = object2.fieldByName(string)) != null) {
                        evaluationContext.putField(memberSelectTree, field, (ObjectReference)mirror);
                        Value value = ((ObjectReference)mirror).getValue(field);
                        if (value instanceof ObjectReference) {
                            evaluationContext.disableCollectionOf((ObjectReference)value);
                        }
                        return value;
                    }
                    Assert.error((Tree)memberSelectTree, "unknownField", string);
                    return null;
                }
                if (mirror == null) {
                    Assert.error((Tree)memberSelectTree, "fieldOnNull", string);
                }
                Assert.error((Tree)memberSelectTree, "invalidMemberReference", memberSelectTree.toString());
            }
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                Object object2 = (TypeElement)element;
                String string = ElementUtilities.getBinaryName((TypeElement)object2);
                VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
                if (virtualMachine == null) {
                    return null;
                }
                ReferenceType referenceType = EvaluatorVisitor.getOrLoadClass(virtualMachine, string, evaluationContext);
                if (referenceType == null) {
                    Assert.error((Tree)memberSelectTree, "unknownType", string);
                }
                return referenceType;
            }
            case PACKAGE: {
                return (Value)Assert.error(memberSelectTree, "notExpression");
            }
        }
        throw new UnsupportedOperationException("Not supported yet. Tree = '" + memberSelectTree + "', element kind = " + (Object)((Object)element.getKind()));
    }

    @Override
    public Mirror visitEmptyStatement(EmptyStatementTree emptyStatementTree, EvaluationContext evaluationContext) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitSwitch(SwitchTree switchTree, EvaluationContext evaluationContext) {
        Object object;
        Mirror mirror = switchTree.getExpression().accept(this, evaluationContext);
        CaseTree caseTree = null;
        Object object2 = null;
        boolean bl = false;
        block7: for (CaseTree tree : switchTree.getCases()) {
            Object object3;
            object = tree.getExpression();
            if (object == null) {
                caseTree = tree;
                continue;
            }
            if (!bl && this.isEqual(mirror, (Mirror)(object3 = object.accept(this, evaluationContext)), evaluationContext)) {
                bl = true;
            }
            if (!bl) continue;
            try {
                evaluationContext.pushBlock();
                object3 = tree.getStatements().iterator();
                while (object3.hasNext()) {
                    StatementTree statementTree = (StatementTree)object3.next();
                    Mirror mirror2 = statementTree.accept(this, evaluationContext);
                    if (mirror2 != null && (object2 = mirror2) instanceof CommandMirror) break block7;
                }
            }
            finally {
                evaluationContext.popBlock();
            }
        }
        if (!bl && caseTree != null) {
            try {
                evaluationContext.pushBlock();
                for (StatementTree statementTree : caseTree.getStatements()) {
                    object = statementTree.accept(this, evaluationContext);
                    if (object == null) continue;
                    object2 = object;
                }
            }
            finally {
                evaluationContext.popBlock();
            }
        }
        return object2;
    }

    @Override
    public Mirror visitSynchronized(SynchronizedTree synchronizedTree, EvaluationContext evaluationContext) {
        Assert.error(synchronizedTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitThrow(ThrowTree throwTree, EvaluationContext evaluationContext) {
        Assert.error(throwTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitCompilationUnit(CompilationUnitTree compilationUnitTree, EvaluationContext evaluationContext) {
        Assert.error(compilationUnitTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitTry(TryTree tryTree, EvaluationContext evaluationContext) {
        Assert.error(tryTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, EvaluationContext evaluationContext) {
        return parameterizedTypeTree.getType().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitArrayType(ArrayTypeTree arrayTypeTree, EvaluationContext evaluationContext) {
        Type type = (Type)arrayTypeTree.getType().accept(this, evaluationContext);
        if (type == null) {
            return null;
        }
        String string = type.name() + "[]";
        ReferenceType referenceType = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), string, evaluationContext);
        if (referenceType != null) {
            return referenceType;
        }
        Assert.error((Tree)arrayTypeTree, "unknownType", string);
        return null;
    }

    @Override
    public Mirror visitTypeCast(TypeCastTree typeCastTree, EvaluationContext evaluationContext) {
        Mirror mirror;
        VirtualMachine virtualMachine;
        Object object;
        ExpressionTree expressionTree = typeCastTree.getExpression();
        Mirror mirror2 = expressionTree.accept(this, evaluationContext);
        if (mirror2 == null) {
            return null;
        }
        Tree tree = typeCastTree.getType();
        if (this.getCurrentPath() == null) {
            object = tree.toString();
            virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
            if (virtualMachine == null) {
                return null;
            }
            ReferenceType referenceType = EvaluatorVisitor.getOrLoadClass(virtualMachine, (String)object, evaluationContext);
            if (referenceType == null) {
                Assert.error((Tree)typeCastTree, "unknownType", object);
            }
            mirror = referenceType;
        } else {
            mirror = tree.accept(this, evaluationContext);
        }
        if (mirror2 instanceof PrimitiveValue) {
            object = (PrimitiveValue)mirror2;
            if (object instanceof BooleanValue) {
                Assert.assertAssignable(mirror, BooleanType.class, typeCastTree, "castToBooleanRequired", object, mirror);
                return object;
            }
            Assert.assertNotAssignable(mirror, BooleanType.class, typeCastTree, "castFromBooleanRequired", object, mirror);
            virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
            if (virtualMachine == null) {
                return null;
            }
            if (mirror instanceof ByteType) {
                return this.mirrorOf(virtualMachine, object.byteValue());
            }
            if (mirror instanceof CharType) {
                return this.mirrorOf(virtualMachine, Character.valueOf(object.charValue()));
            }
            if (mirror instanceof DoubleType) {
                return this.mirrorOf(virtualMachine, object.doubleValue());
            }
            if (mirror instanceof FloatType) {
                return this.mirrorOf(virtualMachine, Float.valueOf(object.floatValue()));
            }
            if (mirror instanceof IntegerType) {
                return this.mirrorOf(virtualMachine, object.intValue());
            }
            if (mirror instanceof LongType) {
                return this.mirrorOf(virtualMachine, object.longValue());
            }
            return this.mirrorOf(virtualMachine, object.shortValue());
        }
        if (!EvaluatorVisitor.instanceOf(((ObjectReference)mirror2).type(), (Type)mirror)) {
            Assert.error(typeCastTree, "castError", ((ObjectReference)mirror2).type(), mirror);
        }
        this.subExpressionTypes.put(typeCastTree, (Type)mirror);
        return mirror2;
    }

    @Override
    public Mirror visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, EvaluationContext evaluationContext) {
        TypeKind typeKind = primitiveTypeTree.getPrimitiveTypeKind();
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        switch (typeKind) {
            case BOOLEAN: {
                return virtualMachine.mirrorOf(true).type();
            }
            case BYTE: {
                return virtualMachine.mirrorOf((byte)0).type();
            }
            case CHAR: {
                return virtualMachine.mirrorOf('a').type();
            }
            case DOUBLE: {
                return virtualMachine.mirrorOf(0.0).type();
            }
            case FLOAT: {
                return virtualMachine.mirrorOf(0.0f).type();
            }
            case INT: {
                return virtualMachine.mirrorOf(0).type();
            }
            case LONG: {
                return virtualMachine.mirrorOf(0L).type();
            }
            case SHORT: {
                return virtualMachine.mirrorOf((short)0).type();
            }
        }
        throw new IllegalStateException("Tree = " + primitiveTypeTree);
    }

    @Override
    public Mirror visitTypeParameter(TypeParameterTree typeParameterTree, EvaluationContext evaluationContext) {
        Assert.error(typeParameterTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitInstanceOf(InstanceOfTree instanceOfTree, EvaluationContext evaluationContext) {
        Mirror mirror = instanceOfTree.getExpression().accept(this, evaluationContext);
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        if (mirror == null) {
            return this.mirrorOf(virtualMachine, false);
        }
        Assert.assertAssignable(mirror, ObjectReference.class, instanceOfTree, "instanceOfLeftOperandNotAReference", mirror);
        ReferenceType referenceType = ((ObjectReference)mirror).referenceType();
        Type type = (Type)instanceOfTree.getType().accept(this, evaluationContext);
        return this.mirrorOf(virtualMachine, EvaluatorVisitor.instanceOf(referenceType, type));
    }

    @Override
    public Mirror visitUnary(UnaryTree unaryTree, EvaluationContext evaluationContext) {
        Mirror mirror = unaryTree.getExpression().accept(this, evaluationContext);
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        if (mirror == null) {
            return null;
        }
        if (mirror instanceof ObjectReference) {
            mirror = EvaluatorVisitor.unboxIfCan(unaryTree, (ObjectReference)mirror, evaluationContext);
        }
        Tree.Kind kind = unaryTree.getKind();
        if (mirror instanceof BooleanValue) {
            boolean bl = ((BooleanValue)mirror).value();
            switch (kind) {
                case LOGICAL_COMPLEMENT: {
                    bl = !bl;
                    break;
                }
                default: {
                    Assert.error(unaryTree, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(boolean) " + unaryTree.getExpression());
                }
            }
            return this.mirrorOf(virtualMachine, bl);
        }
        if (mirror instanceof ByteValue) {
            byte by = ((ByteValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    int n = ~by;
                    return this.mirrorOf(virtualMachine, n);
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, by - 1), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, by + 1), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    by = (byte)(by - 1);
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, by), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    by = (byte)(by + 1);
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, by), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    byte by2 = -by;
                    return this.mirrorOf(virtualMachine, by2);
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(unaryTree, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(byte) " + unaryTree.getExpression());
                }
            }
            return this.mirrorOf(virtualMachine, by);
        }
        if (mirror instanceof CharValue) {
            char c = ((CharValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    int n = ~c;
                    return this.mirrorOf(virtualMachine, n);
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, c - '\u0001'), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, c + '\u0001'), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    c = (char)(c - '\u0001');
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, Character.valueOf(c)), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    c = (char)(c + '\u0001');
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, Character.valueOf(c)), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    char c2 = -c;
                    return this.mirrorOf(virtualMachine, c2);
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(unaryTree, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(char) " + unaryTree.getExpression());
                }
            }
            return this.mirrorOf(virtualMachine, Character.valueOf(c));
        }
        if (mirror instanceof ShortValue) {
            short s = ((ShortValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    int n = ~s;
                    return this.mirrorOf(virtualMachine, n);
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, s - 1), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, s + 1), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    s = (short)(s - 1);
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, s), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    s = (short)(s + 1);
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, s), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    short s2 = -s;
                    return this.mirrorOf(virtualMachine, s2);
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(unaryTree, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(short) " + unaryTree.getExpression());
                }
            }
            return this.mirrorOf(virtualMachine, s);
        }
        if (mirror instanceof IntegerValue) {
            int n = ((IntegerValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    n ^= 0xFFFFFFFF;
                    break;
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, n - 1), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, n + 1), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, --n), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, ++n), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    n = -n;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(unaryTree, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(int) " + unaryTree.getExpression());
                }
            }
            return this.mirrorOf(virtualMachine, n);
        }
        if (mirror instanceof LongValue) {
            long l = ((LongValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    l ^= 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, l - 1L), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, l + 1L), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, --l), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, ++l), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    l = -l;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(unaryTree, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(long) " + unaryTree.getExpression());
                }
            }
            return this.mirrorOf(virtualMachine, l);
        }
        if (mirror instanceof DoubleValue) {
            double d = ((DoubleValue)mirror).value();
            switch (kind) {
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, d - 1.0), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, d + 1.0), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, d -= 1.0), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, d += 1.0), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    d = -d;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(unaryTree, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(double) " + unaryTree.getExpression());
                }
            }
            return this.mirrorOf(virtualMachine, d);
        }
        if (mirror instanceof FloatValue) {
            float f = ((FloatValue)mirror).value();
            switch (kind) {
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, Float.valueOf(f - 1.0f)), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, Float.valueOf(f + 1.0f)), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, Float.valueOf(f -= 1.0f)), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), this.mirrorOf(virtualMachine, Float.valueOf(f += 1.0f)), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    f = -f;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(unaryTree, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(float) " + unaryTree.getExpression());
                }
            }
            return this.mirrorOf(virtualMachine, Float.valueOf(f));
        }
        Assert.error(unaryTree, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), unaryTree.getExpression());
        throw new IllegalStateException("Bad expression type: " + mirror);
    }

    private static final String operatorToString(Tree.Kind kind) {
        switch (kind) {
            case AND: {
                return "&";
            }
            case AND_ASSIGNMENT: {
                return "&=";
            }
            case CONDITIONAL_AND: {
                return "&&";
            }
            case CONDITIONAL_OR: {
                return "||";
            }
            case LEFT_SHIFT: {
                return "<<";
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return "<<=";
            }
            case LOGICAL_COMPLEMENT: {
                return "!";
            }
            case MINUS: {
                return "-";
            }
            case MINUS_ASSIGNMENT: {
                return "-=";
            }
            case MULTIPLY: {
                return "*";
            }
            case MULTIPLY_ASSIGNMENT: {
                return "*=";
            }
            case OR: {
                return "|";
            }
            case OR_ASSIGNMENT: {
                return "|=";
            }
            case PLUS: {
                return "+";
            }
            case PLUS_ASSIGNMENT: {
                return "+=";
            }
            case PREFIX_DECREMENT: {
                return "--";
            }
            case PREFIX_INCREMENT: {
                return "++";
            }
            case REMAINDER: {
                return "%";
            }
            case REMAINDER_ASSIGNMENT: {
                return "%=";
            }
            case RIGHT_SHIFT: {
                return ">>";
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return ">>=";
            }
            case UNARY_MINUS: {
                return "-";
            }
            case UNARY_PLUS: {
                return "+";
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return ">>>";
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return ">>>=";
            }
            case XOR: {
                return "^";
            }
            case XOR_ASSIGNMENT: {
                return "^=";
            }
        }
        return kind.toString();
    }

    @Override
    public Mirror visitVariable(VariableTree variableTree, EvaluationContext evaluationContext) {
        String string = variableTree.getName().toString();
        if (evaluationContext.getScriptVariableByName(string) != null) {
            Assert.error((Tree)variableTree, "localVariableAlreadyDefined", string);
        }
        Tree tree = variableTree.getType();
        Type type = (Type)tree.accept(this, evaluationContext);
        EvaluationContext.ScriptVariable scriptVariable = evaluationContext.createScriptLocalVariable(string, type);
        ExpressionTree expressionTree = variableTree.getInitializer();
        if (expressionTree != null) {
            Mirror mirror = expressionTree.accept(this, evaluationContext);
            scriptVariable.setValue(mirror);
            return mirror;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitWhileLoop(WhileLoopTree whileLoopTree, EvaluationContext evaluationContext) {
        ExpressionTree expressionTree = whileLoopTree.getCondition();
        StatementTree statementTree = whileLoopTree.getStatement();
        Mirror mirror = null;
        while (((BooleanValue)expressionTree.accept(this, evaluationContext)).value()) {
            try {
                evaluationContext.pushBlock();
                Mirror mirror2 = statementTree.accept(this, evaluationContext);
                if (mirror2 instanceof Break) break;
                if (mirror2 instanceof Continue || mirror2 == null) continue;
                mirror = mirror2;
            }
            finally {
                evaluationContext.popBlock();
            }
        }
        return mirror;
    }

    @Override
    public Mirror visitWildcard(WildcardTree wildcardTree, EvaluationContext evaluationContext) {
        Assert.error(wildcardTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitOther(Tree tree, EvaluationContext evaluationContext) {
        Assert.error(tree, "unsupported");
        return null;
    }

    private Value setToMirror(Tree tree, Value value, EvaluationContext evaluationContext) {
        EvaluationContext.VariableInfo variableInfo = evaluationContext.getVariableInfo(tree);
        if (variableInfo == null) {
            Assert.error(tree, "unknownVariable", tree.toString());
            throw new IllegalStateException("Unknown variable " + tree);
        }
        if (value instanceof ArtificialMirror) {
            value = (Value)((ArtificialMirror)((Object)value)).getVMMirror();
        }
        try {
            ArrayList<Value> arrayList = new ArrayList<Value>(1);
            arrayList.add(value);
            this.autoboxElements(tree, variableInfo.getType(), arrayList, evaluationContext);
            value = (Value)arrayList.get(0);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
        variableInfo.setValue(value);
        return value;
    }

    private Value invokeMethod(Tree tree, Method method, Boolean bl, ClassType classType, ObjectReference objectReference, List<Value> list, EvaluationContext evaluationContext, boolean bl2) {
        if (!evaluationContext.canInvokeMethods()) {
            Assert.error(tree, "canNotInvokeMethods");
        }
        ThreadReference threadReference = null;
        try {
            Value value;
            Value value2;
            threadReference = evaluationContext.getFrame().thread();
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("STARTED : " + objectReference + "." + method + " (" + list + ") in thread " + threadReference);
            }
            evaluationContext.methodToBeInvoked();
            try {
                EvaluatorVisitor.autoboxArguments(method.argumentTypes(), list, threadReference, evaluationContext);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                // empty catch block
            }
            if (Boolean.TRUE.equals(bl)) {
                value2 = classType.invokeMethod(threadReference, method, list, 1);
            } else {
                value = objectReference;
                if (classType != null) {
                    if (method.isPrivate()) {
                        value = this.findEnclosingObject(tree, objectReference, classType, null, method.name());
                    } else if (!EvaluatorVisitor.instanceOf(objectReference.referenceType(), classType)) {
                        value = this.findEnclosingObject(tree, objectReference, classType, null, method.name());
                    }
                }
                if (value == null) {
                    Assert.error(tree, "noSuchMethod", method.name(), objectReference.referenceType().name());
                }
                value2 = value.invokeMethod(threadReference, method, list, 1 | (bl2 ? 2 : 0));
            }
            if (value2 instanceof ObjectReference) {
                // empty if block
            }
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("   return = " + value2);
            }
            value = value2;
            return value;
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)invalidTypeException));
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new IllegalStateException(classNotLoadedException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
            invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)invalidStackFrameException);
            invalidExpressionException.initCause((Throwable)invalidStackFrameException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (InvocationException invocationException) {
            InvocationExceptionTranslated invocationExceptionTranslated = new InvocationExceptionTranslated(invocationException, evaluationContext.getDebugger());
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)((Object)invocationExceptionTranslated));
            invalidExpressionException.initCause((Throwable)((Object)invocationExceptionTranslated));
            throw new IllegalStateException(invocationException.getLocalizedMessage(), invalidExpressionException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)unsupportedOperationException);
            invalidExpressionException.initCause((Throwable)unsupportedOperationException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (InternalException internalException) {
            InternalException internalException2;
            if (internalException.errorCode() == 502) {
                internalException2 = (InternalException)Exceptions.attachLocalizedMessage((Throwable)internalException, (String)NbBundle.getMessage(JPDADebuggerImpl.class, (String)"JDWPError502"));
            }
            throw internalException2;
        }
        finally {
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + objectReference + "." + method + " (" + list + ") in thread " + threadReference);
            }
            try {
                evaluationContext.methodInvokeDone();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                throw new IllegalStateException(invalidExpressionException);
            }
        }
    }

    private static void autoboxArguments(List<Type> list, List<Value> list2, ThreadReference threadReference, EvaluationContext evaluationContext) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        if (list.size() != list2.size()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Type type = list.get(i);
            Value value = list2.get(i);
            if (value instanceof ObjectReference && type instanceof PrimitiveType) {
                list2.set(i, EvaluatorVisitor.unbox((ObjectReference)value, (PrimitiveType)type, threadReference, evaluationContext));
            }
            if (!(value instanceof PrimitiveValue) || !(type instanceof ReferenceType)) continue;
            list2.set(i, EvaluatorVisitor.box((PrimitiveValue)value, (ReferenceType)type, threadReference, evaluationContext));
        }
    }

    private void autoboxElements(Tree tree, Type type, List<Value> list, EvaluationContext evaluationContext) {
        boolean bl = false;
        ThreadReference threadReference = null;
        try {
            Object object;
            int n;
            if (type instanceof PrimitiveType) {
                for (n = 0; n < list.size(); ++n) {
                    object = list.get(n);
                    if (!(object instanceof ObjectReference)) continue;
                    if (!bl) {
                        if (!evaluationContext.canInvokeMethods()) {
                            Assert.error(tree, "canNotInvokeMethods");
                        }
                        threadReference = evaluationContext.getFrame().thread();
                        if (loggerMethod.isLoggable(Level.FINE)) {
                            loggerMethod.fine("STARTED : Unbox " + object + " in thread " + threadReference);
                        }
                        evaluationContext.methodToBeInvoked();
                        bl = true;
                    }
                    list.set(n, EvaluatorVisitor.unbox((ObjectReference)object, (PrimitiveType)type, threadReference, evaluationContext));
                }
            } else if (type instanceof ReferenceType) {
                for (n = 0; n < list.size(); ++n) {
                    object = list.get(n);
                    if (!(object instanceof PrimitiveValue)) continue;
                    if (!bl) {
                        if (!evaluationContext.canInvokeMethods()) {
                            Assert.error(tree, "canNotInvokeMethods");
                        }
                        threadReference = evaluationContext.getFrame().thread();
                        if (loggerMethod.isLoggable(Level.FINE)) {
                            loggerMethod.fine("STARTED : Autobox " + object + " in thread " + threadReference);
                        }
                        evaluationContext.methodToBeInvoked();
                        bl = true;
                    }
                    list.set(n, EvaluatorVisitor.box((PrimitiveValue)object, (ReferenceType)type, threadReference, evaluationContext));
                }
            }
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)invalidTypeException));
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new IllegalStateException(classNotLoadedException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
            invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (InvocationException invocationException) {
            InvocationExceptionTranslated invocationExceptionTranslated = new InvocationExceptionTranslated(invocationException, evaluationContext.getDebugger());
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)((Object)invocationExceptionTranslated));
            invalidExpressionException.initCause((Throwable)((Object)invocationExceptionTranslated));
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)unsupportedOperationException);
            invalidExpressionException.initCause((Throwable)unsupportedOperationException);
            throw new IllegalStateException(invalidExpressionException);
        }
        finally {
            if (bl) {
                if (loggerMethod.isLoggable(Level.FINE)) {
                    loggerMethod.fine("FINISHED: Autobox/unbox in thread " + threadReference);
                }
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                    invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                    throw new IllegalStateException(invalidExpressionException);
                }
            }
        }
    }

    private static void unboxMethodToBeCalled(Tree tree, Mirror mirror, EvaluationContext evaluationContext) {
        if (!evaluationContext.canInvokeMethods()) {
            Assert.error(tree, "canNotInvokeMethods");
        }
        if (loggerMethod.isLoggable(Level.FINE)) {
            loggerMethod.fine("STARTED : Unbox " + mirror + " in thread " + evaluationContext.getFrame().thread());
        }
        evaluationContext.methodToBeInvoked();
    }

    private static Mirror unboxIfCan(Tree tree, ObjectReference objectReference, EvaluationContext evaluationContext) {
        String string = ((ReferenceType)objectReference.type()).name();
        boolean bl = false;
        try {
            if (string.equals(Boolean.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "booleanValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (string.equals(Byte.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "byteValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (string.equals(Character.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "charValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (string.equals(Short.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "shortValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (string.equals(Integer.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "intValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (string.equals(Long.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "longValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (string.equals(Float.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "floatValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (string.equals(Double.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "doubleValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            ObjectReference objectReference2 = objectReference;
            return objectReference2;
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)invalidTypeException));
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new IllegalStateException(classNotLoadedException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
            invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (InvocationException invocationException) {
            InvocationExceptionTranslated invocationExceptionTranslated = new InvocationExceptionTranslated(invocationException, evaluationContext.getDebugger());
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)((Object)invocationExceptionTranslated));
            invalidExpressionException.initCause((Throwable)((Object)invocationExceptionTranslated));
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)unsupportedOperationException);
            invalidExpressionException.initCause((Throwable)unsupportedOperationException);
            throw new IllegalStateException(invalidExpressionException);
        }
        finally {
            if (bl) {
                if (loggerMethod.isLoggable(Level.FINE)) {
                    loggerMethod.fine("FINISHED: unbox in thread " + evaluationContext.getFrame().thread());
                }
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                    invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                    throw new IllegalStateException(invalidExpressionException);
                }
            }
        }
    }

    public static Value unbox(ObjectReference objectReference, PrimitiveType primitiveType, ThreadReference threadReference, EvaluationContext evaluationContext) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        PrimitiveValue primitiveValue;
        ReferenceType referenceType = objectReference.referenceType();
        String string = referenceType.name();
        if (string.equals("java.lang.Boolean")) {
            primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "booleanValue", threadReference, evaluationContext);
        } else if (string.equals("java.lang.Byte")) {
            primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "byteValue", threadReference, evaluationContext);
        } else if (string.equals("java.lang.Character")) {
            primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "charValue", threadReference, evaluationContext);
        } else if (string.equals("java.lang.Short")) {
            primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "shortValue", threadReference, evaluationContext);
        } else if (string.equals("java.lang.Integer")) {
            primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "intValue", threadReference, evaluationContext);
        } else if (string.equals("java.lang.Long")) {
            primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "longValue", threadReference, evaluationContext);
        } else if (string.equals("java.lang.Float")) {
            primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "floatValue", threadReference, evaluationContext);
        } else if (string.equals("java.lang.Double")) {
            primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "doubleValue", threadReference, evaluationContext);
        } else {
            return objectReference;
        }
        VirtualMachine virtualMachine = primitiveValue.virtualMachine();
        if (primitiveType instanceof BooleanType && !(primitiveValue instanceof BooleanValue)) {
            return virtualMachine.mirrorOf(primitiveValue.booleanValue());
        }
        if (primitiveType instanceof ByteType && !(primitiveValue instanceof ByteValue)) {
            return virtualMachine.mirrorOf(primitiveValue.byteValue());
        }
        if (primitiveType instanceof CharType && !(primitiveValue instanceof CharValue)) {
            return virtualMachine.mirrorOf(primitiveValue.charValue());
        }
        if (primitiveType instanceof ShortType && !(primitiveValue instanceof ShortValue)) {
            return virtualMachine.mirrorOf(primitiveValue.shortValue());
        }
        if (primitiveType instanceof IntegerType && !(primitiveValue instanceof IntegerValue)) {
            return virtualMachine.mirrorOf(primitiveValue.intValue());
        }
        if (primitiveType instanceof LongType && !(primitiveValue instanceof LongValue)) {
            return virtualMachine.mirrorOf(primitiveValue.longValue());
        }
        if (primitiveType instanceof FloatType && !(primitiveValue instanceof FloatValue)) {
            return virtualMachine.mirrorOf(primitiveValue.floatValue());
        }
        if (primitiveType instanceof DoubleType && !(primitiveValue instanceof DoubleValue)) {
            return virtualMachine.mirrorOf(primitiveValue.doubleValue());
        }
        return primitiveValue;
    }

    private static ReferenceType adjustBoxingType(ReferenceType referenceType, PrimitiveType primitiveType, EvaluationContext evaluationContext) {
        if (primitiveType instanceof BooleanType) {
            referenceType = EvaluatorVisitor.getOrLoadClass(referenceType.virtualMachine(), Boolean.class.getName(), evaluationContext);
        } else if (primitiveType instanceof ByteType) {
            referenceType = EvaluatorVisitor.getOrLoadClass(referenceType.virtualMachine(), Byte.class.getName(), evaluationContext);
        } else if (primitiveType instanceof CharType) {
            referenceType = EvaluatorVisitor.getOrLoadClass(referenceType.virtualMachine(), Character.class.getName(), evaluationContext);
        } else if (primitiveType instanceof ShortType) {
            referenceType = EvaluatorVisitor.getOrLoadClass(referenceType.virtualMachine(), Short.class.getName(), evaluationContext);
        } else if (primitiveType instanceof IntegerType) {
            referenceType = EvaluatorVisitor.getOrLoadClass(referenceType.virtualMachine(), Integer.class.getName(), evaluationContext);
        } else if (primitiveType instanceof LongType) {
            referenceType = EvaluatorVisitor.getOrLoadClass(referenceType.virtualMachine(), Long.class.getName(), evaluationContext);
        } else if (primitiveType instanceof FloatType) {
            referenceType = EvaluatorVisitor.getOrLoadClass(referenceType.virtualMachine(), Float.class.getName(), evaluationContext);
        } else if (primitiveType instanceof DoubleType) {
            referenceType = EvaluatorVisitor.getOrLoadClass(referenceType.virtualMachine(), Double.class.getName(), evaluationContext);
        }
        return referenceType;
    }

    public static Value box(PrimitiveValue primitiveValue, ReferenceType referenceType, ThreadReference threadReference, EvaluationContext evaluationContext) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        try {
            Object object;
            Object object2;
            Method method = null;
            String string = referenceType.name();
            if (!PRIMITIVE_CLASS_NAMES.contains(string)) {
                referenceType = EvaluatorVisitor.adjustBoxingType(referenceType, (PrimitiveType)primitiveValue.type(), evaluationContext);
            } else {
                object2 = primitiveValue.virtualMachine();
                if (string.equals("java.lang.Boolean") && !(primitiveValue instanceof BooleanValue)) {
                    primitiveValue = object2.mirrorOf(primitiveValue.booleanValue());
                } else if (string.equals("java.lang.Byte") && !(primitiveValue instanceof ByteValue)) {
                    primitiveValue = object2.mirrorOf(primitiveValue.byteValue());
                } else if (string.equals("java.lang.Character") && !(primitiveValue instanceof CharValue)) {
                    primitiveValue = object2.mirrorOf(primitiveValue.charValue());
                } else if (string.equals("java.lang.Short") && !(primitiveValue instanceof ShortValue)) {
                    primitiveValue = object2.mirrorOf(primitiveValue.shortValue());
                } else if (string.equals("java.lang.Integer") && !(primitiveValue instanceof IntegerValue)) {
                    primitiveValue = object2.mirrorOf(primitiveValue.intValue());
                } else if (string.equals("java.lang.Long") && !(primitiveValue instanceof LongValue)) {
                    primitiveValue = object2.mirrorOf(primitiveValue.longValue());
                } else if (string.equals("java.lang.Float") && !(primitiveValue instanceof FloatValue)) {
                    primitiveValue = object2.mirrorOf(primitiveValue.floatValue());
                } else if (string.equals("java.lang.Double") && !(primitiveValue instanceof DoubleValue)) {
                    primitiveValue = object2.mirrorOf(primitiveValue.doubleValue());
                }
            }
            object2 = referenceType.methodsByName("<init>");
            String string2 = "(" + primitiveValue.type().signature() + ")";
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (Method)object3.next();
                if (object.isAbstract() || !EvaluatorVisitor.equalMethodSignatures(object.signature(), string2)) continue;
                method = object;
            }
            if (method == null) {
                throw new RuntimeException("No constructor " + referenceType + " " + string2);
            }
            if (evaluationContext != null) {
                evaluationContext.methodToBeInvoked();
            }
            object = object3 = ((ClassType)referenceType).newInstance(threadReference, method, Arrays.asList(primitiveValue), 1);
            return object;
        }
        catch (InvalidTypeException invalidTypeException) {
            throw invalidTypeException;
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw classNotLoadedException;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw incompatibleThreadStateException;
        }
        catch (InvocationException invocationException) {
            throw invocationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception while invoking boxing method", exception);
        }
        finally {
            if (evaluationContext != null) {
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                    invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                    throw new IllegalStateException(invalidExpressionException);
                }
            }
        }
    }

    private static PrimitiveValue invokeUnboxingMethod(ObjectReference objectReference, String string, ThreadReference threadReference, EvaluationContext evaluationContext) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        Method method = objectReference.referenceType().methodsByName(string).get(0);
        if (evaluationContext != null) {
            evaluationContext.methodToBeInvoked();
        }
        try {
            PrimitiveValue primitiveValue = (PrimitiveValue)objectReference.invokeMethod(threadReference, method, new ArrayList(0), 1);
            return primitiveValue;
        }
        catch (InvalidTypeException invalidTypeException) {
            throw invalidTypeException;
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw classNotLoadedException;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw incompatibleThreadStateException;
        }
        catch (InvocationException invocationException) {
            throw invocationException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception while invoking unboxing method", exception);
        }
        finally {
            if (evaluationContext != null) {
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                    invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                    throw new IllegalStateException(invalidExpressionException);
                }
            }
        }
    }

    private boolean isEqual(Mirror mirror, Mirror mirror2, EvaluationContext evaluationContext) {
        boolean bl;
        if (mirror instanceof ObjectReference) {
            return mirror.equals(mirror2);
        }
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        if (mirror instanceof BooleanValue && mirror2 instanceof BooleanValue) {
            boolean bl2;
            boolean bl3 = ((BooleanValue)mirror).booleanValue();
            return bl3 == (bl2 = ((BooleanValue)mirror2).booleanValue());
        }
        boolean bl4 = mirror instanceof PrimitiveValue && !(mirror instanceof BooleanValue);
        boolean bl5 = bl = mirror2 instanceof PrimitiveValue && !(mirror2 instanceof BooleanValue);
        if (bl4 && bl) {
            long l;
            if (mirror instanceof DoubleValue || mirror2 instanceof DoubleValue) {
                double d;
                double d2 = ((PrimitiveValue)mirror).doubleValue();
                return d2 == (d = ((PrimitiveValue)mirror2).doubleValue());
            }
            if (mirror instanceof FloatValue || mirror2 instanceof FloatValue) {
                float f;
                float f2 = ((PrimitiveValue)mirror).floatValue();
                return f2 == (f = ((PrimitiveValue)mirror2).floatValue());
            }
            long l2 = ((PrimitiveValue)mirror).longValue();
            return l2 == (l = ((PrimitiveValue)mirror2).longValue());
        }
        return false;
    }

    private String toString(Tree tree, Mirror mirror, EvaluationContext evaluationContext) {
        Method method;
        if (mirror instanceof PrimitiveValue) {
            PrimitiveValue primitiveValue = (PrimitiveValue)mirror;
            PrimitiveType primitiveType = (PrimitiveType)primitiveValue.type();
            if (primitiveType instanceof ByteType) {
                return Byte.toString(primitiveValue.byteValue());
            }
            if (primitiveType instanceof BooleanType) {
                return Boolean.toString(primitiveValue.booleanValue());
            }
            if (primitiveType instanceof CharType) {
                return Character.toString(primitiveValue.charValue());
            }
            if (primitiveType instanceof ShortType) {
                return Short.toString(primitiveValue.shortValue());
            }
            if (primitiveType instanceof IntegerType) {
                return Integer.toString(primitiveValue.intValue());
            }
            if (primitiveType instanceof LongType) {
                return Long.toString(primitiveValue.longValue());
            }
            if (primitiveType instanceof FloatType) {
                return Float.toString(primitiveValue.floatValue());
            }
            if (primitiveType instanceof DoubleType) {
                return Double.toString(primitiveValue.doubleValue());
            }
            throw new IllegalStateException("Unknown primitive type: " + primitiveType);
        }
        if (mirror == null) {
            return "" + null;
        }
        ObjectReference objectReference = (ObjectReference)mirror;
        if (objectReference instanceof ArrayReference) {
            return "#" + objectReference.uniqueID() + " " + objectReference.type().name() + "(length=" + ((ArrayReference)objectReference).length() + ")";
        }
        if (objectReference instanceof StringReference) {
            return ((StringReference)objectReference).value();
        }
        List list = Collections.emptyList();
        try {
            method = EvaluatorVisitor.getConcreteMethod((ReferenceType)objectReference.type(), "toString", list);
        }
        catch (UnsuitableArgumentsException unsuitableArgumentsException) {
            throw new IllegalStateException(unsuitableArgumentsException);
        }
        ((ClassType)objectReference.type()).methodsByName("toString");
        List<Value> list2 = Collections.emptyList();
        Value value = this.invokeMethod(tree, method, false, null, objectReference, list2, evaluationContext, false);
        if (value instanceof StringReference) {
            return ((StringReference)value).value();
        }
        if (value == null) {
            return null;
        }
        return "Result of toString() call on " + objectReference + " is not a String, but: " + value;
    }

    private Value mirrorOf(VirtualMachine virtualMachine, Object object) {
        if (object instanceof Boolean) {
            return new BooleanVal(virtualMachine, (Boolean)object);
        }
        if (object instanceof Character) {
            return new CharVal(virtualMachine, ((Character)object).charValue());
        }
        if (object instanceof Byte) {
            return new ByteVal(virtualMachine, (Byte)object);
        }
        if (object instanceof Integer) {
            return new IntVal(virtualMachine, (Integer)object);
        }
        if (object instanceof Short) {
            return new ShortVal(virtualMachine, (Short)object);
        }
        if (object instanceof Long) {
            return new LongVal(virtualMachine, (Long)object);
        }
        if (object instanceof Float) {
            return new FloatVal(virtualMachine, ((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return new DoubleVal(virtualMachine, (Double)object);
        }
        return null;
    }

    private static ReferenceType getOrLoadClass(VirtualMachine virtualMachine, String string, EvaluationContext evaluationContext) {
        List<ReferenceType> list = virtualMachine.classesByName(string);
        if (list.size() > 0) {
            if (list.size() == 1) {
                return list.get(0);
            }
            ClassLoaderReference classLoaderReference = evaluationContext.getFrame().location().declaringType().classLoader();
            for (ReferenceType referenceType : list) {
                if (!classLoaderReference.equals(referenceType.classLoader())) continue;
                return referenceType;
            }
            try {
                ReferenceType referenceType = JPDAUtils.getPreferredReferenceType(list, null);
                if (referenceType != null) {
                    return referenceType;
                }
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                throw vMDisconnectedExceptionWrapper.getCause();
            }
            return list.get(0);
        }
        return null;
    }

    private static StringReference createStringMirrorWithDisabledCollection(String string, VirtualMachine virtualMachine, EvaluationContext evaluationContext) {
        StringReference stringReference;
        do {
            try {
                stringReference = virtualMachine.mirrorOf(string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Assert.error(null, "unsupportedStringCreation");
                return null;
            }
            try {
                evaluationContext.disableCollectionOf(stringReference);
            }
            catch (ObjectCollectedException objectCollectedException) {
                stringReference = null;
            }
        } while (stringReference == null);
        return stringReference;
    }

    private static ArrayReference createArrayMirrorWithDisabledCollection(ArrayType arrayType, int n, EvaluationContext evaluationContext) {
        ArrayReference arrayReference;
        do {
            arrayReference = arrayType.newInstance(n);
            try {
                evaluationContext.disableCollectionOf(arrayReference);
            }
            catch (ObjectCollectedException objectCollectedException) {
                arrayReference = null;
            }
        } while (arrayReference == null);
        return arrayReference;
    }

    private void reportCannotApplyOperator(BinaryTree binaryTree) {
        Assert.error((Tree)binaryTree, "cannotApplyOperator", binaryTree.toString());
    }

    private static class DoubleVal
    extends ArtificialMirror
    implements DoubleValue {
        private double value;
        private VirtualMachine vm;

        DoubleVal(VirtualMachine virtualMachine, double d) {
            this.vm = virtualMachine;
            this.value = d;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public double value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0.0;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public float floatValue() {
            return (float)this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(0.0).type();
        }

        @Override
        public int compareTo(DoubleValue doubleValue) {
            return (int)(this.value - doubleValue.value());
        }
    }

    private static class FloatVal
    extends ArtificialMirror
    implements FloatValue {
        private float value;
        private VirtualMachine vm;

        FloatVal(VirtualMachine virtualMachine, float f) {
            this.vm = virtualMachine;
            this.value = f;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public float value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0.0f;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(0.0f).type();
        }

        @Override
        public int compareTo(FloatValue floatValue) {
            return (int)(this.value - floatValue.value());
        }
    }

    private static class CharVal
    extends ArtificialMirror
    implements CharValue {
        private char value;
        private VirtualMachine vm;

        CharVal(VirtualMachine virtualMachine, char c) {
            this.vm = virtualMachine;
            this.value = c;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != '\u0000';
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(' ').type();
        }

        @Override
        public int compareTo(CharValue charValue) {
            return this.value - charValue.value();
        }
    }

    private static class LongVal
    extends ArtificialMirror
    implements LongValue {
        private long value;
        private VirtualMachine vm;

        LongVal(VirtualMachine virtualMachine, long l) {
            this.vm = virtualMachine;
            this.value = l;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0L;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(0L).type();
        }

        @Override
        public int compareTo(LongValue longValue) {
            return (int)(this.value - longValue.value());
        }
    }

    private static class IntVal
    extends ArtificialMirror
    implements IntegerValue {
        private int value;
        private VirtualMachine vm;

        IntVal(VirtualMachine virtualMachine, int n) {
            this.vm = virtualMachine;
            this.value = n;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(0).type();
        }

        @Override
        public int compareTo(IntegerValue integerValue) {
            return this.value - integerValue.value();
        }
    }

    private static class ShortVal
    extends ArtificialMirror
    implements ShortValue {
        private short value;
        private VirtualMachine vm;

        ShortVal(VirtualMachine virtualMachine, short s) {
            this.vm = virtualMachine;
            this.value = s;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public short value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf((short)0).type();
        }

        @Override
        public int compareTo(ShortValue shortValue) {
            return this.value - shortValue.value();
        }
    }

    private static class ByteVal
    extends ArtificialMirror
    implements ByteValue {
        private byte value;
        private VirtualMachine vm;

        ByteVal(VirtualMachine virtualMachine, byte by) {
            this.vm = virtualMachine;
            this.value = by;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public byte value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0;
        }

        @Override
        public byte byteValue() {
            return this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf((byte)0).type();
        }

        @Override
        public int compareTo(ByteValue byteValue) {
            return this.value - byteValue.value();
        }
    }

    private static class BooleanVal
    extends ArtificialMirror
    implements BooleanValue {
        private boolean value;
        private VirtualMachine vm;

        BooleanVal(VirtualMachine virtualMachine, boolean bl) {
            this.vm = virtualMachine;
            this.value = bl;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public boolean value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value;
        }

        @Override
        public byte byteValue() {
            return (byte)(this.value ? 1 : 0);
        }

        @Override
        public char charValue() {
            return (char)this.byteValue();
        }

        @Override
        public short shortValue() {
            return (short)(this.value ? 1 : 0);
        }

        @Override
        public int intValue() {
            return this.value ? 1 : 0;
        }

        @Override
        public long longValue() {
            return this.value ? 1L : 0L;
        }

        @Override
        public float floatValue() {
            return this.value ? 1.0f : 0.0f;
        }

        @Override
        public double doubleValue() {
            return this.value ? 1.0 : 0.0;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(true).type();
        }
    }

    private static final class Return
    extends CommandMirror {
        private Mirror value;

        Return(Mirror mirror) {
            this.value = mirror;
        }

        @Override
        public Mirror getVMMirror() {
            return this.value instanceof ArtificialMirror ? ((ArtificialMirror)this.value).getVMMirror() : this.value;
        }

        @Override
        public String toString() {
            return "return";
        }
    }

    private static final class Continue
    extends CommandMirror {
        private Continue() {
        }

        @Override
        public String toString() {
            return "continue";
        }

        @Override
        public Mirror getVMMirror() {
            return null;
        }
    }

    private static final class Break
    extends CommandMirror {
        private Break() {
        }

        @Override
        public String toString() {
            return "break";
        }

        @Override
        public Mirror getVMMirror() {
            return null;
        }
    }

    private static abstract class CommandMirror
    extends ArtificialMirror {
        private CommandMirror() {
        }
    }

    static abstract class ArtificialMirror
    implements Mirror {
        ArtificialMirror() {
        }

        @Override
        public VirtualMachine virtualMachine() {
            return null;
        }

        public abstract Mirror getVMMirror();
    }

    private static final class UnsuitableArgumentsException
    extends Exception {
    }
}

