/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;

public class JPDAUtils {
    public static final boolean IS_JDK_160_02 = !System.getProperty("java.version").equals("1.6.0") && !System.getProperty("java.version").equals("1.6.0_01");

    public static final ReferenceType getPreferredReferenceType(List<ReferenceType> referenceTypes, Logger logger) throws VMDisconnectedExceptionWrapper {
        ReferenceType preferredType;
        if (referenceTypes.size() == 1) {
            preferredType = null;
        } else {
            preferredType = null;
            try {
                for (ReferenceType referenceType : referenceTypes) {
                    Field parentField;
                    ClassLoaderReference clr;
                    try {
                        clr = ReferenceTypeWrapper.classLoader(referenceType);
                    }
                    catch (ObjectCollectedExceptionWrapper ex) {
                        continue;
                    }
                    if (clr == null) {
                        if (preferredType != null) {
                            preferredType = null;
                            break;
                        }
                        preferredType = referenceType;
                        continue;
                    }
                    try {
                        parentField = ReferenceTypeWrapper.fieldByName(ObjectReferenceWrapper.referenceType(clr), "parent");
                    }
                    catch (ObjectCollectedExceptionWrapper ex) {
                        continue;
                    }
                    if (parentField != null) {
                        Value parent;
                        try {
                            parent = ObjectReferenceWrapper.getValue(clr, parentField);
                        }
                        catch (ObjectCollectedExceptionWrapper ex) {
                            continue;
                        }
                        if (parent != null) {
                            if (preferredType != null) {
                                preferredType = null;
                                break;
                            }
                            preferredType = referenceType;
                        }
                        if (logger == null || !logger.isLoggable(Level.FINE)) continue;
                        logger.fine("Class loader of reference type: " + clr + " have parent class loader: " + parent);
                        continue;
                    }
                    if (logger == null || !logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Class loader of reference type: " + clr + ". Parent class loader - field parent does not exist.");
                }
            }
            catch (InternalExceptionWrapper iex) {
                preferredType = null;
            }
            catch (ClassNotPreparedExceptionWrapper cnpex) {
                preferredType = null;
            }
        }
        return preferredType;
    }

    public static void printFeatures(Logger logger, VirtualMachine virtualMachine) {
        try {
            logger.fine("canAddMethod " + VirtualMachineWrapper.canAddMethod(virtualMachine));
            logger.fine("canBeModified " + VirtualMachineWrapper.canBeModified(virtualMachine));
            logger.fine("canGetBytecodes " + VirtualMachineWrapper.canGetBytecodes(virtualMachine));
            logger.fine("canGetCurrentContendedMonitor " + VirtualMachineWrapper.canGetCurrentContendedMonitor(virtualMachine));
            logger.fine("canGetMonitorInfo " + VirtualMachineWrapper.canGetMonitorInfo(virtualMachine));
            logger.fine("canGetOwnedMonitorInfo " + VirtualMachineWrapper.canGetOwnedMonitorInfo(virtualMachine));
            logger.fine("canGetSourceDebugExtension " + VirtualMachineWrapper.canGetSourceDebugExtension(virtualMachine));
            logger.fine("canGetSyntheticAttribute " + VirtualMachineWrapper.canGetSyntheticAttribute(virtualMachine));
            logger.fine("canPopFrames " + VirtualMachineWrapper.canPopFrames(virtualMachine));
            logger.fine("canRedefineClasses " + VirtualMachineWrapper.canRedefineClasses(virtualMachine));
            logger.fine("canRequestVMDeathEvent " + VirtualMachineWrapper.canRequestVMDeathEvent(virtualMachine));
            logger.fine("canUnrestrictedlyRedefineClasses " + VirtualMachineWrapper.canUnrestrictedlyRedefineClasses(virtualMachine));
            logger.fine("canUseInstanceFilters " + VirtualMachineWrapper.canUseInstanceFilters(virtualMachine));
            logger.fine("canWatchFieldAccess " + VirtualMachineWrapper.canWatchFieldAccess(virtualMachine));
            logger.fine("canWatchFieldModification " + VirtualMachineWrapper.canWatchFieldModification(virtualMachine));
        }
        catch (InternalExceptionWrapper e) {
            logger.fine(e.getLocalizedMessage());
        }
        catch (VMDisconnectedExceptionWrapper e) {
            logger.fine(e.getLocalizedMessage());
        }
    }
}

