/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.criticalpath;

import com.projity.pm.criticalpath.SchedulingAlgorithm;
import com.projity.pm.task.SubProj;
import com.projity.pm.task.Task;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class PredecessorTaskList {
    private LinkedList list = new LinkedList();
    private int calculationStateCount = 0;
    private boolean markerStatus;
    private int numberOfReverseScheduledTasks = 0;
    public static final int CALCULATION_STATUS_STEP = 3;
    private SchedulingAlgorithm schedulingAlgorithm;

    PredecessorTaskList(SchedulingAlgorithm schedulingAlgorithm) {
        this.schedulingAlgorithm = schedulingAlgorithm;
    }

    void removeTask(Task task) {
        if (task.isReverseScheduled()) {
            --this.numberOfReverseScheduledTasks;
        }
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            TaskReference taskReference = (TaskReference)iterator.next();
            if (taskReference.task != task) continue;
            iterator.remove();
        }
    }

    ListIterator reverseIterator() {
        return this.list.listIterator(this.list.size());
    }

    private void arrangeSingleTask(Task task) {
        task.arrangeTask(this.list, this.markerStatus, 0);
        if (task.isReverseScheduled()) {
            ++this.numberOfReverseScheduledTasks;
        }
    }

    public void addSubproject(Task task) {
        Object object2;
        TaskReference taskReference = (TaskReference)this.list.removeFirst();
        TaskReference taskReference2 = (TaskReference)this.list.removeLast();
        boolean bl = !this.getMarkerStatus();
        task.setMarkerStatus(bl);
        task.markTaskAsNeedingRecalculation();
        for (Object object2 : ((SubProj)((Object)task)).getSubproject().getTasks()) {
            ((Task)object2).setMarkerStatus(bl);
            ((Task)object2).markTaskAsNeedingRecalculation();
        }
        this.removeTask(task);
        this.arrangeSingleTask(task);
        object2 = ((SubProj)((Object)task)).getSubproject().getTasks().iterator();
        while (object2.hasNext()) {
            this.arrangeSingleTask((Task)object2.next());
        }
        this.list.addFirst(taskReference);
        this.list.addLast(taskReference2);
    }

    void arrangeTask(Task task) {
        if (task.isReverseScheduled()) {
            ++this.numberOfReverseScheduledTasks;
        }
        task.setMarkerStatus(this.markerStatus);
        ListIterator<TaskReference> listIterator = this.list.listIterator();
        TaskReference taskReference = new TaskReference(task);
        while (listIterator.hasNext()) {
            TaskReference taskReference2 = (TaskReference)listIterator.next();
            Task task2 = taskReference2.getTask();
            if (task.getWbsParentTask() != task2) continue;
            listIterator.add(taskReference);
            return;
        }
        listIterator.previous();
        listIterator.add(taskReference);
    }

    ListIterator listIterator() {
        return this.list.listIterator();
    }

    LinkedList getList() {
        return this.list;
    }

    public void dump() {
        ListIterator listIterator = this.list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            System.out.println(e);
        }
    }

    synchronized int getFreshCalculationStateCount() {
        while (this.calculationStateCount % 3 != 0) {
            ++this.calculationStateCount;
        }
        return this.calculationStateCount;
    }

    synchronized int getNextCalculationStateCount() {
        ++this.calculationStateCount;
        return this.calculationStateCount;
    }

    int getCalculationStateCount() {
        return this.calculationStateCount;
    }

    boolean addAll(Collection collection) {
        this.list.clear();
        this.toggleMarkerStatus();
        for (Task task : collection) {
            task.arrangeTask(this.list, this.markerStatus, 0);
            if (!task.isReverseScheduled()) continue;
            ++this.numberOfReverseScheduledTasks;
        }
        return true;
    }

    private void setDebugDependencyOrder() {
        int n = 0;
        for (TaskReference taskReference : this.list) {
            if (taskReference.getType() == 1) continue;
            Task task = taskReference.getTask();
            task.setDebugDependencyOrder(n++);
        }
    }

    void rearrangeAll() {
        LinkedList linkedList = this.list;
        TaskReference taskReference = (TaskReference)this.list.removeFirst();
        TaskReference taskReference2 = (TaskReference)this.list.removeLast();
        this.list = new LinkedList();
        Iterator iterator = linkedList.iterator();
        this.toggleMarkerStatus();
        while (iterator.hasNext()) {
            Task task = ((TaskReference)iterator.next()).getTask();
            this.arrangeSingleTask(task);
        }
        this.list.addFirst(taskReference);
        this.list.addLast(taskReference2);
    }

    boolean hasReverseScheduledTasks() {
        return this.numberOfReverseScheduledTasks > 0;
    }

    void recalculateReverseScheduledCount() {
        this.numberOfReverseScheduledTasks = 0;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Task task = ((TaskReference)iterator.next()).getTask();
            if (!task.isReverseScheduled()) continue;
            ++this.numberOfReverseScheduledTasks;
        }
    }

    public final boolean getMarkerStatus() {
        return this.markerStatus;
    }

    final boolean toggleMarkerStatus() {
        this.markerStatus = !this.markerStatus;
        return this.markerStatus;
    }

    public int[] findTaskPosition(Task task) {
        int[] nArray = task.isWbsParent() ? new int[2] : new int[1];
        Iterator iterator = this.list.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            Task task2 = ((TaskReference)iterator.next()).getTask();
            if (task2 == task) {
                nArray[n++] = n2;
                if (n == nArray.length) break;
            }
            ++n2;
        }
        return nArray;
    }

    public static final class TaskReference
    implements Comparable {
        static final int PARENT_BEGIN = -1;
        static final int CHILD = 0;
        static final int PARENT_END = 1;
        Task task;
        int type = 0;
        TaskReference opposite = null;
        long calculationStateCount = 0L;

        public TaskReference(Task task) {
            this.task = task;
        }

        public Task getTask() {
            return this.task;
        }

        public int compareTo(Object object) {
            if (object instanceof Task) {
                return this.getTask() == object ? 0 : -1;
            }
            return object == this ? 0 : -1;
        }

        public void setParentBegin() {
            this.type = -1;
        }

        public void setParentEnd() {
            this.type = 1;
        }

        public String toString() {
            String string = this.task.toString();
            if (this.type == -1) {
                string = string + " begin";
            } else if (this.type == 1) {
                string = string + " end";
            }
            return string;
        }

        public int getType() {
            return this.type;
        }
    }
}

