/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public class XDBCharData
extends XDBNode
implements CharacterData {
    XDBCharData(XDBDocument doc, long xob) {
        super(doc, xob);
    }

    XDBCharData(XDBDocument doc, long xob, short type) {
        super(doc, xob, type);
    }

    public void appendData(String appstring) throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            super.setNodeValue(String.valueOf(data) + appstring);
        } else {
            super.setNodeValue(appstring);
        }
    }

    public void deleteData(int offset, int count) throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            StringBuffer buf = new StringBuffer(data);
            try {
                buf.delete(offset, offset + count);
            }
            catch (Exception ex) {
                throw new DOMException(1, ex.getMessage());
            }
            super.setNodeValue(buf.toString());
        } else {
            super.setNodeValue(data);
        }
    }

    public String getData() throws DOMException {
        return super.getNodeValue();
    }

    public int getLength() throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            return data.length();
        }
        return 0;
    }

    public void insertData(int offset, String appstring) throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            StringBuffer buf = new StringBuffer(data);
            try {
                buf.insert(offset, appstring);
            }
            catch (Exception ex) {
                throw new DOMException(1, ex.getMessage());
            }
            super.setNodeValue(buf.toString());
        } else {
            super.setNodeValue(appstring);
        }
    }

    public void replaceData(int offset, int count, String repdata) throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            StringBuffer buf = new StringBuffer(data);
            try {
                buf.replace(offset, offset + count, repdata);
            }
            catch (Exception ex) {
                throw new DOMException(1, ex.getMessage());
            }
            super.setNodeValue(buf.toString());
        } else {
            super.setNodeValue(data);
        }
    }

    public void setData(String data) throws DOMException {
        super.setNodeValue(data);
    }

    public String substringData(int offset, int count) throws DOMException {
        String data = super.getNodeValue();
        try {
            if (data != null) {
                int end_offset = offset + count;
                int len = data.length();
                if (end_offset >= len) {
                    end_offset = len;
                }
                return data.substring(offset, end_offset);
            }
            return null;
        }
        catch (Exception ex) {
            throw new DOMException(1, ex.getMessage());
        }
    }
}

