/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.FileUtils;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import com.jezhumble.javasysmon.NativeLibraryLoader;
import com.jezhumble.javasysmon.ProcessInfo;
import java.io.IOException;
import java.util.ArrayList;

class SolarisMonitor
implements Monitor {
    private static Monitor monitor = null;
    private final FileUtils fileUtils;

    public SolarisMonitor() {
        JavaSysMon.addSupportedConfig("Solaris (x86)");
        if (monitor != null) {
            JavaSysMon.setMonitor(monitor);
        }
        this.fileUtils = new FileUtils();
    }

    public String osName() {
        return System.getProperty("os.name");
    }

    public ProcessInfo[] processTable() {
        ArrayList<ProcessInfo> processTable = new ArrayList<ProcessInfo>();
        String[] pids = this.fileUtils.pidsFromProcFilesystem();
        for (int i = 0; i < pids.length; ++i) {
            try {
                byte[] psinfo = this.fileUtils.slurpToByteArray("/proc/" + pids[i] + "/psinfo");
                byte[] usage = this.fileUtils.slurpToByteArray("/proc/" + pids[i] + "/usage");
                processTable.add(this.psinfoToProcess(psinfo, usage));
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return processTable.toArray(new ProcessInfo[processTable.size()]);
    }

    public native ProcessInfo psinfoToProcess(byte[] var1, byte[] var2);

    public native int numCpus();

    public native long cpuFrequencyInHz();

    public native long uptimeInSeconds();

    public native int currentPid();

    public native CpuTimes cpuTimes();

    public native MemoryStats physical();

    public native MemoryStats swap();

    public native void killProcess(int var1);

    static {
        if (System.getProperty("os.name").toLowerCase().startsWith("sunos") && System.getProperty("os.arch").toLowerCase().startsWith("x86")) {
            new NativeLibraryLoader().loadLibrary("javasysmonsolx86.so");
            monitor = new SolarisMonitor();
        }
    }
}

