/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions;

import au.com.trgtd.tr.appl.InitialAction;
import java.awt.EventQueue;
import java.util.Vector;
import java.util.logging.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.actions.RAProjectsTreeTopComponent;
import tr.view.actions.RASingleActionsTopComponent;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.ActionsScreens;
import tr.view.actions.screens.ReviewActionsTopComponent;
import tr.view.actions.screens.dao.ScreensDAOProvider;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectsTreeLookup;
import tr.view.projects.ProjectsTreeTopComponent;
import tr.view.projects.actions.SingleActionsLookup;
import tr.view.projects.actions.SingleActionsTopComponent;

public class RAAction
extends CallableSystemAction
implements InitialAction {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private static RAAction instance;
    private Lookup.Result result;

    public RAAction() {
        this.enableDisable();
        this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                LOG.fine("DataLookup Data.class result changed.");
                RAAction.this.enableDisable();
            }
        });
        instance = this;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_RAAction");
    }

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/Actions.png";
    }

    public static RAAction getInstance() {
        if (instance == null) {
            instance = new RAAction();
        }
        return instance;
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public String getID() {
        return "actions";
    }

    public void performAction() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Data data = (Data)DataLookup.instance().lookup(Data.class);
                if (data == null) {
                    return;
                }
                WindowUtils.closeWindows();
                Mode mode = WindowManager.getDefault().findMode("ra-actions");
                if (mode == null) {
                    LOG.severe("Mode ra-actions was not found.");
                    return;
                }
                boolean first = true;
                Vector screens = ((ActionsScreens)ScreensDAOProvider.instance().provide().getData()).getScreens().list();
                for (ActionsScreen s : screens) {
                    ReviewActionsTopComponent tc = ReviewActionsTopComponent.createInstance(s);
                    mode.dockInto((TopComponent)tc);
                    tc.open();
                    if (!first) continue;
                    tc.requestActive();
                    first = false;
                }
                ProjectsTreeTopComponent tcProjects = RAProjectsTreeTopComponent.findInstance();
                ProjectsTreeLookup.register((ProjectsTreeTopComponent)tcProjects);
                SingleActionsTopComponent tcSingleActions = RASingleActionsTopComponent.findInstance();
                SingleActionsLookup.register((SingleActionsTopComponent)tcSingleActions);
                EditorTopComponent tcEditor = EditorTopComponent.findInstance();
                mode = WindowManager.getDefault().findMode("ra-projects");
                if (mode == null) {
                    LOG.severe("Mode ra-projects was not found.");
                } else {
                    mode.dockInto((TopComponent)tcProjects);
                    mode.dockInto((TopComponent)tcSingleActions);
                }
                mode = WindowManager.getDefault().findMode("ra-editor");
                if (mode == null) {
                    LOG.severe("Mode ra-editor was not found.");
                } else {
                    mode.dockInto((TopComponent)tcEditor);
                }
                tcProjects.open();
                tcSingleActions.open();
                tcEditor.open();
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("prefs.actions.screens");
    }
}

