/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.EventLogInterface;
import org.hsqldb.persist.RandomAccessInterface;

final class RAFileNIO
implements RandomAccessInterface {
    private final EventLogInterface logger;
    private final boolean readOnly;
    private final long maxLength;
    private long fileLength;
    private RandomAccessFile file;
    private FileDescriptor fileDescriptor;
    private MappedByteBuffer buffer;
    private long bufferPosition;
    private int bufferLength;
    private long currentPosition;
    private FileChannel channel;
    private boolean buffersModified;
    private MappedByteBuffer[] buffers = new MappedByteBuffer[0];
    private static final String JVM_ERROR = "NIO access failed";
    static final int largeBufferScale = 24;
    static final int largeBufferSize = 0x1000000;
    static final long largeBufferMask = -16777216L;

    RAFileNIO(EventLogInterface eventLogInterface, String string, boolean bl, long l, long l2) throws IOException {
        this.logger = eventLogInterface;
        this.maxLength = l2;
        File file = new File(string);
        if (bl) {
            l = file.length();
        } else {
            if (file.length() > l) {
                l = file.length();
            }
            l = ArrayUtil.getBinaryNormalisedCeiling(l, 24);
        }
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        this.readOnly = bl;
        this.channel = this.file.getChannel();
        this.fileDescriptor = this.file.getFD();
        if (!this.ensureLength(l)) {
            this.close();
            IOException iOException = new IOException("NIO buffer allocation failed");
            throw iOException;
        }
        this.buffer = this.buffers[0];
        this.bufferLength = this.buffer.limit();
        this.bufferPosition = 0L;
        this.currentPosition = 0L;
    }

    @Override
    public long length() throws IOException {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            this.logger.logWarningEvent(JVM_ERROR, iOException);
            throw iOException;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void seek(long l) throws IOException {
        try {
            this.positionBufferSeek(l);
            this.buffer.position((int)(l - this.bufferPosition));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.logWarningEvent(JVM_ERROR, illegalArgumentException);
            IOException iOException = JavaSystem.toIOException(illegalArgumentException);
            throw iOException;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        try {
            return this.currentPosition;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            byte by = this.buffer.get();
            this.positionBufferMove(1);
            return by;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws IOException {
        try {
            do {
                this.checkBuffer();
                long l = this.bufferPosition + (long)this.bufferLength - this.currentPosition;
                if (l > (long)n2) {
                    l = n2;
                }
                this.buffer.get(byArray, n, (int)l);
                this.positionBufferMove((int)l);
                n2 = (int)((long)n2 - l);
                n = (int)((long)n + l);
            } while (n2 != 0);
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            int n = this.buffer.getInt();
            this.positionBufferMove(4);
            return n;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            long l = this.buffer.getLong();
            this.positionBufferMove(8);
            return l;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.buffersModified = true;
            do {
                this.checkBuffer();
                long l = this.bufferPosition + (long)this.bufferLength - this.currentPosition;
                if (l > (long)n2) {
                    l = n2;
                }
                this.buffer.put(byArray, n, (int)l);
                this.positionBufferMove((int)l);
                n2 = (int)((long)n2 - l);
                n = (int)((long)n + l);
            } while (n2 != 0);
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void writeInt(int n) throws IOException {
        try {
            this.buffersModified = true;
            this.buffer.putInt(n);
            this.positionBufferMove(4);
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void writeLong(long l) throws IOException {
        try {
            this.buffersModified = true;
            this.buffer.putLong(l);
            this.positionBufferMove(8);
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.logger.logDetailEvent("NIO file close, size: " + this.fileLength);
            this.buffer = null;
            this.channel = null;
            for (int i = 0; i < this.buffers.length; ++i) {
                this.unmap(this.buffers[i]);
                this.buffers[i] = null;
            }
            this.file.close();
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent("NIO buffer close error", throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean ensureLength(long l) {
        if (l > this.maxLength) {
            return false;
        }
        while (l > this.fileLength) {
            if (this.enlargeFile(l)) continue;
            return false;
        }
        return true;
    }

    private boolean enlargeFile(long l) {
        try {
            FileChannel.MapMode mapMode;
            long l2 = l;
            if (!this.readOnly) {
                l2 = 0x1000000L;
            }
            FileChannel.MapMode mapMode2 = mapMode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            if (!this.readOnly && this.file.length() < this.fileLength + l2) {
                this.file.seek(this.fileLength + l2 - 1L);
                this.file.writeByte(0);
            }
            MappedByteBuffer[] mappedByteBufferArray = new MappedByteBuffer[this.buffers.length + 1];
            MappedByteBuffer mappedByteBuffer = this.channel.map(mapMode, this.fileLength, l2);
            System.arraycopy(this.buffers, 0, mappedByteBufferArray, 0, this.buffers.length);
            mappedByteBufferArray[this.buffers.length] = mappedByteBuffer;
            this.buffers = mappedByteBufferArray;
            this.fileLength += l2;
            this.logger.logDetailEvent("NIO buffer instance, file size " + this.fileLength);
        }
        catch (Throwable throwable) {
            this.logger.logDetailEvent("NOI buffer allocate failed, file size " + l);
            return false;
        }
        return true;
    }

    @Override
    public boolean setLength(long l) {
        if (l > this.fileLength) {
            return this.enlargeFile(l);
        }
        try {
            this.seek(0L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        int n;
        boolean bl = false;
        int n2 = 0;
        for (n = 0; n < this.buffers.length; ++n) {
            try {
                this.buffers[n].force();
                continue;
            }
            catch (Throwable throwable) {
                this.logger.logWarningEvent("NIO buffer force error: pos " + n * 0x1000000 + " ", throwable);
                if (!bl) {
                    n2 = n;
                }
                bl = true;
            }
        }
        if (bl) {
            for (n = n2; n < this.buffers.length; ++n) {
                try {
                    this.buffers[n].force();
                    continue;
                }
                catch (Throwable throwable) {
                    this.logger.logWarningEvent("NIO buffer force error " + n * 0x1000000 + " ", throwable);
                }
            }
        }
        try {
            this.fileDescriptor.sync();
            this.buffersModified = false;
        }
        catch (Throwable throwable) {
            this.logger.logSevereEvent("NIO RA file sync error ", throwable);
            throw Error.error(throwable, 452, null);
        }
    }

    private void positionBufferSeek(long l) {
        if (l < this.bufferPosition || l >= this.bufferPosition + (long)this.bufferLength) {
            this.setCurrentBuffer(l);
        }
        this.buffer.position((int)(l - this.bufferPosition));
        this.currentPosition = l;
    }

    private void positionBufferMove(int n) {
        long l = this.currentPosition + (long)n;
        if (l >= this.bufferPosition + (long)this.bufferLength) {
            this.setCurrentBuffer(l);
        }
        this.buffer.position((int)(l - this.bufferPosition));
        this.currentPosition = l;
    }

    private void setCurrentBuffer(long l) {
        int n = (int)(l >> 24);
        if (n == this.buffers.length) {
            n = this.buffers.length - 1;
            this.bufferPosition = (long)n * 0x1000000L;
            this.buffer = this.buffers[n];
            return;
        }
        this.buffer = this.buffers[n];
        this.bufferPosition = l & 0xFFFFFFFFFF000000L;
    }

    private void checkBuffer() {
        int n = (int)(this.currentPosition >> 24);
        if (this.currentPosition != this.bufferPosition + (long)this.buffer.position()) {
            this.buffer = this.buffers[n];
            this.bufferPosition = this.currentPosition & 0xFFFFFFFFFF000000L;
            this.buffer.position((int)(this.currentPosition - this.bufferPosition));
        } else if (this.buffer != this.buffers[n]) {
            this.buffer = this.buffers[n];
        }
    }

    private void unmap(MappedByteBuffer mappedByteBuffer) throws IOException {
        if (mappedByteBuffer == null) {
            return;
        }
        try {
            Method method = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)mappedByteBuffer, new Object[0]);
            Method method2 = object.getClass().getMethod("clean", new Class[0]);
            method2.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

