<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_session_dbd - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_session_dbd</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_session_dbd.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_session_dbd.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Support des session bas sur DBD/SQL</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>session_dbd_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_session_dbd.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3 d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <div class="warning"><h3>Avertissement</h3>
      <p>Les modules de session font usage des cookies HTTP, et peuvent
       ce titre tre victimes d'attaques de type Cross Site Scripting,
      ou divulguer des informations  caractre priv aux clients.
      Veuillez vous assurer que les risques ainsi encourus ont t pris
      en compte avant d'activer le support des sessions sur votre
      serveur.</p>
    </div>

    <p>Ce sous-module du module <code class="module"><a href="../mod/mod_session.html">mod_session</a></code> fournit le
    support du stockage des sessions utilisateur dans une base de
    donnes SQL en utilisant le module <code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code>.</p>

    <p>Les sessions sont soit <strong>anonymes</strong>, et la session
    est alors identifie par un UUID unique stock dans un cookie au
    niveau du navigateur, soit <strong>propres  l'utilisateur</strong>,
    et la session est alors identifie par l'identifiant de
    l'utilisateur connect.</p>

    <p>Les sessions bases sur SQL sont dissimules au navigateur, et
    permettent ainsi de prserver la confidentialit sans avoir recours
    au chiffrement.</p>

    <p>Plusieurs serveurs web d'une fort de serveurs peuvent choisir de
    partager une base de donnes, et ainsi partager les sessions entre
    eux.</p>

    <p>Pour plus de dtails  propos de l'interface des sessions, voir
    la documentation du module <code class="module"><a href="../mod/mod_session.html">mod_session</a></code>.</p>

</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#dbdconfig">Configuration de DBD</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#anonymous">Sessions anonymes</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#peruser">Sessions propres  un
    utilisateur</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#housekeeping">Nettoyage de la base de
    donnes</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#sessiondbdcookiename">SessionDBDCookieName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessiondbdcookiename2">SessionDBDCookieName2</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessiondbdcookieremove">SessionDBDCookieRemove</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessiondbddeletelabel">SessionDBDDeleteLabel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessiondbdinsertlabel">SessionDBDInsertLabel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessiondbdperuser">SessionDBDPerUser</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessiondbdselectlabel">SessionDBDSelectLabel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessiondbdupdatelabel">SessionDBDUpdateLabel</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_session_dbd">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_session_dbd">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_session.html">mod_session</a></code></li>
<li><code class="module"><a href="../mod/mod_session_crypto.html">mod_session_crypto</a></code></li>
<li><code class="module"><a href="../mod/mod_session_cookie.html">mod_session_cookie</a></code></li>
<li><code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="dbdconfig" id="dbdconfig">Configuration de DBD</a></h2>

      <p>Pour que le module <code class="module"><a href="../mod/mod_session_dbd.html">mod_session_dbd</a></code> puisse tre
      configur et maintenir une session, il faut tout d'abord
      configurer le module <code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code> pour que le serveur
      puisse excuter des requtes vers la base de donnes.</p>

      <p>Quatre types de requtes sont ncessaires pour maintenir une
      session, slectionner ou mettre  jour une session existante,
      insrer une nouvelle session et supprimer une session vide ou
      arrive  expiration. Ces requtes sont configures comme dans
      l'exemple suivant :</p>

      <div class="example"><h3>Exemple de configuration de DBD</h3><pre class="prettyprint lang-config">DBDriver pgsql
DBDParams "dbname=apachesession user=apache password=xxxxx host=localhost"
DBDPrepareSQL "delete from session where key = %s" deletesession
DBDPrepareSQL "update session set value = %s, expiry = %lld, key = %s where key = %s" updatesession
DBDPrepareSQL "insert into session (value, expiry, key) values (%s, %lld, %s)" insertsession
DBDPrepareSQL "select value from session where key = %s and (expiry = 0 or expiry &gt; %lld)" selectsession
DBDPrepareSQL "delete from session where expiry != 0 and expiry &lt; %lld" cleansession</pre>
</div>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="anonymous" id="anonymous">Sessions anonymes</a></h2>

      <p>Les sessions anonymes sont identifies par un UUID unique, et
      stockes dans un cookie au niveau du navigateur. Cette mthode est
      similaire  celle utilise par la plupart des serveurs
      d'applications pour stocker les informations de session.</p>

      <p>Pour crer une session anonyme, la stocker dans une table de
      base de donne postgres nomme <var>apachesession</var>, et
      sauvegarder l'identifiant de session dans un cookie nomm
      <var>session</var>, configurez la session comme suit :</p>

      <div class="example"><h3>Session anonyme base sur SQL</h3><pre class="prettyprint lang-config">Session On
SessionDBDCookieName session path=/</pre>
</div>

      <p>Pour plus d'exemples sur la manire dont une application CGI
      peut accder aux informations de session, voir la section exemples
      de la documentation du module <code class="module"><a href="../mod/mod_session.html">mod_session</a></code>.</p>

      <p>Pour des dtails sur la manire dont une session peut tre
      utilise pour stocker des informations de type nom
      d'utilisateur/mot de passe, voir la documentation du module
      <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="peruser" id="peruser">Sessions propres  un
    utilisateur</a></h2>

      <p>Les sessions propres  un utilisateur sont identifies par le
      nom de l'utilisateur authentifi avec succs. Ceci permet
      d'assurer une confidentialit optimale, car aucun traitement
      externe  la session n'existe en dehors du contexte
      authentifi.</p>

      <p>Les sessions propres  un utilisateur ne fonctionnent que dans
      un environnement d'authentification correctement configur, qu'il
      s'agisse d'une authentification de base,  base de condenss
      (digest) ou de certificats client SSL. Suite  des limitations
      dues  des dpendances mutuelles, les sessions propres  un
      utilisateur ne peuvent pas tre utilises pour stocker les donnes
      d'authentification en provenance d'un module comme
      <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>.</p>

      <p>Pour crer une session propre  un utilisateur, la stocker dans
      une table de base de donnes postgres nomme
      <var>apachesession</var>, avec comme cl de session l'identifiant
      utilisateur, ajoutez les lignes suivantes :</p>

      <div class="example"><h3>Session propre  un utilisateur base sur SQL</h3><pre class="prettyprint lang-config">Session On
SessionDBDPerUser On</pre>
</div>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="housekeeping" id="housekeeping">Nettoyage de la base de
    donnes</a></h2>
      <p>Avec le temps, la base de donnes va commencer  accumuler des
      sessions expires. Pour le moment, le module
      <code class="module"><a href="../mod/mod_session_dbd.html">mod_session_dbd</a></code> n'est pas en mesure de grer
      automatiquement l'expiration des sessions.</p>

      <div class="warning"><h3>Avertissement</h3>
      <p>L'administrateur devra mettre en oeuvre un traitement externe
      via cron pour nettoyer les sessions expires.</p>
      </div>

    </div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sessiondbdcookiename" id="sessiondbdcookiename">Directive</a> <a name="SessionDBDCookieName" id="SessionDBDCookieName">SessionDBDCookieName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom et attributs du cookie RFC2109 qui contient
l'identifiant de session</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionDBDCookieName <var>nom</var> <var>attributs</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session_dbd</td></tr>
</table>
    <p>La directive <code class="directive">SessionDBDCookieName</code> permet
    de spcifier le nom et les attributs optionnels d'un cookie
    compatible RFC2109 qui contiendra l'identifiant de session. Les
    cookies RFC2109 sont dfinis  l'aide de l'en-tte HTTP
    <code>Set-Cookie</code>.
    </p>

    <p>Une liste optionnelle d'attributs peut tre spcifie pour ce
    cookie, comme dans l'exemple ci-dessous. Ces attributs sont insrs
    dans le cookie tels quels, et ne sont pas interprts par Apache.
    Assurez-vous que vos attributs sont dfinis correctement selon la
    spcification des cookies.
    </p>

    <div class="example"><h3>Cookie avec attributs</h3><pre class="prettyprint lang-config">Session On
SessionDBDCookieName session path=/private;domain=example.com;httponly;secure;version=1;</pre>
</div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sessiondbdcookiename2" id="sessiondbdcookiename2">Directive</a> <a name="SessionDBDCookieName2" id="SessionDBDCookieName2">SessionDBDCookieName2</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom et attributs du cookie RFC2965 qui contient
l'identifiant de session</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionDBDCookieName2 <var>nom</var> <var>attributs</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session_dbd</td></tr>
</table>
    <p>La directive <code class="directive">SessionDBDCookieName2</code> permet
    de spcifier le nom et les attributs optionnels d'un cookie
    compatible RFC2965 qui contiendra l'identifiant de session. Les
    cookies RFC2965 sont dfinis  l'aide de l'en-tte HTTP
    <code>Set-Cookie2</code>.
    </p>

    <p>Une liste optionnelle d'attributs peut tre spcifie pour ce
    cookie, comme dans l'exemple ci-dessous. Ces attributs sont insrs
    dans le cookie tel quel, et ne sont pas interprts par Apache.
    Assurez-vous que vos attributs sont dfinis correctement selon la
    spcification des cookies.
    </p>

    <div class="example"><h3>Cookie2 avec attributs</h3><pre class="prettyprint lang-config">Session On
SessionDBDCookieName2 session path=/private;domain=example.com;httponly;secure;version=1;</pre>
</div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sessiondbdcookieremove" id="sessiondbdcookieremove">Directive</a> <a name="SessionDBDCookieRemove" id="SessionDBDCookieRemove">SessionDBDCookieRemove</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si les cookies de session doivent tre supprims
des en-ttes HTTP entrants</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionDBDCookieRemove On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SessionDBDCookieRemove On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session_dbd</td></tr>
</table>
    <p>La directive <code class="directive">SessionDBDCookieRemove</code> permet
    de dterminer si les cookies contenant l'identifiant de session
    doivent tre supprims des en-ttes pendant le traitement de la
    requte.</p>

    <p>Dans le cas d'un mandataire inverse o le serveur Apache sert de
    frontal  un serveur d'arrire-plan, rvler le contenu du cookie de
    session  ce dernier peut conduire  une violation de la
    confidentialit.  ce titre, si cette directive est dfinie  "on",
    le cookie de session sera supprim des en-ttes HTTP entrants.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sessiondbddeletelabel" id="sessiondbddeletelabel">Directive</a> <a name="SessionDBDDeleteLabel" id="SessionDBDDeleteLabel">SessionDBDDeleteLabel</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La requte SQL  utiliser pour supprimer des sessions de la
base de donnes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionDBDDeleteLabel <var>tiquette</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SessionDBDDeleteLabel deletesession</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session_dbd</td></tr>
</table>
    <p>La directive <code class="directive">SessionDBDDeleteLabel</code> permet
    de dfinir l'tiquette de la requte de suppression  utiliser par
    dfaut pour supprimer une session vide ou expire. Cette
    tiquette doit avoir t dfinie au pralable via une directive
    <code class="directive"><a href="../mod/mod_dbd.html#dbdpreparesql">DBDPrepareSQL</a></code>.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sessiondbdinsertlabel" id="sessiondbdinsertlabel">Directive</a> <a name="SessionDBDInsertLabel" id="SessionDBDInsertLabel">SessionDBDInsertLabel</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La requte SQL  utiliser pour insrer des sessions dans la
base de donnes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionDBDInsertLabel <var>tiquette</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SessionDBDInsertLabel insertsession</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session_dbd</td></tr>
</table>
    <p>La directive <code class="directive">SessionDBDInsertLabel</code> permet
    de dfinir l'tiquette de la requte d'insertion par dfaut 
    charger dans une session. Cette
    tiquette doit avoir t dfinie au pralable via une directive
    <code class="directive"><a href="../mod/mod_dbd.html#dbdpreparesql">DBDPrepareSQL</a></code>.</p>

    <p>Si une tentative de mise  jour d'une session ne concerne aucun
    enregistrement, c'est cette requte qui sera utilise pour insrer
    la session dans la base de donnes.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sessiondbdperuser" id="sessiondbdperuser">Directive</a> <a name="SessionDBDPerUser" id="SessionDBDPerUser">SessionDBDPerUser</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active une session propre  un utilisateur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionDBDPerUser On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SessionDBDPerUser Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session_dbd</td></tr>
</table>
    <p>La directive <code class="directive">SessionDBDPerUser</code> permet
    d'activer une session propre  un utilisateur, dont la cl sera le
    nom de l'utilisateur connect. Si l'utilisateur n'est pas connect,
    la directive sera ignore.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sessiondbdselectlabel" id="sessiondbdselectlabel">Directive</a> <a name="SessionDBDSelectLabel" id="SessionDBDSelectLabel">SessionDBDSelectLabel</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La requte SQL  utiliser pour slectionner des sessions
dans la base de donnes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionDBDSelectLabel <var>tiquette</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SessionDBDSelectLabel selectsession</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session_dbd</td></tr>
</table>
    <p>La directive <code class="directive">SessionDBDSelectLabel</code> permet
    de dfinir l'tiquette de la requte de slection par dfaut 
    utiliser pour charger une session. Cette tiquette doit avoir t
    dfinie au pralable via une directive <code class="directive"><a href="../mod/mod_dbd.html#dbdpreparesql">DBDPrepareSQL</a></code>.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sessiondbdupdatelabel" id="sessiondbdupdatelabel">Directive</a> <a name="SessionDBDUpdateLabel" id="SessionDBDUpdateLabel">SessionDBDUpdateLabel</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La requte SQL  utiliser pour mettre  jour des sessions
prexistantes dans la base de donnes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionDBDUpdateLabel <var>tiquette</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SessionDBDUpdateLabel updatesession</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session_dbd</td></tr>
</table>
    <p>La directive <code class="directive">SessionDBDUpdateLabel</code> permet
    de dfinir l'tiquette de la requte de mise  jour par dfaut 
    charger dans une session. Cette
    tiquette doit avoir t dfinie au pralable via une directive
    <code class="directive"><a href="../mod/mod_dbd.html#dbdpreparesql">DBDPrepareSQL</a></code>.</p>

    <p>Si une tentative de mise  jour d'une session ne concerne aucun
    enregistrement, c'est la requte d'insertion qui sera appele pour
    insrer la session dans la base de donnes. Si la base de donnes
    supporte InsertOrUpdate, modifiez cette requte pour effectuer la
    mise  jour en une seule requte au lieu de deux.</p>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_session_dbd.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_session_dbd.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_session_dbd.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>