'''OpenGL extension ARB.debug_group

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.debug_group to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines a mechanism for the OpenGL application to annotate 
	the command stream with markers for discrete events and groups of commands 
	using descriptive text. 
	
	When profiling or debugging an OpenGL application with a built-in or an 
	external debugger or profiler, it is difficult to relate the commands 
	within the command stream to the elements of the scene or parts of the 
	program code to which they correspond. Debug markers and debug groups help
	obviate this by allowing applications to specify this link. For example,
	a debug marker can be used to identify the beginning of a frame in the
	command stream and a debug group can encapsulate a specific command stream
	to identify a rendering pass. Debug groups also allow to control the debug 
	output volume per section of an application code providing an effective 
	way to handle the massive amount of debug outputs that drivers can 
	generate.
	
	The intended purpose of this is purely to improve the user experience 
	within OpenGL development tools and application built-in code for 
	debugging and profiling.
	
	This extension is based on the functionality proposed by the OpenGL ES 
	extension EXT_debug_marker but with a similar approach to ARB_debug_output
	for the purpose of synergy between APIs and debug functionalities. This 
	allows sharing a single set of APIs for both built-in and external 
	debuggers and profilers.
	
	Finally, this extension adds a new severity level (a notification) to 
	emphasise the profiling usages of the debug output functionality. It aims 
	reporting messages which are only useful notifications for the application
	perspective.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/debug_group.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.debug_group import *
### END AUTOGENERATED SECTION