'''OpenGL extension MESA.pack_invert

This module customises the behaviour of the 
OpenGL.raw.GL.MESA.pack_invert to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds a new pixel storage parameter to indicate that
	images are to be packed in top-to-bottom order instead of OpenGL's
	conventional bottom-to-top order.  Only pixel packing can be
	inverted (i.e. for glReadPixels, glGetTexImage, glGetConvolutionFilter,
	etc).
	
	Almost all known image file formats store images in top-to-bottom
	order.  As it is, OpenGL reads images from the frame buffer in
	bottom-to-top order.  Thus, images usually have to be inverted before
	writing them to a file with image I/O libraries.  This extension
	allows images to be read such that inverting isn't needed.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/MESA/pack_invert.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.MESA.pack_invert import *
### END AUTOGENERATED SECTION