/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import gnu.java.beans.encoder.Context;
import gnu.java.beans.encoder.ObjectId;
import gnu.java.beans.encoder.Root;
import gnu.java.beans.encoder.ScannerState;
import gnu.java.beans.encoder.elements.ArrayInstantiation;
import gnu.java.beans.encoder.elements.Array_Get;
import gnu.java.beans.encoder.elements.Array_Set;
import gnu.java.beans.encoder.elements.ClassResolution;
import gnu.java.beans.encoder.elements.List_Get;
import gnu.java.beans.encoder.elements.List_Set;
import gnu.java.beans.encoder.elements.MethodInvocation;
import gnu.java.beans.encoder.elements.NullObject;
import gnu.java.beans.encoder.elements.ObjectInstantiation;
import gnu.java.beans.encoder.elements.ObjectReference;
import gnu.java.beans.encoder.elements.PrimitiveInstantiation;
import gnu.java.beans.encoder.elements.StaticFieldAccess;
import gnu.java.beans.encoder.elements.StaticMethodInvocation;
import gnu.java.beans.encoder.elements.StringReference;
import java.util.HashMap;

class GenericScannerState
extends ScannerState {
    private int skipElements;
    private int initialSkipElements;
    final Root root;
    HashMap skipValues;

    GenericScannerState(Root newRoot) {
        this.root = newRoot;
    }

    GenericScannerState(Root root, int skipElements) {
        this(root);
        this.skipElements = this.initialSkipElements = skipElements;
        if (skipElements > 0) {
            this.skipValues = new HashMap();
        }
    }

    protected void enterImpl(Context ctx) {
        if (this.skipValues != null) {
            Integer skip = (Integer)this.skipValues.get(ctx);
            if (skip == null) {
                skip = this.initialSkipElements;
                this.skipValues.put(ctx, skip);
            }
            this.skipElements = skip;
        }
    }

    void methodInvocation(String methodName) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new MethodInvocation(methodName));
    }

    void staticMethodInvocation(String className, String methodName) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new StaticMethodInvocation(className, methodName));
    }

    void staticFieldAccess(String className, String fieldName) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new StaticFieldAccess(className, fieldName));
    }

    void classResolution(String className) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new ClassResolution(className));
    }

    void objectInstantiation(String className, ObjectId objectId) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        ObjectInstantiation elem = new ObjectInstantiation(className);
        elem.initId(objectId);
        this.root.addChild(elem);
    }

    void primitiveInstantiation(String primitiveName, String valueAsString) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new PrimitiveInstantiation(primitiveName, valueAsString));
    }

    void objectArrayInstantiation(String arrayClassName, String lengthAsString, ObjectId objectId) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        ArrayInstantiation elem = new ArrayInstantiation(arrayClassName, lengthAsString);
        elem.initId(objectId);
        this.root.addChild(elem);
    }

    void primitiveArrayInstantiation(String arrayClassName, String lengthAsString, ObjectId objectId) {
        this.objectArrayInstantiation(arrayClassName, lengthAsString, objectId);
    }

    void arraySet(String indexAsString) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new Array_Set(indexAsString));
    }

    void arrayGet(String indexAsString) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new Array_Get(indexAsString));
    }

    void listGet() {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new List_Get());
    }

    void listSet() {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new List_Set());
    }

    void nullObject() {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new NullObject());
    }

    void stringReference(String string) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new StringReference(string));
    }

    void objectReference(ObjectId id) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new ObjectReference(id));
    }

    void end() {
        if (this.skipValues != null) {
            if (this.skipElements > 0) {
                --this.skipElements;
            } else {
                this.root.end();
            }
            this.skipValues.put(this.context(), this.skipElements);
        } else {
            this.root.end();
        }
    }

    void enter() {
    }
}

