/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class BMPImageReader
extends ImageReader {
    private BMPInfoHeader infoHeader = null;
    private BMPFileHeader fileHeader = null;
    private BMPDecoder decoder = null;

    protected BMPImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    private void validateIndex(int imageIndex) throws IndexOutOfBoundsException {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("Invalid image index.");
        }
    }

    public void setInput(Object input) {
        super.setInput(input);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    public void setInput(Object input, boolean isStreamable) {
        super.setInput(input, isStreamable);
        if (!(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("Input not an ImageInputStream.");
        }
    }

    private void checkStream() throws IOException {
        if (!(this.input instanceof ImageInputStream)) {
            throw new IllegalStateException("Input not an ImageInputStream.");
        }
        if (this.input == null) {
            throw new IllegalStateException("No input stream.");
        }
    }

    private void readHeaders() throws IOException, IIOException {
        if (this.fileHeader != null) {
            return;
        }
        this.checkStream();
        this.fileHeader = new BMPFileHeader((ImageInputStream)this.input);
        this.infoHeader = new BMPInfoHeader((ImageInputStream)this.input);
        this.decoder = BMPDecoder.getDecoder(this.fileHeader, this.infoHeader);
    }

    public int getWidth(int imageIndex) throws IOException {
        this.validateIndex(imageIndex);
        this.readHeaders();
        return this.infoHeader.getWidth();
    }

    public int getHeight(int imageIndex) throws IOException {
        this.validateIndex(imageIndex);
        this.readHeaders();
        return this.infoHeader.getHeight();
    }

    public Iterator getImageTypes(int imageIndex) {
        this.validateIndex(imageIndex);
        return null;
    }

    public int getNumImages(boolean allowSearch) {
        return 1;
    }

    public IIOMetadata getImageMetadata(int imageIndex) {
        this.validateIndex(imageIndex);
        return null;
    }

    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException, IIOException {
        this.validateIndex(imageIndex);
        this.readHeaders();
        return this.decoder.decode((ImageInputStream)this.input);
    }
}

