/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class PositiveIntegerType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};

    PositiveIntegerType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), TypeLibrary.NON_NEGATIVE_INTEGER);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        if (len == 0) {
            throw new DatatypeException(0, "invalid positive integer value");
        }
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (!(c == '+' ? i == 0 : c >= '0' && c <= '9')) {
                throw new DatatypeException(i, "invalid positive integer value");
            }
            ++i;
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            return new BigInteger(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

