/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicateScaleFilter
extends ImageFilter {
    protected int destHeight;
    protected int destWidth;
    protected int srcHeight;
    protected int srcWidth;
    protected int[] srcrows;
    protected int[] srccols;
    protected Object outpixbuf;

    public ReplicateScaleFilter(int width, int height) {
        this.destHeight = height;
        this.destWidth = width;
    }

    @Override
    public void setDimensions(int width, int height) {
        this.srcWidth = width;
        this.srcHeight = height;
        if (this.destWidth < 0 && this.destHeight < 0) {
            this.destWidth = width;
            this.destHeight = height;
        } else if (this.destWidth < 0) {
            this.destWidth = width * this.destHeight / this.srcHeight;
        } else if (this.destHeight < 0) {
            this.destHeight = height * this.destWidth / this.srcWidth;
        }
        if (this.consumer != null) {
            this.consumer.setDimensions(this.destWidth, this.destHeight);
        }
    }

    @Override
    public void setProperties(Hashtable<?, ?> props) {
        Hashtable<?, ?> prop2 = props;
        prop2.put("filters", "ReplicateScaleFilter");
        if (this.consumer != null) {
            this.consumer.setProperties(prop2);
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        int sy;
        byte[] pix;
        if (this.srcrows == null || this.srccols == null) {
            this.setupSources();
        }
        int dx1 = (2 * x * this.destWidth + this.srcWidth - 1) / (2 * this.destWidth);
        int dy1 = (2 * y * this.destHeight + this.srcHeight - 1) / (2 * this.destHeight);
        if (this.outpixbuf != null && this.outpixbuf instanceof byte[]) {
            pix = (byte[])this.outpixbuf;
        } else {
            pix = new byte[this.destWidth];
            this.outpixbuf = pix;
        }
        int yy = dy1;
        while ((sy = this.srcrows[yy]) < y + h) {
            int sx;
            int offs = offset + scansize * (sy - y);
            int xx = dx1;
            while ((sx = this.srccols[xx]) < x + w) {
                pix[xx] = pixels[offs + sx - x];
                ++xx;
            }
            if (xx > dx1) {
                this.consumer.setPixels(dx1, yy, xx - dx1, 1, model, pix, dx1, this.destWidth);
            }
            ++yy;
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        int sy;
        int[] pix;
        if (this.srcrows == null || this.srccols == null) {
            this.setupSources();
        }
        int dx1 = (2 * x * this.destWidth + this.srcWidth - 1) / (2 * this.destWidth);
        int dy1 = (2 * y * this.destHeight + this.srcHeight - 1) / (2 * this.destHeight);
        if (this.outpixbuf != null && this.outpixbuf instanceof int[]) {
            pix = (int[])this.outpixbuf;
        } else {
            pix = new int[this.destWidth];
            this.outpixbuf = pix;
        }
        int yy = dy1;
        while ((sy = this.srcrows[yy]) < y + h) {
            int sx;
            int offs = offset + scansize * (sy - y);
            int xx = dx1;
            while ((sx = this.srccols[xx]) < x + w) {
                pix[xx] = pixels[offs + sx - x];
                ++xx;
            }
            if (xx > dx1) {
                this.consumer.setPixels(dx1, yy, xx - dx1, 1, model, pix, dx1, this.destWidth);
            }
            ++yy;
        }
    }

    private void setupSources() {
        this.srcrows = new int[this.destHeight + 1];
        int y = 0;
        while (y <= this.destHeight) {
            this.srcrows[y] = (2 * y * this.srcHeight + this.srcHeight) / (2 * this.destHeight);
            ++y;
        }
        this.srccols = new int[this.destWidth + 1];
        int x = 0;
        while (x <= this.destWidth) {
            this.srccols[x] = (2 * x * this.srcWidth + this.srcWidth) / (2 * this.destWidth);
            ++x;
        }
    }
}

