/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.UnicodeToBytes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;
import java.util.Locale;

public class PrintStream
extends FilterOutputStream
implements Appendable {
    private static final char[] line_separator = System.getProperty("line.separator").toCharArray();
    UnicodeToBytes converter;
    char[] work = new char[100];
    byte[] work_bytes = new byte[100];
    private boolean error_occurred = false;
    private boolean auto_flush;

    public PrintStream(OutputStream out) {
        this(out, false);
    }

    public PrintStream(OutputStream out, boolean auto_flush) {
        super(out);
        this.converter = UnicodeToBytes.getDefaultEncoder();
        this.auto_flush = auto_flush;
    }

    public PrintStream(File file) throws FileNotFoundException {
        this(new FileOutputStream(file), false);
    }

    public PrintStream(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(file), false, encoding);
    }

    public PrintStream(String fileName) throws FileNotFoundException {
        this(new FileOutputStream(new File(fileName)), false);
    }

    public PrintStream(String fileName, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(new File(fileName)), false, encoding);
    }

    public PrintStream(OutputStream out, boolean auto_flush, String encoding) throws UnsupportedEncodingException {
        super(out);
        this.converter = UnicodeToBytes.getEncoder(encoding);
        this.auto_flush = auto_flush;
    }

    public boolean checkError() {
        this.flush();
        return this.error_occurred;
    }

    protected void setError() {
        this.error_occurred = true;
    }

    public void close() {
        try {
            this.converter.setFinished();
            this.writeChars(new char[0], 0, 0);
            this.flush();
            this.out.close();
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private synchronized void print(String str, boolean println) {
        try {
            this.writeChars(str, 0, str.length());
            if (println) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private synchronized void print(char[] chars, int pos, int len, boolean println) {
        try {
            this.writeChars(chars, pos, len);
            if (println) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private void writeChars(char[] buf, int offset, int count) throws IOException {
        int converted;
        do {
            this.converter.setOutput(this.work_bytes, 0);
            converted = this.converter.write(buf, offset, count);
            offset += converted;
            this.out.write(this.work_bytes, 0, this.converter.count);
        } while ((count -= converted) > 0 || this.converter.havePendingBytes());
    }

    private void writeChars(String str, int offset, int count) throws IOException {
        int converted;
        do {
            this.converter.setOutput(this.work_bytes, 0);
            converted = this.converter.write(str, offset, count, this.work);
            offset += converted;
            this.out.write(this.work_bytes, 0, this.converter.count);
        } while ((count -= converted) > 0 || this.converter.havePendingBytes());
    }

    public void print(boolean bool) {
        this.print(String.valueOf(bool), false);
    }

    public void print(int inum) {
        this.print(String.valueOf(inum), false);
    }

    public void print(long lnum) {
        this.print(String.valueOf(lnum), false);
    }

    public void print(float fnum) {
        this.print(String.valueOf(fnum), false);
    }

    public void print(double dnum) {
        this.print(String.valueOf(dnum), false);
    }

    public void print(Object obj) {
        this.print(obj == null ? "null" : obj.toString(), false);
    }

    public void print(String str) {
        this.print(str == null ? "null" : str, false);
    }

    public synchronized void print(char ch) {
        this.work[0] = ch;
        this.print(this.work, 0, 1, false);
    }

    public void print(char[] charArray) {
        this.print(charArray, 0, charArray.length, false);
    }

    public void println() {
        this.print(line_separator, 0, line_separator.length, false);
    }

    public void println(boolean bool) {
        this.print(String.valueOf(bool), true);
    }

    public void println(int inum) {
        this.print(String.valueOf(inum), true);
    }

    public void println(long lnum) {
        this.print(String.valueOf(lnum), true);
    }

    public void println(float fnum) {
        this.print(String.valueOf(fnum), true);
    }

    public void println(double dnum) {
        this.print(String.valueOf(dnum), true);
    }

    public void println(Object obj) {
        this.print(obj == null ? "null" : obj.toString(), true);
    }

    public void println(String str) {
        this.print(str == null ? "null" : str, true);
    }

    public synchronized void println(char ch) {
        this.work[0] = ch;
        this.print(this.work, 0, 1, true);
    }

    public void println(char[] charArray) {
        this.print(charArray, 0, charArray.length, true);
    }

    public void write(int oneByte) {
        try {
            this.out.write(oneByte & 0xFF);
            if (this.auto_flush && oneByte == 10) {
                this.flush();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void write(byte[] buffer, int offset, int len) {
        try {
            this.out.write(buffer, offset, len);
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public PrintStream append(char c) {
        this.print(c);
        return this;
    }

    public PrintStream append(CharSequence cs) {
        this.print(cs == null ? "null" : cs.toString());
        return this;
    }

    public PrintStream append(CharSequence cs, int start, int end) {
        this.print(cs == null ? "null" : cs.subSequence(start, end).toString());
        return this;
    }

    public PrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public PrintStream printf(Locale locale, String format, Object ... args) {
        return this.format(locale, format, args);
    }

    public PrintStream format(String format, Object ... args) {
        return this.format(Locale.getDefault(), format, args);
    }

    public PrintStream format(Locale locale, String format, Object ... args) {
        Formatter f = new Formatter(this, locale);
        f.format(format, args);
        return this;
    }
}

