/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessBuilder {
    private File directory = new File(System.getProperty("user.dir"));
    private List<String> command;
    private Map<String, String> environment = new System.EnvironmentMap(System.getenv());
    private boolean redirect = false;

    public ProcessBuilder(List<String> command) {
        this.command = command;
    }

    public ProcessBuilder(String ... command) {
        this.command = Arrays.asList(command);
    }

    public List<String> command() {
        return this.command;
    }

    public ProcessBuilder command(List<String> command) {
        this.command = command;
        return this;
    }

    public ProcessBuilder command(String ... command) {
        this.command = Arrays.asList(command);
        return this;
    }

    public File directory() {
        return this.directory;
    }

    public ProcessBuilder directory(File directory) {
        this.directory = directory;
        return this;
    }

    public Map<String, String> environment() {
        return this.environment;
    }

    public boolean redirectErrorStream() {
        return this.redirect;
    }

    public ProcessBuilder redirectErrorStream(boolean redirect) {
        this.redirect = redirect;
        return this;
    }

    public Process start() throws IOException {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkExec(this.command.get(0));
        }
        return VMProcess.exec(this.command, this.environment, this.directory, this.redirect);
    }
}

