/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class Runtime {
    private final String[] libpath;
    private Thread exitSequence;
    private Set shutdownHooks;
    private boolean finalizeOnExit;
    private static final Runtime current;

    static {
        Runtime.init();
        current = new Runtime();
    }

    private Runtime() {
        if (current != null) {
            throw new InternalError("Attempt to recreate Runtime");
        }
        this.libpath = new String[0];
    }

    public static Runtime getRuntime() {
        return current;
    }

    public void exit(int status) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkExit(status);
        }
        this.exitNoChecks(status);
    }

    static void exitNoChecksAccessor(int status) {
        current.exitNoChecks(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitNoChecks(int status) {
        if (this.runShutdownHooks()) {
            this.exitInternal(status);
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.shutdownHooks != null) {
                this.shutdownHooks.remove(Thread.currentThread());
                this.exitSequence.interrupt();
                status = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (status != 0) {
                this.exitInternal(status);
            }
            while (true) {
                try {
                    while (true) {
                        this.exitSequence.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    boolean runShutdownHooks() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownHook(Thread hook) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        if (hook.isAlive() || hook.getThreadGroup() == null) {
            throw new IllegalArgumentException("The hook thread " + hook + " must not have been already run or started");
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.exitSequence != null) {
                throw new IllegalStateException("The Virtual Machine is exiting. It is not possible anymore to add any hooks");
            }
            if (this.shutdownHooks == null) {
                this.shutdownHooks = new HashSet();
            }
            if (!this.shutdownHooks.add(hook)) {
                throw new IllegalArgumentException(String.valueOf(hook.toString()) + " had already been inserted");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeShutdownHook(Thread hook) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.exitSequence != null) {
                throw new IllegalStateException();
            }
            if (this.shutdownHooks != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.shutdownHooks.remove(hook);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    public void halt(int status) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkExit(status);
        }
        this.exitInternal(status);
    }

    public static void runFinalizersOnExit(boolean finalizeOnExit) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkExit(0);
        }
        Runtime.current.finalizeOnExit = finalizeOnExit;
    }

    public Process exec(String cmdline) throws IOException {
        return this.exec(cmdline, null, null);
    }

    public Process exec(String cmdline, String[] env) throws IOException {
        return this.exec(cmdline, env, null);
    }

    public Process exec(String cmdline, String[] env, File dir) throws IOException {
        StringTokenizer t = new StringTokenizer(cmdline);
        String[] cmd = new String[t.countTokens()];
        int i = 0;
        while (i < cmd.length) {
            cmd[i] = t.nextToken();
            ++i;
        }
        return this.exec(cmd, env, dir);
    }

    public Process exec(String[] cmd) throws IOException {
        return this.exec(cmd, null, null);
    }

    public Process exec(String[] cmd, String[] env) throws IOException {
        return this.exec(cmd, env, null);
    }

    public Process exec(String[] cmd, String[] env, File dir) throws IOException {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkExec(cmd[0]);
        }
        return this.execInternal(cmd, env, dir);
    }

    public native int availableProcessors();

    public native long freeMemory();

    public native long totalMemory();

    public native long maxMemory();

    public native void gc();

    public native void runFinalization();

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);

    public void load(String filename) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkLink(filename);
        }
        this._load(filename, false);
    }

    public void loadLibrary(String libname) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkLink(libname);
        }
        this._load(libname, true);
    }

    public InputStream getLocalizedInputStream(InputStream in) {
        return in;
    }

    public OutputStream getLocalizedOutputStream(OutputStream out) {
        return out;
    }

    native void exitInternal(int var1);

    native void _load(String var1, boolean var2);

    native boolean loadLibraryInternal(String var1);

    private static native void init();

    private native void runFinalizationForExit();

    static native String nativeGetLibname(String var0, String var1);

    native Process execInternal(String[] var1, String[] var2, File var3) throws IOException;
}

