/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import gnu.java.security.jce.prng.SecureRandomAdapter;
import gnu.java.security.jce.prng.Sha160RandomSpi;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Enumeration;
import java.util.Random;

public class SecureRandom
extends Random {
    private static final String SECURE_RANDOM = "SecureRandom";
    private static final long serialVersionUID = 4940670005562187L;
    long counter = 0L;
    Provider provider = null;
    byte[] randomBytes = null;
    int randomBytesUsed = 0;
    SecureRandomSpi secureRandomSpi = null;
    byte[] state = null;
    private String algorithm;
    private boolean isSeeded = false;

    public SecureRandom() {
        Provider[] p = Security.getProviders();
        String classname = null;
        int i = 0;
        while (i < p.length) {
            Enumeration<?> e = p[i].propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("SECURERANDOM.") || (classname = p[i].getProperty(key)) == null) continue;
                try {
                    this.secureRandomSpi = (SecureRandomSpi)Class.forName(classname).newInstance();
                    this.provider = p[i];
                    this.algorithm = key.substring(13);
                    return;
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (Throwable throwable) {}
            }
            ++i;
        }
        this.secureRandomSpi = new Sha160RandomSpi();
        this.algorithm = "Sha160";
    }

    public SecureRandom(byte[] seed) {
        this();
        this.setSeed(seed);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this(secureRandomSpi, provider, "unknown");
    }

    private SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider, String algorithm) {
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static SecureRandom getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return SecureRandom.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static SecureRandom getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if ((provider = provider.trim()).length() == 0) {
            throw new IllegalArgumentException("provider MUST NOT be empty");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return SecureRandom.getInstance(algorithm, p);
    }

    public static SecureRandom getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        CPStringBuilder sb = new CPStringBuilder("SecureRandom for algorithm [").append(algorithm).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(SECURE_RANDOM, algorithm, provider);
            return new SecureRandom((SecureRandomSpi)spi, provider, algorithm);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setSeed(byte[] seed) {
        this.secureRandomSpi.engineSetSeed(seed);
        this.isSeeded = true;
    }

    public void setSeed(long seed) {
        if (this.secureRandomSpi != null) {
            byte[] tmp = new byte[]{(byte)(0xFFL & seed >> 56), (byte)(0xFFL & seed >> 48), (byte)(0xFFL & seed >> 40), (byte)(0xFFL & seed >> 32), (byte)(0xFFL & seed >> 24), (byte)(0xFFL & seed >> 16), (byte)(0xFFL & seed >> 8), (byte)(0xFFL & seed)};
            this.secureRandomSpi.engineSetSeed(tmp);
            this.isSeeded = true;
        }
    }

    public void nextBytes(byte[] bytes) {
        if (!this.isSeeded) {
            this.setSeed(SecureRandom.getSeed(32));
        }
        this.randomBytesUsed += bytes.length;
        ++this.counter;
        this.secureRandomSpi.engineNextBytes(bytes);
    }

    protected final int next(int numBits) {
        if (numBits == 0) {
            return 0;
        }
        byte[] tmp = new byte[(numBits + 7) / 8];
        this.nextBytes(tmp);
        int ret = 0;
        int i = 0;
        while (i < tmp.length) {
            ret |= (tmp[i] & 0xFF) << 8 * i;
            ++i;
        }
        long mask = (1L << numBits) - 1L;
        return (int)((long)ret & mask);
    }

    public static byte[] getSeed(int numBytes) {
        return SecureRandomAdapter.getSeed(numBytes);
    }

    public byte[] generateSeed(int numBytes) {
        return this.secureRandomSpi.engineGenerateSeed(numBytes);
    }
}

