/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimeUnit {
    NANOSECONDS{

        public long toNanos(long d) {
            return d;
        }

        public long toMicros(long d) {
            return d / 1000L;
        }

        public long toMillis(long d) {
            return d / 1000000L;
        }

        public long toSeconds(long d) {
            return d / 1000000000L;
        }

        public long toMinutes(long d) {
            return d / 60000000000L;
        }

        public long toHours(long d) {
            return d / 3600000000000L;
        }

        public long toDays(long d) {
            return d / 86400000000000L;
        }

        public long convert(long d, TimeUnit u) {
            return u.toNanos(d);
        }

        int excessNanos(long d, long m) {
            return (int)(d - m * 1000000L);
        }
    }
    ,
    MICROSECONDS{

        public long toNanos(long d) {
            return 2.x(d, 1000L, 9223372036854775L);
        }

        public long toMicros(long d) {
            return d;
        }

        public long toMillis(long d) {
            return d / 1000L;
        }

        public long toSeconds(long d) {
            return d / 1000000L;
        }

        public long toMinutes(long d) {
            return d / 60000000L;
        }

        public long toHours(long d) {
            return d / 3600000000L;
        }

        public long toDays(long d) {
            return d / 86400000000L;
        }

        public long convert(long d, TimeUnit u) {
            return u.toMicros(d);
        }

        int excessNanos(long d, long m) {
            return (int)(d * 1000L - m * 1000000L);
        }
    }
    ,
    MILLISECONDS{

        public long toNanos(long d) {
            return 3.x(d, 1000000L, 9223372036854L);
        }

        public long toMicros(long d) {
            return 3.x(d, 1000L, 9223372036854775L);
        }

        public long toMillis(long d) {
            return d;
        }

        public long toSeconds(long d) {
            return d / 1000L;
        }

        public long toMinutes(long d) {
            return d / 60000L;
        }

        public long toHours(long d) {
            return d / 3600000L;
        }

        public long toDays(long d) {
            return d / 86400000L;
        }

        public long convert(long d, TimeUnit u) {
            return u.toMillis(d);
        }

        int excessNanos(long d, long m) {
            return 0;
        }
    }
    ,
    SECONDS{

        public long toNanos(long d) {
            return 4.x(d, 1000000000L, 9223372036L);
        }

        public long toMicros(long d) {
            return 4.x(d, 1000000L, 9223372036854L);
        }

        public long toMillis(long d) {
            return 4.x(d, 1000L, 9223372036854775L);
        }

        public long toSeconds(long d) {
            return d;
        }

        public long toMinutes(long d) {
            return d / 60L;
        }

        public long toHours(long d) {
            return d / 3600L;
        }

        public long toDays(long d) {
            return d / 86400L;
        }

        public long convert(long d, TimeUnit u) {
            return u.toSeconds(d);
        }

        int excessNanos(long d, long m) {
            return 0;
        }
    }
    ,
    MINUTES{

        public long toNanos(long d) {
            return 5.x(d, 60000000000L, 153722867L);
        }

        public long toMicros(long d) {
            return 5.x(d, 60000000L, 153722867280L);
        }

        public long toMillis(long d) {
            return 5.x(d, 60000L, 153722867280912L);
        }

        public long toSeconds(long d) {
            return 5.x(d, 60L, 0x222222222222222L);
        }

        public long toMinutes(long d) {
            return d;
        }

        public long toHours(long d) {
            return d / 60L;
        }

        public long toDays(long d) {
            return d / 1440L;
        }

        public long convert(long d, TimeUnit u) {
            return u.toMinutes(d);
        }

        int excessNanos(long d, long m) {
            return 0;
        }
    }
    ,
    HOURS{

        public long toNanos(long d) {
            return 6.x(d, 3600000000000L, 2562047L);
        }

        public long toMicros(long d) {
            return 6.x(d, 3600000000L, 2562047788L);
        }

        public long toMillis(long d) {
            return 6.x(d, 3600000L, 2562047788015L);
        }

        public long toSeconds(long d) {
            return 6.x(d, 3600L, 2562047788015215L);
        }

        public long toMinutes(long d) {
            return 6.x(d, 60L, 0x222222222222222L);
        }

        public long toHours(long d) {
            return d;
        }

        public long toDays(long d) {
            return d / 24L;
        }

        public long convert(long d, TimeUnit u) {
            return u.toHours(d);
        }

        int excessNanos(long d, long m) {
            return 0;
        }
    }
    ,
    DAYS{

        public long toNanos(long d) {
            return 7.x(d, 86400000000000L, 106751L);
        }

        public long toMicros(long d) {
            return 7.x(d, 86400000000L, 106751991L);
        }

        public long toMillis(long d) {
            return 7.x(d, 86400000L, 106751991167L);
        }

        public long toSeconds(long d) {
            return 7.x(d, 86400L, 106751991167300L);
        }

        public long toMinutes(long d) {
            return 7.x(d, 1440L, 0x16C16C16C16C16L);
        }

        public long toHours(long d) {
            return 7.x(d, 24L, 0x555555555555555L);
        }

        public long toDays(long d) {
            return d;
        }

        public long convert(long d, TimeUnit u) {
            return u.toDays(d);
        }

        int excessNanos(long d, long m) {
            return 0;
        }
    };

    static final long C0 = 1L;
    static final long C1 = 1000L;
    static final long C2 = 1000000L;
    static final long C3 = 1000000000L;
    static final long C4 = 60000000000L;
    static final long C5 = 3600000000000L;
    static final long C6 = 86400000000000L;
    static final long MAX = Long.MAX_VALUE;

    private TimeUnit() {
    }

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public long convert(long sourceDuration, TimeUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public long toNanos(long duration) {
        throw new AbstractMethodError();
    }

    public long toMicros(long duration) {
        throw new AbstractMethodError();
    }

    public long toMillis(long duration) {
        throw new AbstractMethodError();
    }

    public long toSeconds(long duration) {
        throw new AbstractMethodError();
    }

    public long toMinutes(long duration) {
        throw new AbstractMethodError();
    }

    public long toHours(long duration) {
        throw new AbstractMethodError();
    }

    public long toDays(long duration) {
        throw new AbstractMethodError();
    }

    abstract int excessNanos(long var1, long var3);

    public void timedWait(Object obj, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            obj.wait(ms, ns);
        }
    }

    public void timedJoin(Thread thread, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            thread.join(ms, ns);
        }
    }

    public void sleep(long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            Thread.sleep(ms, ns);
        }
    }

    /* synthetic */ TimeUnit(String string, int n, TimeUnit timeUnit) {
        this();
    }
}

