/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class MemoryCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private BufferedInputStream buffer;
    private int READLIMIT = 2048;

    public MemoryCacheImageInputStream(InputStream stream) {
        this.stream = stream;
        this.buffer = new BufferedInputStream(stream);
        this.buffer.mark(this.READLIMIT);
    }

    public void close() throws IOException {
        super.close();
        this.stream.close();
    }

    public void flushBefore(long position) throws IOException {
        long prevFlushedPosition = this.getFlushedPosition();
        super.flushBefore(position);
        this.buffer.reset();
        this.buffer.skip(this.getFlushedPosition() - prevFlushedPosition);
        this.buffer.mark(this.READLIMIT);
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return true;
    }

    public int read() throws IOException {
        this.setBitOffset(0);
        int retval = this.buffer.read();
        if (retval != -1) {
            ++this.streamPos;
        }
        return retval;
    }

    public int read(byte[] data, int offset, int len) throws IOException {
        this.setBitOffset(0);
        int retval = this.buffer.read(data, offset, len);
        if (retval != -1) {
            this.streamPos += (long)retval;
        }
        return retval;
    }

    public void seek(long position) throws IOException {
        super.seek(position);
        this.buffer.reset();
        this.buffer.skip(position - this.getFlushedPosition());
    }
}

