/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import gnu.classpath.VMStackWalker;
import gnu.java.lang.CPStringBuilder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.StateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingManager {
    public static final String CPE = "java.naming.spi.CannotProceedException";
    private static InitialContextFactoryBuilder icfb;
    static ObjectFactoryBuilder ofb;

    NamingManager() {
    }

    public static boolean hasInitialContextFactoryBuilder() {
        return icfb != null;
    }

    public static Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        InitialContextFactory icf = null;
        if (icfb != null) {
            icf = icfb.createInitialContextFactory(environment);
        } else {
            String java_naming_factory_initial = null;
            if (environment != null) {
                java_naming_factory_initial = (String)environment.get("java.naming.factory.initial");
            }
            if (java_naming_factory_initial == null) {
                java_naming_factory_initial = System.getProperty("java.naming.factory.initial");
            }
            if (java_naming_factory_initial == null) {
                throw new NoInitialContextException("Can't find property: java.naming.factory.initial");
            }
            try {
                icf = (InitialContextFactory)Class.forName(java_naming_factory_initial, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception exception) {
                NoInitialContextException e = new NoInitialContextException("Can't load InitialContextFactory class: " + java_naming_factory_initial);
                e.setRootCause(exception);
                throw e;
            }
        }
        return icf.getInitialContext(environment);
    }

    static Context getURLContext(Object refInfo, Name name, Context nameCtx, String scheme, Hashtable<?, ?> environment) throws NamingException {
        String prefixes;
        String defaultPrefix = "gnu.javax.naming.jndi.url";
        String finalPrefix = "com.sun.jndi.url";
        CPStringBuilder allPrefixes = new CPStringBuilder();
        if (environment != null && (prefixes = (String)environment.get("java.naming.factory.url.pkgs")) != null) {
            allPrefixes.append(prefixes);
        }
        if ((prefixes = System.getProperty("java.naming.factory.url.pkgs")) != null) {
            if (allPrefixes.length() > 0) {
                allPrefixes.append(':');
            }
            allPrefixes.append(prefixes);
        }
        if (allPrefixes.length() > 0) {
            allPrefixes.append(':');
        }
        allPrefixes.append(defaultPrefix);
        allPrefixes.append(':');
        allPrefixes.append(finalPrefix);
        scheme = String.valueOf(scheme) + "." + scheme + "URLContextFactory";
        StringTokenizer tokens = new StringTokenizer(allPrefixes.toString(), ":");
        while (tokens.hasMoreTokens()) {
            String aTry = tokens.nextToken();
            try {
                String tryClass = String.valueOf(aTry) + "." + scheme;
                Class factoryClass = NamingManager.forName(tryClass);
                if (factoryClass == null) continue;
                try {
                    ObjectFactory factory = (ObjectFactory)factoryClass.newInstance();
                    Object obj = factory.getObjectInstance(refInfo, name, nameCtx, environment);
                    Context ctx = (Context)obj;
                    if (ctx == null) continue;
                    return ctx;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NamingException _5) {
                throw _5;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    static Class forName(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException v0) {
            ctx = VMStackWalker.getClassContext();
            i = 0;
            ** while (i < ctx.length)
        }
lbl-1000:
        // 1 sources

        {
            cl = ctx[i].getClassLoader();
            try {
                if (cl != null) {
                    return Class.forName(className, true, cl);
                }
            }
            catch (ClassNotFoundException v1) {}
            ++i;
            continue;
        }
lbl15:
        // 1 sources

        return null;
    }

    public static Context getURLContext(String scheme, Hashtable<?, ?> environment) throws NamingException {
        return NamingManager.getURLContext(null, null, null, scheme, environment);
    }

    public static void setObjectFactoryBuilder(ObjectFactoryBuilder builder) throws NamingException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        if (ofb != null) {
            throw new IllegalStateException("object factory builder already installed");
        }
        if (builder != null) {
            ofb = builder;
        }
    }

    static StringTokenizer getPlusPath(String property, Hashtable env, Context nameCtx) throws NamingException {
        String path = (String)env.get(property);
        if (nameCtx == null) {
            nameCtx = NamingManager.getInitialContext(env);
        }
        String path2 = (String)nameCtx.getEnvironment().get(property);
        if (path == null) {
            path = path2;
        } else if (path2 != null) {
            path = String.valueOf(path) + ":" + path2;
        }
        return new StringTokenizer(path != null ? path : "", ":");
    }

    public static Object getObjectInstance(Object refInfo, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ObjectFactory factory = null;
        if (ofb != null) {
            factory = ofb.createObjectFactory(refInfo, environment);
        } else {
            Class<?> k;
            Object ref2 = refInfo;
            if (refInfo instanceof Referenceable) {
                ref2 = ((Referenceable)refInfo).getReference();
            }
            if (ref2 instanceof Reference) {
                Reference ref = (Reference)ref2;
                String fClass = ref.getFactoryClassName();
                if (fClass != null) {
                    k = Class.forName(fClass, true, Thread.currentThread().getContextClassLoader());
                    factory = (ObjectFactory)k.newInstance();
                } else {
                    Enumeration<RefAddr> e = ref.getAll();
                    while (e.hasMoreElements()) {
                        Object obj;
                        RefAddr ra = e.nextElement();
                        if (!(ra instanceof StringRefAddr) || !"URL".equals(ra.getType()) || (obj = (factory = (ObjectFactory)((Object)NamingManager.getURLContext(refInfo, name, nameCtx, (String)ra.getContent(), environment))).getObjectInstance(refInfo, name, nameCtx, environment)) == null) continue;
                        return obj;
                    }
                    factory = null;
                }
            }
            if (factory == null) {
                StringTokenizer tokens = NamingManager.getPlusPath("java.naming.factory.object", environment, nameCtx);
                while (tokens.hasMoreTokens()) {
                    String klassName = tokens.nextToken();
                    k = Class.forName(klassName, true, Thread.currentThread().getContextClassLoader());
                    factory = (ObjectFactory)k.newInstance();
                    Object obj = factory.getObjectInstance(refInfo, name, nameCtx, environment);
                    if (obj == null) continue;
                    return obj;
                }
                return refInfo;
            }
        }
        if (factory == null) {
            return refInfo;
        }
        Object obj = factory.getObjectInstance(refInfo, name, nameCtx, environment);
        return obj == null ? refInfo : obj;
    }

    public static void setInitialContextFactoryBuilder(InitialContextFactoryBuilder builder) throws NamingException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        if (icfb != null) {
            throw new IllegalStateException("ctx factory builder already installed");
        }
        if (builder != null) {
            icfb = builder;
        }
    }

    public static Context getContinuationContext(CannotProceedException cpe) throws NamingException {
        Hashtable<?, ?> env = cpe.getEnvironment();
        if (env != null) {
            env.put(CPE, cpe);
        }
        try {
            Object obj = NamingManager.getObjectInstance(cpe.getResolvedObj(), cpe.getAltName(), cpe.getAltNameCtx(), env);
            if (obj != null) {
                return (Context)obj;
            }
        }
        catch (Exception exception) {}
        cpe.fillInStackTrace();
        throw cpe;
    }

    public static Object getStateToBind(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        StringTokenizer tokens = NamingManager.getPlusPath("java.naming.factory.state", environment, nameCtx);
        while (tokens.hasMoreTokens()) {
            String klassName = tokens.nextToken();
            try {
                Class<?> k = Class.forName(klassName, true, Thread.currentThread().getContextClassLoader());
                StateFactory factory = (StateFactory)k.newInstance();
                Object o = factory.getStateToBind(obj, name, nameCtx, environment);
                if (o == null) continue;
                return o;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return obj;
    }
}

