/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListModel
implements ListModel,
Serializable {
    private static final long serialVersionUID = -3285184064379168730L;
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listenerList.add(ListDataListener.class, listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listenerList.remove(ListDataListener.class, listener);
    }

    protected void fireContentsChanged(Object source, int startIndex, int endIndex) {
        ListDataEvent event = new ListDataEvent(source, 0, startIndex, endIndex);
        ListDataListener[] listeners = this.getListDataListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].contentsChanged(event);
            ++index;
        }
    }

    protected void fireIntervalAdded(Object source, int startIndex, int endIndex) {
        ListDataEvent event = new ListDataEvent(source, 1, startIndex, endIndex);
        ListDataListener[] listeners = this.getListDataListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].intervalAdded(event);
            ++index;
        }
    }

    protected void fireIntervalRemoved(Object source, int startIndex, int endIndex) {
        ListDataEvent event = new ListDataEvent(source, 2, startIndex, endIndex);
        ListDataListener[] listeners = this.getListDataListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].intervalRemoved(event);
            ++index;
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.getListeners(ListDataListener.class);
    }
}

